/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.mapping.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.mapping.bean.PropertyModel;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class PropertyUtil {
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final List<String> NUMBER_FIELDS = Arrays.asList("number", "billno", "fnumber", "fbillno", "code", "fcode");

    public static Map<String, PropertyModel> initPropertyMap(long schemaId, String namePrefix, String labelPrefix) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ISC_METADATA_SCHEMA);
        DynamicObject srcSchema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (DynamicObjectType)entityType);
        DynamicObjectCollection props = srcSchema.getDynamicObjectCollection(PROP_ENTRYENTITY);
        LinkedHashMap<String, PropertyModel> propModels = new LinkedHashMap<String, PropertyModel>(props.size());
        for (DynamicObject prop : props) {
            if (PropertyUtil.isAttachField(prop)) continue;
            PropertyModel propertyModel = new PropertyModel(namePrefix, labelPrefix, srcSchema.getLong("group_id"), srcSchema.getString("type"), prop);
            propModels.put(propertyModel.getName(), propertyModel);
        }
        return propModels;
    }

    public static boolean isAttachField(DynamicObject prop) {
        return "$FILE_LIST".equalsIgnoreCase(prop.getString("prop_name")) || "bd_attachment".equals(prop.getString("data_schema")) || "bos_attachment".equals(prop.getString("data_schema"));
    }

    public static String findNumberFieldName(long groupId, String metaSchemaNumber) {
        QFilter filter = new QFilter("group", "=", (Object)groupId).and("number", "=", (Object)metaSchemaNumber);
        DynamicObject obj = MetaDataSchema.getOneByFilter(filter);
        if (obj != null) {
            Set<String> propSet = PropertyUtil.constructPropNameSet(obj);
            for (String numberField : NUMBER_FIELDS) {
                if (!propSet.contains(numberField)) continue;
                return numberField;
            }
        }
        return null;
    }

    private static Set<String> constructPropNameSet(DynamicObject obj) {
        DynamicObjectCollection entries = obj.getDynamicObjectCollection(PROP_ENTRYENTITY);
        HashSet<String> propSet = new HashSet<String>();
        for (DynamicObject entry : entries) {
            propSet.add(entry.getString("prop_name").toLowerCase(Locale.ENGLISH));
        }
        return propSet;
    }

    public static String getDescription(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(map.get("full_name")).append(" - ").append(map.get("data_type"));
        if (D.x(map.get("is_primary_key"))) {
            sb.append(ResManager.loadKDString((String)" - \u4e3b\u952e", (String)"PropertyUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else if (D.x(map.get("required"))) {
            sb.append(ResManager.loadKDString((String)" - \u5fc5\u586b", (String)"PropertyUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public static long getMetaIdByNumber(long groupId, String number) {
        DynamicObject obj = PropertyUtil.getMetaByNumber(groupId, number);
        return obj.getLong("id");
    }

    public static DynamicObject getMetaByNumber(long groupId, String number) {
        QFilter filter = new QFilter("group", "=", (Object)groupId).and("number", "=", (Object)number);
        DynamicObject obj = MetaDataSchema.getOneByFilter(filter);
        if (obj != null) {
            return obj;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u3010%1$s\u3011\u4e2d\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%2$s\u7684\u96c6\u6210\u5bf9\u8c61", (String)"PropertyUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), PropertyUtil.getDescByDsId(groupId), number));
    }

    private static String getDescByDsId(long groupId) {
        DataSource dataSource = DataSource.get(groupId);
        if (dataSource != null) {
            DynamicObject config = dataSource.getConfig();
            return config.getString("name") + '\uff08' + config.getString("number") + '\uff09';
        }
        return "";
    }
}

