/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.e.ServiceUtil;
import kd.isc.iscb.platform.core.dc.e.p.ViewUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.meta.EntrySetter;
import kd.isc.iscb.platform.core.meta.PropInfo;
import kd.isc.iscb.platform.core.meta.SyncMetaJob;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public class MetaSchemaUtil {
    private static final String DB_ROUTER_ISCB = "ISCB";
    private static final String FIELD_GROUP_ID = "group_id";
    private static final String SYSTEM_IERP = "ierp";
    private static final String SYSTEM_SELF = "self";
    private static final String SYSTEM_EAS = "eas";
    private static final String FIELD_TITLE = "title";
    private static final String ENTRIES_EVENTS = "events";
    private static final String ENTRIES_ACTIONS = "actions";
    private static final String DATA_TYPE_STRING = "string";
    private static final String SPECIAL_BIZ_ENTITY_$FILE_LIST = "$file_list";
    private static final String FIELD_DATA_SCHEMA = "data_schema";
    private static final String FIELD_DATA_TYPE = "data_type";
    private static final String FIELD_PROP_LABEL = "prop_label";
    private static final String FIELD_PROP_NAME = "prop_name";
    private static final String ENTRIES_PROPERTIES = "properties";
    private static final String FIELD_ENABLE = "enable";
    private static final String RESULT_JST = "result_jst";
    private static final String RESULT_JST_TAG = "result_jst_tag";
    private static final String FIELD_REMARK = "remark";
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String TYPE_QUERY = "QUERY";
    private static final String TYPE_STRUCT = "STRUCT";
    private static final String TYPE_VIEW = "VIEW";
    private static final String TYPE_SERVICE = "SERVICE";
    private static final String TYPE_ENUM = "ENUM";
    private static final String TYPE_ENTITY = "ENTITY";
    private static final String TYPE_TABLE = "TABLE";
    private static final String TYPE_EVT_RSC = "EVT_RSC";
    private static final String FIELD_MODIFIER = "modifier";
    private static final String FIELD_CREATETIME = "createtime";
    private static final String FIELD_CREATOR = "creator";
    private static final String FIELD_TABLE_NAME = "table_name";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_GROUP = "group";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_FULL_NAME = "full_name";
    private static final String FIELD_ERROR_STACK_TAG = "error_stack_tag";
    private static final String FIELD_ERROR_STACK = "error_stack";
    private static final String FIELD_STATE = "state";
    private static final String FIELD_IS_INIT = "is_init";
    private static final String ENTITY_ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String FIELD_ID = "id";
    private static final String FIELD_DBLINK = "dblink";
    private static final String ENTITY_ISC_DATA_SOURCE = "isc_data_source";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncMetaList(SyncMetaJob job) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)job.getDataSource(), (String)ENTITY_ISC_DATA_SOURCE);
        ConnectionWrapper cn = null;
        ConnectionManager.pushResLicense(true);
        try {
            ConnectionManager.checkConnection(dataSource);
            DynamicObject dbLink = (DynamicObject)dataSource.get(FIELD_DBLINK);
            cn = ConnectionManager.getConnection(dbLink.getLong(FIELD_ID));
            Map<String, MetaType> metas = ConnectionManager.getMetaList(cn);
            job.setTotal(metas.size());
            ArrayList<Object> ids = new ArrayList<Object>(metas.size());
            for (Map.Entry<String, MetaType> entry : metas.entrySet()) {
                SignalManager.checkCancelSignal();
                Object id = MetaSchemaUtil.syncMetaBasic(dataSource, entry);
                ids.add(id);
                job.incBasics();
            }
            for (Map.Entry<String, Object> entry : ids) {
                SignalManager.checkCancelSignal();
                MetaSchemaUtil.syncMetaDetail(dataSource, cn, entry, job);
            }
        }
        catch (Throwable throwable) {
            ConnectionManager.clearTableCache();
            ConnectionManager.popResLicense();
            ConnectorUtil.close(cn);
            throw throwable;
        }
        ConnectionManager.clearTableCache();
        ConnectionManager.popResLicense();
        ConnectorUtil.close(cn);
    }

    private static void syncMetaDetail(DynamicObject dataSource, ConnectionWrapper cn, Object id, SyncMetaJob job) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_METADATA_SCHEMA);
        if (meta.get(FIELD_IS_INIT) == null || !meta.getBoolean(FIELD_IS_INIT)) {
            try {
                MetaSchemaUtil.syncMetaInfo(dataSource, cn, meta);
                job.incSuccess();
            }
            catch (Throwable error) {
                job.incFailed();
                MetaSchemaUtil.saveErrorStack(meta, error);
            }
        } else {
            job.incSuccess();
        }
    }

    private static void saveErrorStack(DynamicObject object, Throwable error) {
        String message = StringUtil.toString((Throwable)error);
        object.set(FIELD_STATE, (Object)"F");
        object.set(FIELD_ERROR_STACK, (Object)StringUtil.trim((String)message, (int)200));
        object.set(FIELD_ERROR_STACK_TAG, (Object)message);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public static Object syncMetaBasic(DynamicObject dataSource, Map.Entry<String, MetaType> e) {
        MetaType type = e.getValue();
        String name = e.getKey();
        switch (type) {
            case TABLE: {
                return MetaSchemaUtil.syncTableBasic(dataSource, name);
            }
            case ENTITY: 
            case ENUM: 
            case SERVICE: 
            case VIEW: 
            case QUERY: 
            case EVT_RSC: {
                return MetaSchemaUtil.syncCommonBasic(dataSource, type, name);
            }
        }
        throw new UnsupportedOperationException(name + ":" + type);
    }

    private static Object syncCommonBasic(DynamicObject dataSource, MetaType metaType, String fullName) {
        DynamicObject existObj = MetaSchemaUtil.getExistMeta(metaType, dataSource, fullName);
        if (existObj == null) {
            DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_METADATA_SCHEMA);
            Long id = MetaSchemaUtil.getHashId(metaType, D.l((Object)dataSource.getPkValue()), fullName);
            newObject.set(FIELD_ID, (Object)id);
            newObject.set(FIELD_FULL_NAME, (Object)fullName);
            newObject.set(FIELD_TYPE, (Object)metaType.name());
            newObject.set(FIELD_GROUP, (Object)dataSource);
            newObject.set(FIELD_IS_INIT, (Object)Boolean.FALSE);
            newObject.set(FIELD_STATUS, (Object)"A");
            newObject.set(FIELD_STATE, (Object)"W");
            MetaSchemaUtil.setCreateInfo(newObject);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
            return id;
        }
        return existObj.get(FIELD_ID);
    }

    private static Object syncTableBasic(DynamicObject dataSource, String table_name) {
        DynamicObject existObj = MetaSchemaUtil.getExistMeta(MetaType.TABLE, dataSource, table_name.toLowerCase());
        if (existObj == null) {
            DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_METADATA_SCHEMA);
            Long id = MetaSchemaUtil.getHashId(MetaType.TABLE, D.l((Object)dataSource.getPkValue()), table_name.toLowerCase());
            newObject.set(FIELD_ID, (Object)id);
            newObject.set(FIELD_NAME, (Object)new LocaleString(table_name.toUpperCase()));
            newObject.set(FIELD_NUMBER, (Object)table_name.toUpperCase());
            newObject.set(FIELD_TABLE_NAME, (Object)table_name);
            newObject.set(FIELD_FULL_NAME, (Object)table_name.toLowerCase());
            newObject.set(FIELD_TYPE, (Object)TYPE_TABLE);
            newObject.set(FIELD_GROUP, (Object)dataSource);
            newObject.set(FIELD_IS_INIT, (Object)Boolean.FALSE);
            newObject.set(FIELD_STATUS, (Object)"A");
            newObject.set(FIELD_STATE, (Object)"W");
            MetaSchemaUtil.setCreateInfo(newObject);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
            return id;
        }
        return existObj.get(FIELD_ID);
    }

    public static Long getHashId(MetaType type, long dataSourceId, String name) {
        return Math.abs(Hash.mur64((byte[])(type + "\r\n" + name + "\r\n" + dataSourceId).getBytes(StandardCharsets.UTF_8)));
    }

    public static void setCreateInfo(DynamicObject o) {
        o.set(FIELD_CREATOR, (Object)RequestContext.get().getUserId());
        o.set(FIELD_CREATETIME, (Object)Timestamp.valueOf(LocalDateTime.now()));
    }

    private static void syncMetaInfo(DynamicObject dataSource, ConnectionWrapper cn, DynamicObject meta) {
        String type = meta.getString(FIELD_TYPE);
        if (type.equalsIgnoreCase(TYPE_TABLE)) {
            MetaSchemaUtil.syncTableInfo(dataSource, cn, meta.getString(FIELD_TABLE_NAME), meta);
        } else if (type.equalsIgnoreCase(TYPE_ENTITY)) {
            MetaSchemaUtil.syncEntityInfo(cn, dataSource, meta);
        } else if (type.equalsIgnoreCase(TYPE_ENUM)) {
            MetaSchemaUtil.syncEnumInfo(dataSource, cn, meta.getString(FIELD_FULL_NAME), meta);
        } else if (type.equalsIgnoreCase(TYPE_QUERY)) {
            MetaSchemaUtil.syncQueryServicInfoX(cn, dataSource, meta);
        } else if (type.equalsIgnoreCase(TYPE_SERVICE)) {
            MetaSchemaUtil.syncServiceInfoX(cn, dataSource, meta);
        } else {
            if (type.equalsIgnoreCase(TYPE_STRUCT)) {
                return;
            }
            if (type.equalsIgnoreCase(TYPE_EVT_RSC)) {
                MetaSchemaUtil.syncEventSrcInfo(cn, dataSource, meta);
            } else {
                throw new UnsupportedOperationException(StringUtil.isEmpty((String)meta.getString(FIELD_FULL_NAME)) ? meta.getString(FIELD_TABLE_NAME) : meta.getString(FIELD_FULL_NAME) + ":" + type);
            }
        }
    }

    private static void syncEnumInfo(DynamicObject dataSource, ConnectionWrapper cn, String enum_name, DynamicObject meta) {
        Map<String, Object> enum_info = ConnectionManager.getEnum(cn, enum_name);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, enum_info, meta)});
    }

    private static void syncTableInfo(DynamicObject dataSource, ConnectionWrapper cn, String table_name, DynamicObject meta) {
        Map<String, Object> table_info = ConnectionManager.getTableInfo(cn, table_name);
        table_info.put(FIELD_FULL_NAME, table_name.toLowerCase());
        table_info.put(FIELD_NAME, table_name.toUpperCase());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, table_info, meta)});
    }

    public static void syncMetaSchema(Object id) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_METADATA_SCHEMA);
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)meta.getLong(FIELD_GROUP_ID), (String)ENTITY_ISC_DATA_SOURCE);
        DynamicObject dbLink = dataSource.getDynamicObject(FIELD_DBLINK);
        if (dbLink == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90(%s)\u6ca1\u6709\u914d\u7f6e\u8fde\u63a5\uff01", (String)"MetaSchemaUtil_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), dataSource.get(FIELD_NUMBER)));
        }
        ConnectionManager.pushResLicense(true);
        try (ConnectionWrapper cn = ConnectionManager.getConnection(dbLink.getLong(FIELD_ID));){
            MetaSchemaUtil.syncMetaSchema(meta, dataSource, cn);
        }
        catch (Throwable error) {
            MetaSchemaUtil.saveErrorStack(meta, error);
            throw error;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private static void syncMetaSchema(DynamicObject meta, DynamicObject dataSource, ConnectionWrapper cn) {
        if (TYPE_TABLE.equals(meta.get(FIELD_TYPE))) {
            Map<String, Object> table_info = ConnectionManager.getTableInfo(cn, meta.getString(FIELD_TABLE_NAME));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, table_info, meta)});
            ConnectionManager.clearTableCache();
        } else if (TYPE_ENTITY.equals(meta.get(FIELD_TYPE))) {
            MetaSchemaUtil.syncEntityInfo(cn, dataSource, meta);
        } else if (TYPE_EVT_RSC.equals(meta.get(FIELD_TYPE))) {
            MetaSchemaUtil.syncEventSrcInfo(cn, dataSource, meta);
        } else if (TYPE_ENUM.equals(meta.get(FIELD_TYPE))) {
            Map<String, Object> enum_info = ConnectionManager.getEnum(cn, meta.getString(FIELD_FULL_NAME));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, enum_info, meta)});
        } else if (TYPE_SERVICE.equals(meta.get(FIELD_TYPE))) {
            MetaSchemaUtil.syncServiceInfoX(cn, dataSource, meta);
        } else if (TYPE_VIEW.equals(meta.get(FIELD_TYPE))) {
            Map<String, Object> view_info = ViewUtil.getViewInfo(cn, meta);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, view_info, meta)});
        } else if (TYPE_STRUCT.equals(meta.get(FIELD_TYPE))) {
            meta.set(FIELD_STATE, (Object)"Z");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{meta});
        } else if (TYPE_QUERY.equals(meta.get(FIELD_TYPE))) {
            MetaSchemaUtil.syncQueryServicInfoX(cn, dataSource, meta);
        } else {
            throw new UnsupportedOperationException(meta.getString(FIELD_TYPE));
        }
    }

    public static void syncEventSrcInfo(ConnectionWrapper cn, DynamicObject dataSource, DynamicObject meta) {
        List<Map<String, Object>> entityInfoList = ConnectionManager.getEventSrc(cn, meta.getString(FIELD_FULL_NAME));
        MetaSchemaUtil.saveSubEntityList(dataSource, meta, entityInfoList);
    }

    public static void syncEntityInfo(ConnectionWrapper cn, DynamicObject dataSource, DynamicObject meta) {
        List<Map<String, Object>> entityInfoList = ConnectionManager.getEntity(cn, meta.getString(FIELD_FULL_NAME));
        MetaSchemaUtil.saveSubEntityList(dataSource, meta, entityInfoList);
    }

    public static void syncServiceInfoX(ConnectionWrapper cn, DynamicObject dataSource, DynamicObject meta) {
        List<Map<String, Object>> serviceInfoList = ConnectionManager.getServiceX(cn, meta.getString(FIELD_FULL_NAME));
        MetaSchemaUtil.saveSubEntityList(dataSource, meta, serviceInfoList);
    }

    public static void syncQueryServicInfoX(ConnectionWrapper cn, DynamicObject dataSource, DynamicObject meta) {
        List<Map<String, Object>> serviceInfoList = ConnectionManager.getServiceX(cn, meta.getString(FIELD_FULL_NAME));
        for (Map<String, Object> svc_info : serviceInfoList) {
            svc_info.put(FIELD_TYPE, TYPE_QUERY);
        }
        MetaSchemaUtil.saveSubEntityList(dataSource, meta, serviceInfoList);
    }

    private static void saveSubEntityList(DynamicObject dataSource, DynamicObject meta, List<Map<String, Object>> entityInfoList) {
        for (Map<String, Object> info : entityInfoList) {
            DynamicObject tempMeta;
            Object hashId;
            String full_name = (String)info.get(FIELD_FULL_NAME);
            if (meta.getString(FIELD_FULL_NAME).equals(full_name)) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, info, meta)});
                continue;
            }
            if (info.get(FIELD_TYPE).equals(TYPE_ENTITY)) {
                hashId = MetaSchemaUtil.syncCommonBasic(dataSource, MetaType.ENTITY, full_name);
                tempMeta = BusinessDataServiceHelper.loadSingle((Object)hashId, (String)ENTITY_ISC_METADATA_SCHEMA);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, info, tempMeta)});
                continue;
            }
            if (info.get(FIELD_TYPE).equals(TYPE_ENUM)) {
                hashId = MetaSchemaUtil.syncCommonBasic(dataSource, MetaType.ENUM, full_name);
                tempMeta = BusinessDataServiceHelper.loadSingle((Object)hashId, (String)ENTITY_ISC_METADATA_SCHEMA);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, info, tempMeta)});
                continue;
            }
            if (!info.get(FIELD_TYPE).equals(TYPE_STRUCT)) continue;
            hashId = MetaSchemaUtil.syncCommonBasic(dataSource, MetaType.STRUCT, full_name);
            tempMeta = BusinessDataServiceHelper.loadSingle((Object)hashId, (String)ENTITY_ISC_METADATA_SCHEMA);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{MetaSchemaUtil.generateSchema(dataSource, info, tempMeta)});
        }
    }

    public static DynamicObject getExistMeta(MetaType type, DynamicObject dataSource, String full_name) {
        Long id = MetaSchemaUtil.getHashId(type, D.l((Object)dataSource.getPkValue()), full_name);
        QFilter qFilter = new QFilter(FIELD_ID, "=", (Object)id);
        return QueryServiceHelper.queryOne((String)ENTITY_ISC_METADATA_SCHEMA, (String)FIELD_ID, (QFilter[])new QFilter[]{qFilter});
    }

    private static DynamicObject generateSchema(DynamicObject dataSource, Map<String, Object> meta_info, DynamicObject object) {
        Object errorStack;
        object.set(FIELD_MODIFIER, (Object)RequestContext.get().getUserId());
        object.set(FIELD_MODIFYTIME, (Object)Timestamp.valueOf(LocalDateTime.now()));
        object.set(FIELD_TYPE, MetaSchemaUtil.getType(meta_info, object));
        object.set(FIELD_NUMBER, meta_info.get(FIELD_NAME));
        if (meta_info.get(FIELD_TITLE) != null) {
            object.set(FIELD_NAME, (Object)new LocaleString(StringUtil.trim((Object)meta_info.get(FIELD_TITLE), (int)50)));
        }
        object.set(FIELD_GROUP, (Object)dataSource);
        object.set(FIELD_FULL_NAME, meta_info.get(FIELD_FULL_NAME));
        object.set(FIELD_TABLE_NAME, meta_info.get(FIELD_TABLE_NAME));
        if (D.s((Object)meta_info.get(FIELD_REMARK)) != null) {
            object.set(FIELD_REMARK, (Object)StringUtil.trim((String)D.s((Object)meta_info.get(FIELD_REMARK)), (int)150));
        }
        if (!StringUtil.isEmpty((String)D.s((Object)meta_info.get(RESULT_JST)))) {
            object.set(RESULT_JST, meta_info.get(RESULT_JST));
        }
        if (!StringUtil.isEmpty((String)D.s((Object)meta_info.get(RESULT_JST_TAG)))) {
            object.set(RESULT_JST_TAG, meta_info.get(RESULT_JST_TAG));
        }
        if ((errorStack = meta_info.get(FIELD_ERROR_STACK)) != null) {
            object.set(FIELD_ERROR_STACK, (Object)errorStack.toString());
            object.set(FIELD_ERROR_STACK_TAG, (Object)StringUtil.toString((Throwable)((Throwable)errorStack)));
            object.set(FIELD_STATE, (Object)"F");
        } else {
            object.set(FIELD_ERROR_STACK, null);
            object.set(FIELD_ERROR_STACK_TAG, null);
            object.set(FIELD_STATE, (Object)"S");
        }
        object.set(FIELD_STATUS, (Object)"A");
        object.set(FIELD_ENABLE, (Object)"1");
        object.set(FIELD_IS_INIT, (Object)Boolean.TRUE);
        EntrySetter.PROPERTIES.init(object, meta_info);
        EntrySetter.CONSTS.init(object, meta_info);
        EntrySetter.FLEX.init(object, meta_info);
        EntrySetter.ACTIONS.init(object, meta_info);
        EntrySetter.EVENTS.init(object, meta_info);
        EntrySetter.PARAMS.init(object, meta_info);
        EntrySetter.RETURNS.init(object, meta_info);
        return object;
    }

    private static Object getType(Map<String, Object> meta_info, DynamicObject object) {
        Object type = D.s((Object)meta_info.get(FIELD_TYPE));
        if (type == null) {
            type = object.get(FIELD_TYPE);
        }
        return type;
    }

    public static Object callService(String dsNumber, String service, Map<String, Object> params, String proxy_user) {
        Assert.notNull((Object)dsNumber, (String)ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7f16\u7801\u4e3a\u7a7a!", (String)"MetaSchemaUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Assert.notNull((Object)service, (String)ResManager.loadKDString((String)"\u670d\u52a1\u540d\u4e3a\u7a7a!", (String)"MetaSchemaUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DataSource dataSource = DataSource.get(dsNumber);
        Assert.notNull((Object)dataSource, (String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u662f\uff08%s\uff09\u7684\u6570\u636e\u6e90", (String)"MetaSchemaUtil_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), dsNumber));
        DynamicObject ds = dataSource.getConfig();
        DynamicObject meta = MetaDataSchema.get(ds.getLong(FIELD_ID), service, TYPE_SERVICE, TYPE_QUERY);
        return MetaSchemaUtil.callService(ds, meta, params, proxy_user);
    }

    public static Object callService(String formalDataSourceNumber, String realDataSourceNumber, String service, Map<String, Object> params, String proxy_user) {
        Assert.notNull((Object)formalDataSourceNumber, (String)ResManager.loadKDString((String)"\u540d\u4e49\u6570\u636e\u6e90\u7f16\u7801\u4e3a\u7a7a!", (String)"MetaSchemaUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Assert.notNull((Object)realDataSourceNumber, (String)ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u636e\u6e90\u7f16\u7801\u4e3a\u7a7a!", (String)"MetaSchemaUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Assert.notNull((Object)service, (String)ResManager.loadKDString((String)"\u670d\u52a1\u540d\u4e3a\u7a7a!", (String)"MetaSchemaUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DynamicObject ds = DataSource.get(formalDataSourceNumber).getConfig();
        DynamicObject meta = MetaDataSchema.get(ds.getLong(FIELD_ID), service, TYPE_SERVICE, TYPE_QUERY);
        DynamicObject redirect = DataSource.get(realDataSourceNumber).getConfig();
        return MetaSchemaUtil.callService(redirect, meta, params, proxy_user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callService(DynamicObject dataSource, DynamicObject serviceMeta, Map<String, Object> params, String proxy_user) {
        Object result;
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(serviceMeta));
        try {
            result = ServiceUtil.callService(ConnectionManager.getConnection(dataSource.getLong("dblink_id")), serviceMeta, params, proxy_user);
        }
        finally {
            ConnectionManager.popResLicense();
        }
        if (result instanceof ObjectReader) {
            ObjectReader reader = (ObjectReader)result;
            ArrayList<Object> list = new ArrayList<Object>(Math.max(reader.getTotalCount(), 0));
            Object o = reader.read();
            while (o != null) {
                list.add(o);
                if (list.size() > 10000) {
                    throw new IscBizException(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u6570\u8d85\u8fc710000\u884c!", (String)"MetaSchemaUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                }
                o = reader.read();
            }
            return list;
        }
        return result;
    }

    public static DynamicObject createVirtualFileListMeta(DynamicObject dataSource) {
        DynamicObject existMeta = MetaSchemaUtil.getExistMeta(MetaType.ENTITY, dataSource, SPECIAL_BIZ_ENTITY_$FILE_LIST);
        if (existMeta == null) {
            HashMap<String, MetaType> metas = new HashMap<String, MetaType>();
            metas.put(SPECIAL_BIZ_ENTITY_$FILE_LIST, MetaType.ENTITY);
            Object id = null;
            for (Map.Entry<String, MetaType> entry : metas.entrySet()) {
                id = MetaSchemaUtil.syncMetaBasic(dataSource, entry);
            }
            DynamicObject meta = BusinessDataServiceHelper.loadSingle(id, (String)ENTITY_ISC_METADATA_SCHEMA);
            Map map = (Map)JSON.toJSON((Object)new PropInfo(1, "srcAttachId", DATA_TYPE_STRING, ResManager.loadKDString((String)"\u6e90\u9644\u4ef6id", (String)"MetaSchemaUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
            Map map2 = (Map)JSON.toJSON((Object)new PropInfo(2, "tarAttachId", DATA_TYPE_STRING, ResManager.loadKDString((String)"\u76ee\u6807\u9644\u4ef6id", (String)"MetaSchemaUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
            Map map3 = (Map)JSON.toJSON((Object)new PropInfo(3, FIELD_NAME, DATA_TYPE_STRING, ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"MetaSchemaUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
            Map map4 = (Map)JSON.toJSON((Object)new PropInfo(4, FIELD_TYPE, DATA_TYPE_STRING, ResManager.loadKDString((String)"\u9644\u4ef6\u7c7b\u578b", (String)"MetaSchemaUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
            Map map5 = (Map)JSON.toJSON((Object)new PropInfo(5, "bytes", "int", ResManager.loadKDString((String)"\u5b57\u8282\u6570", (String)"MetaSchemaUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
            Map map6 = (Map)JSON.toJSON((Object)new PropInfo(6, "desc", DATA_TYPE_STRING, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"MetaSchemaUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
            ArrayList<Map> properties = new ArrayList<Map>(Arrays.asList(map, map2, map3, map4, map5, map6));
            HashMap<String, Object> meta_info = new HashMap<String, Object>();
            meta_info.put(ENTRIES_PROPERTIES, properties);
            meta_info.put(ENTRIES_ACTIONS, Collections.emptyList());
            meta_info.put(ENTRIES_EVENTS, Collections.emptyList());
            meta_info.put(FIELD_TYPE, TYPE_ENTITY);
            meta_info.put(FIELD_TITLE, ResManager.loadKDString((String)"\u865a\u62df\u9644\u4ef6\u5206\u5f55", (String)"MetaSchemaUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            meta_info.put(FIELD_NAME, SPECIAL_BIZ_ENTITY_$FILE_LIST);
            meta_info.put(FIELD_GROUP, dataSource);
            meta_info.put(FIELD_FULL_NAME, SPECIAL_BIZ_ENTITY_$FILE_LIST);
            meta_info.put(FIELD_REMARK, "ENTRIES");
            MetaSchemaUtil.generateSchema(dataSource, meta_info, meta);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{meta});
            return meta;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)existMeta.get(FIELD_ID), (String)ENTITY_ISC_METADATA_SCHEMA);
    }

    public static Map<String, Map<String, Object>> getAttachmentPropInfo(long srcMetaId, long tarMetaId) {
        DynamicObject tar;
        DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)srcMetaId, (String)ENTITY_ISC_METADATA_SCHEMA, (String)FIELD_GROUP);
        if (!MetaSchemaUtil.supportsFileTransportation(src, tar = BusinessDataServiceHelper.loadSingle((Object)tarMetaId, (String)ENTITY_ISC_METADATA_SCHEMA, (String)FIELD_GROUP))) {
            return Collections.emptyMap();
        }
        String type = MetaSchemaUtil.getTargetType(tar.getLong(FIELD_GROUP_ID));
        if (SYSTEM_EAS.equals(type) || "k3cloud".equals(type)) {
            return MetaSchemaUtil.getEASFilePropInfo();
        }
        if (SYSTEM_SELF.equals(type) || SYSTEM_IERP.equals(type)) {
            return MetaSchemaUtil.getIERPFilePropInfo(tarMetaId);
        }
        return Collections.emptyMap();
    }

    private static Map<String, Map<String, Object>> getEASFilePropInfo() {
        HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, String> map = new HashMap<String, String>(8);
        String key = "$file_list.attachId";
        map.put(FIELD_PROP_NAME, key);
        map.put(FIELD_PROP_LABEL, ResManager.loadKDString((String)"\u9644\u4ef6id", (String)"MetaSchemaUtil_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        map.put(FIELD_DATA_TYPE, DATA_TYPE_STRING);
        map.put(FIELD_DATA_SCHEMA, null);
        ret.put(key, map);
        return ret;
    }

    private static Map<String, Map<String, Object>> getIERPFilePropInfo(long tarMetaId) {
        String sql = "SELECT p.fname, p.flabel, p.fdata_type, p.fdata_schema FROM t_isc_dataproperty p inner join t_isc_dataschema m on p.fid = m.fid where m.fid = ? and (p.fdata_schema = 'bd_attachment' or p.fdata_schema = 'bos_attachment')";
        return (Map)DB.query((DBRoute)DBRoute.of((String)DB_ROUTER_ISCB), (String)sql, (Object[])new Object[]{tarMetaId}, rs -> {
            HashMap ret = new HashMap(2);
            while (rs.next()) {
                String key = rs.getString(1) + ".id";
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put(FIELD_PROP_NAME, key);
                map.put(FIELD_PROP_LABEL, rs.getString(2));
                map.put(FIELD_DATA_TYPE, "long");
                map.put(FIELD_DATA_SCHEMA, rs.getString(4));
                ret.put(key, map);
            }
            return ret;
        });
    }

    private static String getTargetType(long dataSourceId) {
        String sql = "SELECT l.fdatabase_type FROM T_ISC_DATABASE_LINK l inner join T_ISC_DATASOURCE d on l.fid = d.fdblink WHERE d.FID = ?";
        return (String)DB.query((DBRoute)DBRoute.of((String)DB_ROUTER_ISCB), (String)sql, (Object[])new Object[]{dataSourceId}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            throw new IscBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8fde\u63a5\u7c7b\u578b\uff0c\u8bf7\u786e\u4fdd\u8fde\u63a5\u7c7b\u578b\u914d\u7f6e\u6b63\u786e!", (String)"MetaSchemaUtil_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        });
    }

    /*
     * Exception decompiling
     */
    private static boolean supportsFileTransportation(DynamicObject src, DynamicObject tar) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

