/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.meta.SyncMetaJobFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class SyncMetaJob
implements Job {
    public static final JobFactory FACTORY = new SyncMetaJobFactory();
    private long dataSource;
    private boolean syncAll;
    private String pageId;
    private String number;
    private int total = 0;
    private int basics = 0;
    private int success = 0;
    private int failed = 0;
    private long startTime = System.currentTimeMillis();

    SyncMetaJob(long dataSource, String number, boolean syncAll, String pageId) {
        this.dataSource = dataSource;
        this.syncAll = syncAll;
        this.pageId = pageId;
        this.number = number;
    }

    SyncMetaJob(Map<?, ?> params, String number) {
        this.dataSource = D.l(params.get("d"));
        this.syncAll = D.x(params.get("a"));
        this.pageId = D.s(params.get("p"));
        this.number = number;
    }

    @Override
    public long getOwnerId() {
        return this.dataSource;
    }

    public long getDataSource() {
        return this.dataSource;
    }

    @Override
    public void run() {
        MetaSchemaUtil.syncMetaList(this);
    }

    @Override
    public String getParam() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("d", this.dataSource);
        params.put("a", this.syncAll);
        params.put("p", this.pageId);
        return Json.toString(params);
    }

    @Override
    public String getTitle() {
        return this.number;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    synchronized void setTotal(int total) {
        this.total = total;
    }

    @Override
    public synchronized String refreshProgress() {
        if (this.total == 0) {
            return ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2...", (String)"SyncMetaJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return this.total + "/" + this.basics + "/" + this.success + "/" + this.failed;
    }

    @Override
    public synchronized Job.Progress getRealtimeProgress() {
        if (this.total == 0) {
            long elapsed = System.currentTimeMillis() - this.startTime;
            StringBuilder description = new StringBuilder(ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2...", (String)"SyncMetaJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            int j = Math.min(30, (int)(elapsed / 5000L));
            for (int i = 0; i < j; ++i) {
                description.append('.');
            }
            return new Job.Progress(200L, 1L, description.toString());
        }
        int completed = this.success + this.failed;
        String s = completed == 0 ? String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5143\u6570\u636e\u5217\u8868\uff1a%1$s / %2$s", (String)"SyncMetaJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.basics, this.total) : String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e\uff0c\u603b\u8ba1\uff1a%1$s\uff0c\u6210\u529f\uff1a%2$s\uff0c \u5931\u8d25\uff1a%3$s", (String)"SyncMetaJob_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.success, this.failed);
        return new Job.Progress(this.total * 5 + 5, 5 + this.basics + 4 * completed, s);
    }

    synchronized void incBasics() {
        ++this.basics;
    }

    synchronized void incSuccess() {
        ++this.success;
    }

    synchronized void incFailed() {
        ++this.failed;
    }
}

