/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta.build;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.dao.DesignerData;
import kd.bos.exception.KDBizException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.filter.FastSearchGridViewAp;
import kd.bos.metadata.filter.FilterColumnAp;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.meta.build.FormMetaDefine;
import kd.isc.iscb.platform.core.meta.build.FormMetaDefineUtil;
import kd.isc.iscb.platform.core.meta.build.container.BaseInfoPanel;
import kd.isc.iscb.platform.core.meta.build.container.EntryInfoPanel;
import kd.isc.iscb.platform.core.meta.build.container.Panel;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XFieldCfg;
import kd.isc.iscb.platform.core.meta.build.help.BasePanelHelper;
import kd.isc.iscb.platform.core.meta.build.help.EntryPanelHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.misc.SystemContext;

public class FormMetaDesign {
    private FormMetaDefine formMetaDefine;
    private DesignerData designerData;

    public FormMetaDesign(FormMetaDefine formMetaDefine) {
        this.formMetaDefine = formMetaDefine;
        this.designerData = new DesignerData();
    }

    public Map<String, Object> save(String formId) {
        if (!FormMetaDefineUtil.hasPermission()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e0b\u4e0d\u5141\u8bb8\u751f\u6210\u4e2d\u95f4\u8868\u3002", (String)"FormMetaDesign_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (SystemContext.isProcEnv()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5f0f\u73af\u5883\u4e0b\u4e0d\u5141\u8bb8\u751f\u6210\u4e2d\u95f4\u8868\u3002", (String)"FormMetaDesign_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        Map<Object, Object> result = new HashMap();
        result = D.s((Object)formId) != null ? this.updateFormMeta() : this.createFormMeta();
        return result;
    }

    public Map<String, Object> updateFormMeta() {
        String formName = this.formMetaDefine.getFormName().getLocaleValue_zh_CN();
        String formNumber = this.formMetaDefine.getFormNumber();
        String formId = this.formMetaDefine.getFormId();
        String formNumber_ = MetadataDao.getNumberById((String)formId);
        if (formNumber_ != null && !formNumber_.equals(formNumber)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5bf9\u5e94\u7684\u5355\u636e\u5143\u6570\u636e\u6a21\u578b\u3010%2$s\u3011\u6807\u8bc6\u5df2\u88ab\u7be1\u6539\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u5e73\u53f0\u624b\u52a8\u6539\u56de\uff1a%3$s", (String)"FormMetaDesign_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), formNumber, formNumber_, formNumber));
        }
        String lang = RequestContext.get().getLang().name();
        FormMetadata formMeta = this.readFormMetaData(formName, formNumber, formId);
        Map oldMetaDataMap = formMeta.buildDesignMeta(lang);
        EntityMetadata entityMeta = this.readEntityMetaData(formMeta);
        this.beginDesign(formMeta, entityMeta);
        formMeta.bindEntityMetadata(entityMeta);
        Map metaDataMap = formMeta.buildDesignMeta(lang);
        Map result = this.designerData.save(metaDataMap, oldMetaDataMap);
        if (!D.x(result.get("success"))) {
            StringBuilder s = this.parseErrorInfo(result);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5143\u6570\u636e\u53d1\u751f\u9519\u8bef,\u539f\u56e0\uff1a%s", (String)"FormMetaDesign_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s));
        }
        return result;
    }

    private StringBuilder parseErrorInfo(Map<String, Object> result) {
        List errorInfos = (List)result.get("errors");
        StringBuilder s = new StringBuilder();
        for (ErrorInfo errorInfo : errorInfos) {
            s.append(errorInfo.getPropertyName()).append(":").append(errorInfo.getError()).append('\n');
        }
        return s;
    }

    private FormMetadata readFormMetaData(String formName, String formNumber, String formId) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        if (formMeta == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"FormMetaDesign_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        List<String> templates = Arrays.asList(formMeta.getInheritPath().split(","));
        if (!templates.contains("43+CO6EH2O8Y")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7981\u6b62\u4fee\u6539\uff0c\u5143\u6570\u636e%1$s\u3010%2$s\u3011\u4e0d\u662f\u96c6\u6210\u901a\u7528\u57fa\u7840\u8d44\u6599\u6a21\u677fisc_basedata_template\u6d3e\u751f\u51fa\u6765\u7684", (String)"FormMetaDesign_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), formName, formNumber));
        }
        this.setListTile(formMeta);
        formMeta.setName(this.formMetaDefine.getFormName());
        return formMeta;
    }

    private EntityMetadata readEntityMetaData(FormMetadata formMeta) {
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        entityMeta.setName(this.formMetaDefine.getFormName());
        return entityMeta;
    }

    private void setListTile(FormMetadata formMeta) {
        for (ControlAp item : formMeta.getItems()) {
            if (!(item instanceof BasedataFormAp)) continue;
            BasedataFormAp basedataFormAp = (BasedataFormAp)item;
            FormMetadata formMetadata = basedataFormAp.getListMeta();
            formMetadata.setName(this.formMetaDefine.getFormName());
            break;
        }
    }

    public Map<String, Object> createFormMeta() {
        HashMap<String, Object> res = new HashMap<String, Object>(8);
        Map<String, Object> metaDataMap = this.newFormMeta();
        Map saveResult = this.designerData.save(metaDataMap);
        if (!D.x(saveResult.get("success"))) {
            StringBuilder s = this.parseErrorInfo(saveResult);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5143\u6570\u636e\u53d1\u751f\u9519\u8bef,\u539f\u56e0:%s", (String)"FormMetaDesign_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s));
        }
        DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
        dObject.set("bizapp", (Object)this.formMetaDefine.getBizAppId());
        dObject.set("bizunit", (Object)this.formMetaDefine.getBizUnitId());
        dObject.set("form", metaDataMap.get("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
        res.put("formid", D.s((Object)metaDataMap.get("id")));
        res.put("status", "success");
        return res;
    }

    private String getInheritPath(FormMetadata formMeta) {
        String inheritPath = formMeta.getInheritPath();
        return StringUtils.isNotEmpty((String)inheritPath) ? inheritPath + ',' + "43+CO6EH2O8Y" : "43+CO6EH2O8Y";
    }

    private void setInheritFlag(List<? extends AbstractElement> els) {
        for (AbstractElement abstractElement : els) {
            abstractElement.setInherit(true);
        }
    }

    private Map<String, Object> newFormMeta() {
        FormMetadata formMeta = this.newFormMetaData();
        EntityMetadata entityMeta = this.newEntityMetaData(formMeta);
        this.beginDesign(formMeta, entityMeta);
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isEmpty((String)currentIsv)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"FormMetaDesign_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        entityMeta.setIsv(currentIsv);
        formMeta.setIsv(currentIsv);
        return formMeta.buildDesignMeta(RequestContext.get().getLang().name());
    }

    private EntityMetadata newEntityMetaData(FormMetadata formMeta) {
        String appId = this.formMetaDefine.getBizAppId();
        LocaleString formName = this.formMetaDefine.getFormName();
        String formNumber = this.formMetaDefine.getFormNumber();
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        MainEntity mainEntity = entityMeta.getRootEntity();
        entityMeta.setId(formMeta.getId());
        entityMeta.setParentId("43+CO6EH2O8Y");
        entityMeta.setModelType("BaseFormModel");
        mainEntity.setTemplate(false);
        ((BaseEntity)mainEntity).setDefaultPageSetting("{\"mblist\":\"\",\"pclist\":\"\",\"pcbill\":\"\",\"mbbill\":\"\"}");
        entityMeta.setName(formName);
        entityMeta.setKey(formNumber);
        mainEntity.setKey(formNumber);
        mainEntity.setTableName(this.formMetaDefine.getTableName());
        mainEntity.setdbRoute(this.formMetaDefine.getDBRoute());
        entityMeta.setBizappId(appId);
        this.setInheritFlag(entityMeta.getItems());
        formMeta.setEntityId(entityMeta.getId());
        formMeta.bindEntityMetadata(entityMeta);
        return entityMeta;
    }

    private FormMetadata newFormMetaData() {
        String appId = this.formMetaDefine.getBizAppId();
        LocaleString formName = this.formMetaDefine.getFormName();
        String formNumber = this.formMetaDefine.getFormNumber();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)"43+CO6EH2O8Y", (MetaCategory)MetaCategory.Form);
        formMeta.setId(DBServiceHelper.genStringId());
        formMeta.setParentId("43+CO6EH2O8Y");
        formMeta.setName(formName);
        formMeta.setKey(formNumber);
        formMeta.setModelType("BaseFormModel");
        formMeta.setInheritPath(this.getInheritPath(formMeta));
        formMeta.setDevType("0");
        formMeta.setBizappId(appId);
        this.setInheritFlag(formMeta.getItems());
        this.createMetaBuildContext(formMeta);
        this.setListTile(formMeta);
        return formMeta;
    }

    private void beginDesign(FormMetadata formMeta, EntityMetadata entityMetadata) {
        List<Panel> panelList = this.formMetaDefine.getPanelList();
        BasePanelHelper fieldPanelApBuilder = new BasePanelHelper(formMeta, entityMetadata);
        EntryPanelHelper entryPanelHelper = new EntryPanelHelper(formMeta, entityMetadata);
        for (Panel panel : panelList) {
            if (panel instanceof BaseInfoPanel) {
                fieldPanelApBuilder.save((BaseInfoPanel)panel);
                continue;
            }
            if (panel instanceof EntryInfoPanel) {
                entryPanelHelper.save((EntryInfoPanel)panel);
                continue;
            }
            throw new IscBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u9762\u677f\u7c7b\u578b\u3002", (String)"FormMetaDesign_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        entryPanelHelper.deleteAdvPanel(panelList);
        BasedataFormAp basedataFormAp = this.findBaseAp(formMeta);
        FormMetadata formMetadata = basedataFormAp.getListMeta();
        this.addGridViewField(panelList, formMetadata);
        this.addSearchViewField(panelList, formMetadata);
    }

    private void addSearchViewField(List<Panel> panelList, FormMetadata formMetadata) {
        String searchViewId = this.findSearchViewId(formMetadata);
        formMetadata.getItems().removeIf(ap -> ap.getKey().startsWith("isc_s"));
        for (Panel panel : panelList) {
            List<XFieldCfg> list = panel.getXFields();
            for (XFieldCfg xFieldCfg : list) {
                FilterColumnAp listColumnAp;
                if (!xFieldCfg.isShowInSearch() || (listColumnAp = xFieldCfg.getFilterColumnAp(searchViewId)) == null) continue;
                formMetadata.getItems().add(listColumnAp);
            }
        }
    }

    private void addGridViewField(List<Panel> panelList, FormMetadata formMetadata) {
        String gridViewId = this.findGridViewId(formMetadata);
        formMetadata.getItems().removeIf(ap -> ap.getKey().startsWith("isc_l"));
        int i = 1;
        for (Panel panel : panelList) {
            List<XFieldCfg> list = panel.getXFields();
            for (XFieldCfg xFieldCfg : list) {
                ListColumnAp listColumnAp;
                if (!xFieldCfg.isShowInList() || (listColumnAp = xFieldCfg.getListColumnAp(gridViewId)) == null) continue;
                if (i == 1) {
                    listColumnAp.setHyperlink(true);
                }
                ++i;
                formMetadata.getItems().add(listColumnAp);
            }
        }
    }

    private String findSearchViewId(FormMetadata formMetadata) {
        String searchViewId = null;
        for (ControlAp ap : formMetadata.getItems()) {
            if (!(ap instanceof FastSearchGridViewAp) || !ap.getKey().equals("fastsearchgridview")) continue;
            FastSearchGridViewAp searchGridView = (FastSearchGridViewAp)ap;
            searchViewId = searchGridView.getId();
        }
        if (searchViewId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5feb\u901f\u8fc7\u6ee4\u89c6\u56fe\u63a7\u4ef6", (String)"FormMetaDesign_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return searchViewId;
    }

    private String findGridViewId(FormMetadata formMetadata) {
        String gridViewId = null;
        for (ControlAp ap : formMetadata.getItems()) {
            if (!(ap instanceof ListGridViewAp) || !ap.getKey().equals("gridview")) continue;
            ListGridViewAp gridView = (ListGridViewAp)ap;
            gridViewId = gridView.getId();
            break;
        }
        if (gridViewId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8868\u683c\u89c6\u56fe\u63a7\u4ef6", (String)"FormMetaDesign_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return gridViewId;
    }

    private BasedataFormAp findBaseAp(FormMetadata formMeta) {
        BasedataFormAp basedataFormAp = null;
        for (ControlAp item : formMeta.getItems()) {
            if (!(item instanceof BasedataFormAp)) continue;
            basedataFormAp = (BasedataFormAp)item;
            break;
        }
        if (basedataFormAp == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230BasedataFormAp\u63a7\u4ef6", (String)"FormMetaDesign_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return basedataFormAp;
    }

    private void createMetaBuildContext(FormMetadata formMeta) {
        MetaBuildContext context = new MetaBuildContext();
        formMeta.setBuildContext(context);
    }
}

