/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta.build.help;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.isc.iscb.platform.core.meta.build.FormMetaDefineUtil;
import kd.isc.iscb.platform.core.meta.build.container.BaseInfoPanel;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XFieldCfg;
import kd.isc.iscb.platform.core.meta.build.help.FieldCfgHelper;
import kd.isc.iscb.util.dt.D;

public class BasePanelHelper {
    private FormMetadata formMeta;
    private EntityMetadata entityMeta;
    List<ControlAp<?>> ctrlAps;
    List<EntityItem<?>> entityItems;
    private Map<String, ControlAp<?>> ctrlApsMap = new HashMap(16);
    private Map<String, EntityItem<?>> entityItemsMap = new HashMap(16);

    public BasePanelHelper(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.formMeta = formMeta;
        this.entityMeta = entityMeta;
        this.ctrlAps = this.formMeta.getItems();
        this.entityItems = this.entityMeta.getItems();
        for (ControlAp<?> controlAp : this.ctrlAps) {
            this.ctrlApsMap.put(controlAp.getKey(), controlAp);
        }
        for (EntityItem entityItem : this.entityItems) {
            this.entityItemsMap.put(entityItem.getKey(), entityItem);
        }
    }

    public void createControlAp(BaseInfoPanel panel) {
        FieldsetPanelAp panelAp = panel.createFieldsetPanelAp();
        this.ctrlAps.add((ControlAp<?>)panelAp);
        List<FieldAp> fieldAps = panel.createFieldAps();
        this.ctrlAps.addAll(fieldAps);
        List<XFieldCfg> xFields = panel.getXFields();
        List<Field<?>> fields = FieldCfgHelper.createFields(xFields);
        this.entityItems.addAll(fields);
    }

    public void save(BaseInfoPanel panelApCfg) {
        FieldsetPanelAp panelAp = (FieldsetPanelAp)this.ctrlApsMap.get(panelApCfg.getKey());
        if (panelAp == null) {
            this.createControlAp(panelApCfg);
        } else {
            panelApCfg.updateFieldsetPanelAp(panelAp);
            List<XFieldCfg> fieldCfgLi = panelApCfg.getXFields();
            this.deleteControlAp(fieldCfgLi);
            Set<String> ctrlApKeys = this.ctrlApsMap.keySet();
            ArrayList<XFieldCfg> addFieldList = new ArrayList<XFieldCfg>();
            for (XFieldCfg cfg : fieldCfgLi) {
                if (ctrlApKeys.contains(cfg.getKey())) continue;
                addFieldList.add(cfg);
            }
            List<FieldAp> fieldAps = FieldCfgHelper.createFieldAps(addFieldList, panelAp.getId());
            this.ctrlAps.addAll(fieldAps);
            List<Field<?>> fields = FieldCfgHelper.createFields(addFieldList);
            this.entityItems.addAll(fields);
            List<XFieldCfg> updateFields = FormMetaDefineUtil.getUpdateFields(fieldCfgLi, addFieldList);
            FieldCfgHelper.updateFieldAps(updateFields, this.ctrlApsMap);
            FieldCfgHelper.updateField(updateFields, this.entityItemsMap);
        }
    }

    private void deleteControlAp(List<XFieldCfg> fieldCfgLi) {
        ArrayList<String> iscFieldApCfgKey = new ArrayList<String>(fieldCfgLi.size());
        for (XFieldCfg xFieldCfg : fieldCfgLi) {
            iscFieldApCfgKey.add(xFieldCfg.getKey());
        }
        ArrayList<String> deleteFieldKey = new ArrayList<String>();
        for (ControlAp<?> controlAp : this.ctrlApsMap.values()) {
            if (!(controlAp instanceof FieldAp) || controlAp instanceof EntryFieldAp || iscFieldApCfgKey.contains(D.s((Object)controlAp.getKey()))) continue;
            deleteFieldKey.add(controlAp.getKey());
        }
        if (deleteFieldKey.isEmpty()) {
            return;
        }
        Iterator<ControlAp<?>> iterator = this.ctrlAps.iterator();
        while (iterator.hasNext()) {
            ControlAp<?> controlAp = iterator.next();
            if (!deleteFieldKey.contains(controlAp.getKey())) continue;
            iterator.remove();
            this.ctrlApsMap.remove(controlAp.getKey());
        }
        Iterator<EntityItem<?>> iterator2 = this.entityItems.iterator();
        while (iterator2.hasNext()) {
            EntityItem<?> ap = iterator2.next();
            if (!deleteFieldKey.contains(ap.getKey())) continue;
            iterator2.remove();
            this.entityItemsMap.remove(ap.getKey());
        }
    }
}

