/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.permission;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.misc.SystemContext;

public class ResourceControl {
    public static String checkOpPermission(String operation, DynamicObject resource) {
        switch (operation) {
            case "copy": {
                return ResourceControl.checkCopyPermission(resource);
            }
            case "delete": {
                return ResourceControl.checkDeletePermission(resource);
            }
            case "modify": {
                return ResourceControl.checkModifyPermission(resource);
            }
        }
        return null;
    }

    public static String checkNewPermission() {
        if (!SystemContext.isProcEnv()) {
            return null;
        }
        if (ResourceControl.allowOperation()) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e3a\u751f\u4ea7\u73af\u5883\uff0c\u6ca1\u6709\u3010\u65b0\u589e\u3011\u8d44\u6e90\u7684\u6743\u9650\uff1a\u53ef\u901a\u8fc7\u7ba1\u7406\u5458\u7528\u6237\u5728\u3010\u516c\u5171\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011->\u3010\u7cfb\u7edf\u53c2\u6570\u3011->\u3010\u96c6\u6210\u670d\u52a1\u53c2\u6570\u3011\u6253\u5f00\u751f\u4ea7\u73af\u5883\u5141\u8bb8\u65b0\u589e\u96c6\u6210\u8d44\u6e90\u5f00\u5173\u3002", (String)"ResourceControl_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    public static String checkCopyPermission(DynamicObject resource) {
        String protectLevel = ResourceControl.getProtectLevel(resource);
        if ("READ_ONLY".equals(protectLevel)) {
            return ResourceControl.checkCopyReadOnly();
        }
        if (!SystemContext.isProcEnv()) {
            return null;
        }
        if (ResourceControl.allowOperation()) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e3a\u751f\u4ea7\u73af\u5883\uff0c\u6ca1\u6709\u3010\u590d\u5236\u3011\u8d44\u6e90\u7684\u6743\u9650\uff1a\u53ef\u901a\u8fc7\u7ba1\u7406\u5458\u7528\u6237\u5728\u3010\u516c\u5171\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011->\u3010\u7cfb\u7edf\u53c2\u6570\u3011->\u3010\u96c6\u6210\u670d\u52a1\u53c2\u6570\u3011\u6253\u5f00\u751f\u4ea7\u73af\u5883\u5141\u8bb8\u590d\u5236\u96c6\u6210\u8d44\u6e90\u5f00\u5173\u3002", (String)"ResourceControl_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private static String checkCopyReadOnly() {
        if (!SystemContext.isProcEnv()) {
            return null;
        }
        if (ResourceControl.allowOperation()) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e3a\u751f\u4ea7\u73af\u5883\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3010\u53ea\u8bfb\u3011\u4fdd\u62a4\u7ea7\u522b\u7684\u6570\u636e\uff1b\u53ef\u901a\u8fc7\u7ba1\u7406\u5458\u7528\u6237\u5728\u3010\u516c\u5171\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011->\u3010\u7cfb\u7edf\u53c2\u6570\u3011->\u3010\u96c6\u6210\u670d\u52a1\u53c2\u6570\u3011\u6253\u5f00\u751f\u4ea7\u73af\u5883\u5141\u8bb8\u590d\u5236\u96c6\u6210\u8d44\u6e90\u5f00\u5173\u3002", (String)"ResourceControl_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    public static String checkDeletePermission(DynamicObject resource) {
        String protectLevel = ResourceControl.getProtectLevel(resource);
        if ("READ_ONLY".equals(protectLevel)) {
            return ResourceControl.checkDeleteReadOnly(resource);
        }
        if (!SystemContext.isProcEnv()) {
            return null;
        }
        if (ResourceControl.allowOperation()) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e3a\u751f\u4ea7\u73af\u5883\uff0c\u6ca1\u6709\u3010\u5220\u9664\u3011\u8d44\u6e90\u7684\u6743\u9650\uff1b\u53ef\u901a\u8fc7\u7ba1\u7406\u5458\u7528\u6237\u5728\u3010\u516c\u5171\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011->\u3010\u7cfb\u7edf\u53c2\u6570\u3011->\u3010\u96c6\u6210\u670d\u52a1\u53c2\u6570\u3011\u6253\u5f00\u751f\u4ea7\u73af\u5883\u5141\u8bb8\u5220\u9664\u96c6\u6210\u8d44\u6e90\u5f00\u5173\u3002", (String)"ResourceControl_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private static String checkDeleteReadOnly(DynamicObject resource) {
        if (ResourceControl.differentSource(resource)) {
            return ResManager.loadKDString((String)"\u4e0d\u662f\u5f53\u524d\u73af\u5883\u521b\u5efa\u7684\u8d44\u6e90\uff0c\u5e76\u4e14\u8d44\u6e90\u4fdd\u62a4\u7b49\u7ea7\u4e3a\u3010\u53ea\u8bfb\u3011\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ResourceControl_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (!SystemContext.isProcEnv()) {
            return null;
        }
        if (ResourceControl.allowOperation()) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e3a\u751f\u4ea7\u73af\u5883\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3010\u53ea\u8bfb\u3011\u4fdd\u62a4\u7ea7\u522b\u7684\u6570\u636e\uff1b\u53ef\u901a\u8fc7\u7ba1\u7406\u5458\u7528\u6237\u5728\u3010\u516c\u5171\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011->\u3010\u7cfb\u7edf\u53c2\u6570\u3011->\u3010\u96c6\u6210\u670d\u52a1\u53c2\u6570\u3011\u6253\u5f00\u751f\u4ea7\u73af\u5883\u5141\u8bb8\u5220\u9664\u96c6\u6210\u8d44\u6e90\u5f00\u5173\u3002", (String)"ResourceControl_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    public static String checkModifyPermission(DynamicObject resource) {
        if (ResourceControl.checkSourceTraceLength(resource)) {
            return ResManager.loadKDString((String)"\u8be5\u8d44\u6e90\u4fee\u6539\u6b21\u6570\u8fc7\u591a\uff0c\u8bb0\u5f55\u7684\u201c\u6765\u6e90\u8ffd\u6eaf\u201d\u4fe1\u606f\u8fc7\u957f\uff0c\u8bf7\u590d\u5236\u8d44\u6e90\u518d\u8fdb\u884c\u4fee\u6539\u3002", (String)"ResourceControl_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        String protectLevel = ResourceControl.getProtectLevel(resource);
        if ("READ_ONLY".equals(protectLevel)) {
            if (ResourceControl.differentSource(resource)) {
                return ResManager.loadKDString((String)"\u4e0d\u662f\u5f53\u524d\u73af\u5883\u521b\u5efa\u7684\u8d44\u6e90\uff0c\u5e76\u4e14\u8d44\u6e90\u4fdd\u62a4\u7b49\u7ea7\u4e3a\u3010\u53ea\u8bfb\u3011\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ResourceControl_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            return null;
        }
        if ("UNPROTECTED".equals(protectLevel)) {
            return null;
        }
        if (!SystemContext.isProcEnv()) {
            return null;
        }
        if (ResourceControl.defaultProtectInvalid()) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e3a\u751f\u4ea7\u73af\u5883\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3010\u9ed8\u8ba4\u3011\u4fdd\u62a4\u7ea7\u522b\u7684\u6570\u636e\uff1b\u53ef\u901a\u8fc7\u7ba1\u7406\u5458\u7528\u6237\u5728\u3010\u516c\u5171\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011->\u3010\u7cfb\u7edf\u53c2\u6570\u3011->\u3010\u96c6\u6210\u670d\u52a1\u53c2\u6570\u3011\u6253\u5f00\u751f\u4ea7\u73af\u5883\u662f\u5426\u5141\u8bb8\u4fee\u6539\u201c\u9ed8\u8ba4\u201d\u4fdd\u62a4\u7ea7\u522b\u7684\u96c6\u6210\u8d44\u6e90\u5f00\u5173\u3002", (String)"ResourceControl_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private static boolean checkSourceTraceLength(DynamicObject resource) {
        DataEntityPropertyCollection properties = resource.getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"source_trace")) {
            return false;
        }
        String sourceTrace = D.s((Object)resource.getString("source_trace"));
        if (sourceTrace == null) {
            return false;
        }
        return sourceTrace.length() > 500;
    }

    private static boolean allowOperation() {
        AppParam apm = ResourceControl.getAppParam();
        try {
            String allowOperation = D.s((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)"allow_operation"));
            return "allow_operation_yes".equals(allowOperation);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean defaultProtectInvalid() {
        AppParam apm = ResourceControl.getAppParam();
        try {
            String defaultInvalid = D.s((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)"default_invalid"));
            return "default_invalid_yes".equals(defaultInvalid);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static AppParam getAppParam() {
        AppParam apm = new AppParam();
        apm.setAppId("TV3/VDJ86RC");
        apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        return apm;
    }

    private static String getProtectLevel(DynamicObject resource) {
        DataEntityPropertyCollection properties = resource.getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"protect_level")) {
            return "DEFAULT";
        }
        return ResourceControl.cast(resource.get("protect_level"));
    }

    private static boolean differentSource(DynamicObject resource) {
        String sourceTenant = D.s((Object)resource.getString("source_tenant"));
        String tenantId = D.s((Object)RequestContext.get().getTenantId());
        tenantId = tenantId == null ? "undefined" : tenantId;
        return !tenantId.equals(sourceTenant);
    }

    public static String cast(Object protectLevel) {
        String s = D.s((Object)protectLevel);
        if (s == null) {
            return "DEFAULT";
        }
        switch (s) {
            case "DEFAULT": 
            case "\u9ed8\u8ba4": {
                return "DEFAULT";
            }
            case "UNPROTECTED": 
            case "\u65e0\u4fdd\u62a4": {
                return "UNPROTECTED";
            }
            case "READ_ONLY": 
            case "\u53ea\u8bfb": {
                return "READ_ONLY";
            }
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u4fdd\u62a4\u7ea7\u522b\u503c\uff08%s\uff09", (String)"ResourceControl_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), protectLevel));
    }
}

