/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.rc.job;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.rc.CheckItem;
import kd.isc.iscb.platform.core.rc.CheckResult;
import kd.isc.iscb.platform.core.rc.Util;
import kd.isc.iscb.platform.core.rc.job.CheckHealthJobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class CheckHealthJob
implements Job {
    public static final JobFactory FACTORY = new CheckHealthJobFactory();
    private AtomicInteger index = new AtomicInteger(0);
    private String params;
    private String title;
    private int counts;

    public CheckHealthJob(String params, String title) {
        this.params = params;
        this.title = title;
    }

    @Override
    public void run() {
        try {
            Map map = (Map)Json.toObject((String)this.params);
            this.counts = map.size();
            this.truncateTable();
            this.saveCheckRecord("checktime", String.valueOf(D.t((Object)new Date())));
            this.saveCheckRecord("operatorid", D.s((Object)RequestContext.get().getCurrUserId()));
            this.saveCheckRecord("serverid", NetUtil.getServerId());
            for (Map.Entry entry : map.entrySet()) {
                SignalManager.checkCancelSignal();
                CheckItem checkItem = Util.getCheckItem((String)entry.getValue());
                this.saveCheckItem(checkItem);
                List<CheckResult> list = checkItem.check();
                this.saveCheckResult(list, checkItem);
                this.index.incrementAndGet();
            }
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5931\u8d25%s", (String)"CheckHealthJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)), (Throwable)e);
        }
        this.saveCheckRecord("checkstatus", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"CheckHealthJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private void truncateTable() {
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            DbUtil.executeUpdate((Connection)cn, (String)"TRUNCATE table t_isc_res_check_record");
            DbUtil.executeUpdate((Connection)cn, (String)"TRUNCATE table t_isc_res_check_list");
            DbUtil.executeUpdate((Connection)cn, (String)"TRUNCATE table t_isc_res_check_result");
            try {
                if (!cn.getAutoCommit()) {
                    cn.commit();
                }
            }
            catch (SQLException e) {
                throw new IscBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u63d0\u4ea4\u5931\u8d25", (String)"CheckHealthJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(cn);
            throw throwable;
        }
        DbUtil.close((Connection)cn);
    }

    private void saveCheckRecord(String key, String value) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        ArrayList<Object> v = new ArrayList<Object>(4);
        v.add(IDService.get().genLongId());
        v.add(key);
        v.add(value);
        values.add(v);
        String sql = "INSERT INTO T_ISC_RES_CHECK_RECORD (fid,fkey,fvalue) VALUES (?,?,?)";
        List<Integer> types = Arrays.asList(-5, 12, 12);
        this.insertSql(types, sql, values);
    }

    private void saveCheckItem(CheckItem checkItem) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        ArrayList<Object> v = new ArrayList<Object>(4);
        v.add(IDService.get().genLongId());
        v.add(checkItem.getGroupName().name());
        v.add(checkItem.getNumber());
        v.add(checkItem.getDesc());
        values.add(v);
        String sql = "INSERT INTO T_ISC_RES_CHECK_LIST (fid,fgroup,fcheck_number,fdescription) VALUES (?,?,?,?)";
        List<Integer> types = Arrays.asList(-5, 12, 12, 12);
        this.insertSql(types, sql, values);
    }

    private void saveCheckResult(List<CheckResult> list, CheckItem checkItem) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>(50);
        for (CheckResult checkResult : list) {
            ArrayList<Object> v = new ArrayList<Object>(7);
            v.add(IDService.get().genLongId());
            v.add(checkItem.getNumber());
            v.add(checkResult.getRiskItem().number);
            v.add(checkResult.getResourceId());
            v.add(checkResult.getResourceNumber());
            v.add(checkResult.getResourceName());
            values.add(v);
        }
        List<Integer> types = Arrays.asList(-5, 12, 12, -5, 12, 12);
        String sql = "INSERT INTO T_ISC_RES_CHECK_RESULT (FID,fcheck_number,frisk_number,fresource_id, fresource_number,fresource_name) VALUES (?,?,?,?,?,?)";
        this.insertSql(types, sql, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSql(List<Integer> types, String sql, List<List<Object>> values) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            DbUtil.executeBatch((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    @Override
    public String getJobSummary() {
        return ResManager.loadKDString((String)"\u5065\u5eb7\u5ea6\u68c0\u6d4b\u5b8c\u6210\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u67e5\u770b\u68c0\u6d4b\u62a5\u544a", (String)"CheckHealthJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    @Override
    public String refreshProgress() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.index.get()).append('/').append(this.counts).append(ResManager.loadKDString((String)"\u5065\u5eb7\u5ea6\u68c0\u6d4b", (String)"CheckHealthJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        return sb.toString();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int completed = this.index.get();
        return new Job.Progress(this.counts, completed, ResManager.loadKDString((String)"\u5065\u5eb7\u5ea6\u68c0\u6d4b", (String)"CheckHealthJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public final long getOwnerId() {
        return Hash.mur64((byte[])this.params.getBytes(D.UTF_8));
    }

    @Override
    public String getParam() {
        return this.params;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }
}

