/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.resource.packages;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.platform.core.util.ZipUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class ExportUtil {
    private static Log logger = LogFactory.getLog(ExportUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exportDynamicObjectToDts(DynamicObject object) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ExportDynamicObject.export((OutputStream)output, new DynamicObject[]{object}, true);
            String string = output.toString("utf-8");
            return string;
        }
        catch (Exception e) {
            Object pk = object.getPkValue();
            String entity = object.getDataEntityType().getName();
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u3010%1$s\u3011\u3010%2$s\u3011\u5931\u8d25\uff0c\u539f\u56e0\uff1a%3$s", (String)"packages_ExportUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, entity, pk, StringUtil.getCascadeMessage((Throwable)e)), (Throwable)e);
        }
    }

    public static void export(long exportBillId, IFormView view) {
        DynamicObject exportObject = BusinessDataServiceHelper.loadSingle((Object)exportBillId, (String)"isc_res_packages_export");
        DynamicObjectCollection mainEntries = exportObject.getDynamicObjectCollection("main_resources");
        String zipPath = System.getProperty("user.home") + File.separator + "downloads" + File.separator + "temp";
        ArrayList<String> filesTemp = new ArrayList<String>(mainEntries.size() + 1);
        int byteCount = 0;
        for (DynamicObject entry : mainEntries) {
            String content = entry.getString("main_export_content_tag");
            byteCount += content.length();
            String number = FileUtil.removeIllegalChar(entry.getString("main_res_number"));
            String name = FileUtil.removeIllegalChar(entry.getString("main_res_name"));
            String entity = entry.getString("main_res_type.name");
            String tempFilePath = FileUtil.getLocalPath(entity + '_' + name + '(' + number + ')');
            ExportUtil.writeContentToTempPath(content, tempFilePath);
            filesTemp.add(tempFilePath);
        }
        long packagesId = exportObject.getLong("packages_id");
        DynamicObject packages = BusinessDataServiceHelper.loadSingle((Object)packagesId, (String)"isc_res_packages");
        String packagesContent = ExportUtil.exportDynamicObjectToDts(packages);
        String tempFilePath = FileUtil.getLocalPath(ExportAndImportFormUtil.generateFileName(new DynamicObject[]{packages}));
        ExportUtil.writeContentToTempPath(packagesContent, tempFilePath);
        filesTemp.add(tempFilePath);
        ExportUtil.download(view, filesTemp, zipPath, ExportUtil.zipFileName(exportObject));
        exportObject.set("byte_count", (Object)byteCount);
        exportObject.set("export_time", (Object)D.t((Object)new Date()));
        exportObject.set("modifier", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exportObject});
    }

    private static void download(IFormView view, List<String> filesTemp, String zipPath, String zipName) {
        BufferedInputStream in = null;
        String path = null;
        try {
            path = ZipUtils.compressFile(filesTemp, zipPath, zipName);
            FileUtil.checkFilePath(path);
            in = new BufferedInputStream(new FileInputStream(path), 524288);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(path.substring(path.lastIndexOf(File.separator) + 1), (InputStream)in, 1800);
            view.openUrl(url);
        }
        catch (Exception e) {
            logger.error("\u8d44\u6e90\u5305\u5bfc\u51fa\uff0c\u751f\u6210\u538b\u7f29zip\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            String s = ResManager.loadKDString((String)"\u8d44\u6e90\u5305\u5bfc\u51fa\uff0c\u751f\u6210\u538b\u7f29zip\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"packages_ExportUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(s, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u8d44\u6e90\u5305\u5bfc\u51fa\uff0c\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
                }
            }
            filesTemp.forEach(FileUtil::delete);
            FileUtil.delete(path);
        }
    }

    private static String zipFileName(DynamicObject exportObject) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String date = df.format(new Date());
        return exportObject.getString("number") + '-' + exportObject.getString("packages.name") + '-' + date;
    }

    private static void writeContentToTempPath(String content, String tempPath) {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tempPath), 524288);){
            ((OutputStream)output).write(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u65f6\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"packages_ExportUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            s = String.format(s, StringUtil.getCascadeMessage((Throwable)e));
            throw new IscBizException(s, (Throwable)e);
        }
    }
}

