/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.resource.packages;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.imp.AbstractFileResourceJob;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.resource.packages.ImportPackagesParseJobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.MultiLangUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ImportPackagesParseJob
extends AbstractFileResourceJob {
    public static final JobFactory FACTORY = new ImportPackagesParseJobFactory();
    private Map<String, String> entities = new HashMap<String, String>(32);
    private AtomicInteger ref_imported = new AtomicInteger(0);
    private AtomicInteger main_imported = new AtomicInteger(0);
    private int total;

    public ImportPackagesParseJob(long id, String title) {
        super(id, title);
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String getJobSummary() {
        return this.getDetailedSummary();
    }

    private String getDetailedSummary() {
        int num = this.main_imported.get() + this.ref_imported.get();
        return String.format(ResManager.loadKDString((String)"\u5171\u89e3\u6790\u8d44\u6e90%1$s\u4e2a\u3002\u4e3b\u8d44\u6e90%2$s\uff0c\u4f9d\u8d56\u8d44\u6e90%3$s\u4e2a", (String)"ImportPackagesParseJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), num, this.main_imported.get(), this.ref_imported.get());
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int num = this.main_imported.get() + this.ref_imported.get();
        String tips = String.format(ResManager.loadKDString((String)"\u5171\u6709\u8d44\u6e90%1$s\u4e2a\uff0c\u5df2\u89e3\u6790%2$s\u4e2a\u3002", (String)"ImportPackagesParseJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, num);
        return new Job.Progress(this.total, num, tips);
    }

    @Override
    public void run() {
        long id = this.getId();
        try {
            List<Map<String, Object>> files = AttachmentUtil.getAttachmentList("isc_dts_imp_packages", id);
            SignalManager.checkCancelSignal();
            this.parseResourceFile(files.get(0));
            FileResourceUtil.setParsed(id, this.getDetailedSummary());
        }
        catch (Exception e) {
            FileResourceUtil.setFailed(id);
            throw D.e((Throwable)e);
        }
    }

    private void parseResourceFile(Map<String, Object> file) {
        List<String> jsons = this.readDtsFile(file);
        if (jsons.isEmpty()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u538b\u7f29\u6587\u4ef6\u4e2d\u83b7\u53d6\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u52a0\u8f7d\uff0c\u8bf7\u786e\u4fdd\u96c6\u6210\u8d44\u6e90zip\u5305\u5b8c\u6574\u3002", (String)"ImportPackagesParseJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String fileName = this.getFileName(file);
        this.total = jsons.size();
        for (String json : jsons) {
            SignalManager.checkCancelSignal();
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            this.saveResourceData(data, fileName);
        }
    }

    private void saveResourceData(Map<String, Object> data, String file) {
        boolean isRef = D.x((Object)data.get("$isref"));
        data.put("$isref", Boolean.FALSE);
        String json = Json.toString(data);
        file = StringUtil.trim((String)file, (int)50);
        String entityTitle = this.innerGetEntityTitle(D.s((Object)data.get("$entityname")));
        if ("isc_res_packages".equals(data.get("$entityname")) || isRef) {
            this.ref_imported.getAndIncrement();
            this.saveRefResource(json, data, entityTitle, file);
        } else {
            this.main_imported.getAndIncrement();
            this.saveMainResource(json, data, entityTitle, file);
        }
    }

    private String innerGetEntityTitle(String entity) {
        String title = this.entities.get(entity);
        if (title == null) {
            title = FileResourceUtil.getEntityTitle(entity);
            this.entities.put(entity, title);
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMainResource(String json, Map<String, Object> data, String entityTitle, String file) {
        int seq = this.main_imported.get();
        long entryId = IDService.get().genLongId();
        String name = this.getResName(data);
        String number = this.getNumber(data);
        String resPk = D.s((Object)data.get("id"));
        String entity = D.s((Object)data.get("$entityname"));
        Timestamp localTime = this.getLocalTime(entity, resPk);
        Timestamp resTime = D.t((Object)data.get(this.getTimeField(entity)));
        String operation = "UPDATE";
        String state = "READY";
        String sourceTrace = D.s((Object)data.get("source_trace"));
        sourceTrace = sourceTrace == null ? " " : sourceTrace;
        String sql = "INSERT INTO T_ISCB_DTS_IMP_MRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,         FCONTENT,FRES_PK, FTYPE, FFILE, FSOURCE_TRACE)VALUES(?,?,?,?,    ?,?,?,?,?,    ?,?,?,?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 93, 93, 12, 12, 12, 12, 12, 12);
        List<Object> values = Arrays.asList(this.getId(), entryId, seq, operation, name, number, resTime, localTime, state, json, resPk, entityTitle, file, sourceTrace);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRefResource(String json, Map<String, Object> data, String entityTitle, String file) {
        int seq = this.ref_imported.get();
        long entryId = IDService.get().genLongId();
        String name = this.getResName(data);
        String number = this.getNumber(data);
        String resPk = D.s((Object)data.get("id"));
        String entity = D.s((Object)data.get("$entityname"));
        Timestamp localTime = this.getLocalTime(entity, resPk);
        Timestamp resTime = D.t((Object)data.get(this.getTimeField(entity)));
        String operation = "INSERT";
        String state = "READY";
        String sourceTrace = D.s((Object)data.get("source_trace"));
        sourceTrace = sourceTrace == null ? " " : sourceTrace;
        String sql = "INSERT INTO T_ISCB_DTS_IMP_RRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FTYPE,FRES_TIME,    FLOCAL_TIME,FSTATE,FCONTENT,FRES_PK, FFILE, FSOURCE_TRACE)VALUES(?,?,?,?,     ?,?,?,?,    ?,?,?,?,?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 12, 93, 93, 12, 12, 12, 12, 12);
        List<Object> values = Arrays.asList(this.getId(), entryId, seq, operation, name, number, entityTitle, resTime, localTime, state, json, resPk, file, sourceTrace);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private String getResName(Map<String, Object> data) {
        String s = MultiLangUtil.getMultiLangValue(data.get("name"));
        return s == null ? ResManager.loadKDString((String)"(\u65e0)", (String)"ImportPackagesParseJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : s;
    }

    private String getNumber(Map<String, Object> data) {
        String number = D.s((Object)data.get("number"));
        return number == null ? ResManager.loadKDString((String)"(\u65e0)", (String)"ImportPackagesParseJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : number;
    }

    private String getFileName(Map<String, Object> file) {
        return file.get("name") + "." + file.get("type");
    }

    private Timestamp getLocalTime(String entity, String pk) {
        String field = this.getTimeField(entity);
        boolean hasField = EntityMetadataCache.getDataEntityType((String)entity).getProperties().containsKey((Object)field);
        DynamicObject obj = null;
        if (hasField) {
            Object id = FileResourceUtil.parseResPK(pk, entity);
            obj = QueryServiceHelper.queryOne((String)entity, (String)field, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        }
        return obj == null ? null : D.t((Object)obj.get(field));
    }

    private String getTimeField(String entity) {
        switch (entity) {
            case "isc_apic_permission": {
                return "created_time";
            }
            case "iscx_resource_ext": {
                return "extended_time";
            }
        }
        return "modifytime";
    }

    private List<String> readDtsFile(Map<String, Object> file) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ArrayList<String> dts = new ArrayList<String>();
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            InputStream inputStream = fileService.getInputStream((String)file.get("srcUrl"));
            in = new ZipInputStream(inputStream);
            while ((entry = in.getNextEntry()) != null) {
                String name;
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".dts")) continue;
                dts.addAll(this.parseDtsFile(in));
            }
        }
        catch (Exception e) {
            try {
                throw new IscBizException((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(in);
                throw throwable;
            }
        }
        DbUtil.close((InputStream)in);
        return dts;
    }

    private List<String> parseDtsFile(InputStream input) throws Exception {
        ArrayList<String> dts = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(input, 32768), StandardCharsets.UTF_8));
        String s = reader.readLine();
        while (s != null) {
            dts.add(s);
            s = reader.readLine();
        }
        return dts;
    }
}

