/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.cache.DynamicObjectCacheProxy;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.core.SysVariable;

public abstract class Resource
implements SysVariable {
    private ResourceCategory category;
    private long id;
    private String _name;
    private String title;
    private static final ThreadLocal<Map<Pair<String, Long>, DynamicObject>> objects = new ThreadLocal();

    protected Resource(ResourceCategory category, long id, String name, String title) {
        this.category = category;
        this.id = id;
        this._name = name;
        this.title = title;
    }

    public final String name() {
        return this._name;
    }

    public final String getTitle() {
        return this.title;
    }

    public final long getId() {
        return this.id;
    }

    public final ResourceCategory getCategory() {
        return this.category;
    }

    public final DynamicObject getDynamicObject() {
        return Resource.getDynamicObject(this.category.getEntityType(), this.id);
    }

    public final String toString() {
        return this.title + "(" + this._name + ":" + this.id + ")@" + this.category.name().toLowerCase();
    }

    protected static DynamicObject getDynamicObject(String entity, Long id) {
        Pair key;
        DynamicObject obj;
        Map<Pair<String, Long>, DynamicObject> map = objects.get();
        if (map == null) {
            map = new HashMap<Pair<String, Long>, DynamicObject>();
            objects.set(map);
        }
        if ((obj = map.get(key = new Pair((Object)entity, (Object)id))) == null) {
            obj = DynamicObjectCacheProxy.getById(id, entity);
            map.put((Pair<String, Long>)key, obj);
        }
        return obj;
    }

    protected static void dispose() {
        objects.remove();
    }
}

