/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.EventStarterParser;
import kd.isc.iscb.platform.core.sf.parser.n.MessageStarterParser;
import kd.isc.iscb.platform.core.sf.runtime.AbstractProcessJobFactory;
import kd.isc.iscb.platform.core.sf.runtime.ProcessExecuteJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.sf.runtime.ProcessTerminateJob;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Logger;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceManager;
import kd.isc.iscb.util.trace.TraceTask;

public class ServiceFlowEngine
implements Const {
    public static long createAndStart(long flowId, Object[] inputs) {
        return ServiceFlowEngine.createAndStart(flowId, inputs, Collections.emptyMap());
    }

    public static long createAndStart(long flowId, Object[] inputs, Map<String, Object> data) {
        return ServiceFlowEngine.createAndStart(flowId, inputs, data, Collections.emptyMap());
    }

    public static long createAndStart(long flowId, Object[] inputs, Map<String, Object> data, Map<String, Object> properties) {
        DynamicObject proc = ProcessRuntime.create(flowId, inputs, data, properties);
        String title = proc.getString("number");
        long procInstId = proc.getLong("id");
        Flow flow = ServiceFlowParser.getFlow(flowId);
        boolean isLight = ServiceFlowEngine.isLight(flow);
        JobEngine.submit(new ProcessExecuteJob(procInstId, title, ProcessState.Created, isLight, ServiceFlowParser.getMutex(flow)));
        return procInstId;
    }

    public static long createAndStartSubFlow(long flowId, Object[] inputs, long parent_proc_id, String parent_execution_id, String parent_execution_name) {
        DynamicObject proc = ProcessRuntime.create(flowId, inputs, Collections.emptyMap(), new HashMap<String, Object>(), parent_proc_id, parent_execution_id, parent_execution_name);
        String title = proc.getString("number");
        long procInstId = proc.getLong("id");
        Flow flow = ServiceFlowParser.getFlow(flowId);
        boolean isLight = ServiceFlowEngine.isLight(flow);
        JobEngine.submit(new ProcessExecuteJob(procInstId, title, ProcessState.Created, isLight, ServiceFlowParser.getMutex(flow)));
        return procInstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Long, Object[]> createAndExecute(long flowId, Object[] inputs, Map<String, Object> data) {
        DynamicObject proc = ProcessRuntime.create(flowId, inputs, data);
        long procInstId = proc.getLong("id");
        FlowRuntime runtime = ProcessRuntime.loadRuntime(procInstId);
        runtime.setLoggerLevel(Logger.Level.WARN);
        ProcessRuntime.setRunning(procInstId, ProcessState.Created);
        SignalManager.registerTask(runtime.getId());
        try {
            ServiceFlowEngine.executeProcessWithTrace(runtime, proc, procInstId);
            Pair<Long, Object[]> pair = ServiceFlowEngine.getResult(procInstId, runtime);
            return pair;
        }
        finally {
            SignalManager.unregisterTask(runtime.getId());
        }
    }

    private static void executeProcessWithTrace(final FlowRuntime runtime, DynamicObject proc, final long procInstId) {
        TraceStack.run(TraceType.EXE_SFP, proc, new TraceTask(){

            public void run() {
                long flowId = ServiceFlowParser.getServiceFlowId(runtime.getFlow());
                ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense("isc_service_flow", flowId));
                try {
                    ServiceFlowEngine.checkDisableTrace(runtime);
                    runtime.resume();
                    ProcessRuntime.saveState(procInstId, runtime);
                }
                catch (Throwable e) {
                    ProcessRuntime.saveState(procInstId, runtime, e);
                    throw e;
                }
                finally {
                    ConnectionManager.popResLicense();
                }
            }
        });
    }

    public static Object[] executeWithoutProcInst(long flowId, Object[] inputs, Map<String, Object> data) {
        FlowRuntime runtime = ProcessRuntime.newInstance(flowId, inputs, data);
        if (runtime.getFlow().hasAsyncNodes()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e2d\u5b58\u5728\u6682\u505c\u73af\u8282\uff0c\u4e0d\u80fd\u4f7f\u7528\u65e0\u6d41\u7a0b\u5b9e\u4f8b\u6a21\u5f0f\u6267\u884c\u3002", (String)"ServiceFlowEngine_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        runtime.setLoggerLevel(Logger.Level.CONTROL);
        runtime.setTransientProperty("NO_PROC_INST", (Object)Boolean.TRUE);
        ServiceFlowEngine.executeFlowWithTrace(flowId, runtime, inputs, data);
        if (runtime.isClosed()) {
            return runtime.getOutput().toArray();
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e2d\u5b58\u5728\u6682\u505c\u73af\u8282, \u4e0d\u80fd\u4f7f\u7528\u65e0\u6d41\u7a0b\u5b9e\u4f8b\u6a21\u5f0f\u6267\u884c.", (String)"ServiceFlowEngine_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private static void executeFlowWithTrace(final long flowId, final FlowRuntime runtime, final Object[] inputs, final Map<String, Object> data) {
        TraceStack.run(TraceType.EXE_SFF, runtime.getFlow().getTitle(), flowId, new TraceTask(){

            public void run() {
                ServiceFlowEngine.checkDisableTrace(runtime);
                long flowId2 = ServiceFlowParser.getServiceFlowId(runtime.getFlow());
                ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense("isc_service_flow", flowId2));
                try {
                    runtime.resume();
                }
                catch (Throwable e) {
                    this.terminateFlow(e);
                    throw e;
                }
                finally {
                    ConnectionManager.popResLicense();
                }
            }

            private void terminateFlow(Throwable e) {
                try {
                    runtime.terminate();
                }
                catch (Throwable e2) {
                    DynamicObject proc = this.saveProcInst(e, e2);
                    String err = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e86\u89e3\u66f4\u591a\u4fe1\u606f\u3002", (String)"ServiceFlowEngine_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), proc.get("number")) + "\r\n" + String.format(ResManager.loadKDString((String)"\u8be5\u670d\u52a1\u6d41\u7a0b\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"ServiceFlowEngine_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)) + "\r\n" + String.format(ResManager.loadKDString((String)"\u5e76\u4e14\u64a4\u9500\u65f6\u4e5f\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"ServiceFlowEngine_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e2));
                    throw new IscBizException(err, e2);
                }
            }

            private DynamicObject saveProcInst(Throwable e, Throwable e2) {
                runtime.setTransientProperty("NO_PROC_INST", (Object)Boolean.FALSE);
                DynamicObject proc = ProcessRuntime.createProcById(flowId, inputs, data, Collections.emptyMap(), Long.parseLong(runtime.getId()));
                ProcessRuntime.saveState(proc.getLong("id"), runtime, e);
                ProcessRuntime.saveErrorLog(proc.getLong("id"), e2, runtime.getLastExecution().getDefine().getTitle());
                return proc;
            }
        });
    }

    public static boolean withoutProcInst(FlowRuntime runtime) {
        return D.x((Object)runtime.getTransientProperty("NO_PROC_INST"));
    }

    private static Pair<Long, Object[]> getResult(long procInstId, FlowRuntime runtime) {
        ProcessState state = ProcessRuntime.getState(runtime);
        if (state == ProcessState.Complete) {
            return new Pair((Object)procInstId, (Object)runtime.getOutput().toArray());
        }
        if (state == ProcessState.Terminated) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u201c%1$s\uff08%2$s\uff09\u201d\u88ab\u64cd\u4f5c\u8005\u64a4\u9500\u3002", (String)"ServiceFlowEngine_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), runtime.getFlow().getTitle(), runtime.getId()));
        }
        return new Pair((Object)procInstId, null);
    }

    public static boolean resume(long procInstId) {
        final DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)"flow,number,state");
        return (Boolean)TraceStack.run(TraceType.REDO_SFP, obj, new TraceTask(){

            public Object invoke() {
                return ServiceFlowEngine.innerResume(obj);
            }
        });
    }

    private static boolean innerResume(DynamicObject obj) {
        String state = obj.getString("state");
        boolean started = ProcessState.Failed.name().equals(state) || ProcessState.Created.name().equals(state) || ProcessState.Waiting.name().equals(state) || ProcessState.Ignored.name().equals(state) || ProcessState.Interrupted.name().equals(state);
        if (started) {
            String title = "[R] " + obj.getString("number");
            long procInstId = obj.getLong("id");
            Flow flow = ServiceFlowParser.getFlow(obj.getLong("flow_id"));
            JobEngine.submit(new ProcessExecuteJob(procInstId, title, ProcessState.valueOf(state), ServiceFlowEngine.isLight(flow), ServiceFlowParser.getMutex(flow)));
        }
        return started;
    }

    public static boolean terminate(final long procInstId) {
        final DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)"number,state");
        return (Boolean)TraceStack.run(TraceType.TM_SFP, obj, new TraceTask(){

            public Object invoke() {
                return ServiceFlowEngine.innerTerminate(procInstId, obj);
            }
        });
    }

    private static boolean innerTerminate(long procInstId, DynamicObject obj) {
        String state = obj.getString("state");
        if (state.equals(ProcessState.Complete.name()) || state.equals(ProcessState.Terminated.name())) {
            return false;
        }
        if (state.equals(ProcessState.Running.name())) {
            SignalManager.sendCancelSignal(String.valueOf(procInstId));
            return true;
        }
        List<JobInfo> jobs = JobEngine.getJobsWithOwnerId(procInstId);
        if (jobs.isEmpty()) {
            return AbstractProcessJobFactory.terminate(procInstId);
        }
        for (JobInfo job : jobs) {
            JobEngine.cancel(job.getId());
        }
        return true;
    }

    public static boolean terminate(final long procInstId, final Timestamp scheduledTime) {
        final DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)"number,state");
        final String state = obj.getString("state");
        if (state.equals(ProcessState.Complete.name()) || state.equals(ProcessState.Terminated.name())) {
            return false;
        }
        return (Boolean)TraceStack.run(TraceType.TM_SFP, obj, new TraceTask(){

            public Object invoke() {
                String title = "[A] " + obj.getString("number");
                ProcessTerminateJob job = new ProcessTerminateJob(procInstId, title, ProcessState.valueOf(state));
                JobEngine.submit(job, scheduledTime);
                return Boolean.TRUE;
            }
        });
    }

    public static void checkDisableTrace(FlowRuntime runtime) {
        if (ServiceFlowParser.isDisableTrace(runtime.getFlow())) {
            TraceManager.disableTrace();
        }
    }

    public static boolean jump(long procInstId, List<Map<String, List<String>>> jumpList) {
        FlowRuntime flowRuntime = ProcessRuntime.loadRuntime(procInstId);
        ServiceFlowEngine.innerJump(jumpList, procInstId, flowRuntime);
        final DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)"number,state,flow");
        return (Boolean)TraceStack.run(TraceType.JUMP_SFP, obj, new TraceTask(){

            public Object invoke() {
                return ServiceFlowEngine.innerResume(obj);
            }
        });
    }

    private static void innerJump(List<Map<String, List<String>>> jumpList, long procInstId, FlowRuntime flowRuntime) {
        if (flowRuntime.getState() == FlowRuntime.State.Closed) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u8df3\u8f6c\uff01", (String)"ServiceFlowEngine_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        for (Map<String, List<String>> jumpItem : jumpList) {
            for (Map.Entry<String, List<String>> entry : jumpItem.entrySet()) {
                flowRuntime.getService().jumpTo(entry.getKey(), entry.getValue().toArray(new String[0]));
            }
        }
        ProcessRuntime.saveState(procInstId, flowRuntime);
    }

    public static boolean ignore(long procInstId, List<String> ignoreList) {
        FlowRuntime flowRuntime = ProcessRuntime.loadRuntime(procInstId);
        for (String actId : ignoreList) {
            Execution execution = flowRuntime.getExecution(actId);
            execution.completeBiz();
            execution.setProperty("manual_complete", (Object)Boolean.TRUE);
        }
        ProcessRuntime.saveState(procInstId, flowRuntime);
        final DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)"number,state,flow");
        return (Boolean)TraceStack.run(TraceType.IGN_SFP, obj, new TraceTask(){

            public Object invoke() {
                return ServiceFlowEngine.innerResume(obj);
            }
        });
    }

    public static boolean isLight(Execution e) {
        return ServiceFlowEngine.isLight(e.getRuntime().getFlow());
    }

    public static boolean isLight(Flow flow) {
        FlowStarter starter = ServiceFlowParser.getStarter(flow);
        return starter instanceof MessageStarterParser.MessageStarter || starter instanceof EventStarterParser.EventStarter;
    }
}

