/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Script;

public class ServiceFlowHelper {
    private static final String FIELD_STATE = "state";
    private static final String ISC_SF_PROC_INST = "isc_sf_proc_inst";
    private static final String MODE_MESSAGE = "MESSAGE";
    private static final String MODE_EVENT = "EVENT";
    private static final String FIELD_INIT_MODE = "init_mode";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_ENABLE = "enable";
    private static final String ID = "id";

    public static void release(String number) {
        DynamicObject flow = ServiceFlow.getByNumber(number);
        if (flow == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u670d\u52a1\u6d41\u7a0b\u4e0d\u5b58\u5728\u3002", (String)"ServiceFlowHelper_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
        }
        ServiceFlowReleaser.releaseDefine(flow.getLong(ID));
    }

    public static long start(String number, List<Object> inputs) {
        long releasedFlowId = ServiceFlowHelper.findReleasedFlow(number);
        return ServiceFlowHelper.start(releasedFlowId, inputs, false);
    }

    public static long start(String number) {
        return ServiceFlowHelper.start(number, Collections.emptyList());
    }

    public static long start(String number, Map<String, Object> params) {
        long releasedFlowId = ServiceFlowHelper.findReleasedFlow(number);
        return ServiceFlowHelper.start(releasedFlowId, params);
    }

    private static long findReleasedFlow(String number) {
        ServiceFlow schema = ServiceFlow.getSchema(number);
        if (schema == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u670d\u52a1\u6d41\u7a0b\u4e0d\u5b58\u5728\u3002", (String)"ServiceFlowHelper_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
        }
        ServiceFlowHelper.checkFlow(schema.getFlow());
        long releasedFlowId = schema.getReleasedFlowId();
        if (releasedFlowId == 0L) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u670d\u52a1\u6d41\u7a0b\u672a\u53d1\u5e03\u3002", (String)"ServiceFlowHelper_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
        }
        return releasedFlowId;
    }

    private static long start(long releasedId, Map<String, Object> params) {
        List variables = ServiceFlowParser.getFlow(releasedId).getInputVariables();
        ArrayList<Object> inputs = new ArrayList<Object>(variables.size());
        for (Variable var : variables) {
            String name = var.getName();
            if (!params.containsKey(name)) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8f93\u5165\u53d8\u91cf[%s]\u672a\u586b\u5199\u3002", (String)"ServiceFlowHelper_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
            }
            inputs.add(params.get(name));
        }
        return ServiceFlowHelper.start(releasedId, inputs, false);
    }

    public static long start(long releasedId, List<Object> inputs, boolean isExpr) {
        if (releasedId > 0L) {
            List variables = ServiceFlowParser.getFlow(releasedId).getInputVariables();
            if (variables.isEmpty()) {
                return ServiceFlowEngine.createAndStart(releasedId, new Object[0]);
            }
            if (isExpr) {
                return ServiceFlowEngine.createAndStart(releasedId, ServiceFlowHelper.parseExpr(inputs));
            }
            return ServiceFlowHelper.simpleCreateAndStart(inputs.toArray(), releasedId, variables);
        }
        throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6240\u9009\u6d41\u7a0b\u672a\u53d1\u5e03\u3002", (String)"ServiceFlowHelper_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private static long simpleCreateAndStart(Object[] inputs, long releasedId, List<? extends Variable> variables) {
        int size = variables.size();
        if (inputs == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8f93\u5165\u53d8\u91cf\u8d4b\u503c\u4e3a\u7a7a\uff0c\u5e94\u586b\u5199%s\u4e2a\u53c2\u6570\u3002", (String)"ServiceFlowHelper_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), size));
        }
        if (inputs.length != size) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8f93\u5165\u53d8\u91cf\u503c\u4e2a\u6570\u4e0d\u5339\u914d\uff0c\u5e94\u586b\u5199%s\u4e2a\u53c2\u6570\u3002", (String)"ServiceFlowHelper_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), size));
        }
        return ServiceFlowEngine.createAndStart(releasedId, inputs);
    }

    private static void checkFlow(DynamicObject flow) {
        if (!D.x((Object)flow.get(FIELD_ENABLE))) {
            String name = flow.getString(FIELD_NAME);
            String number = flow.getString(FIELD_NUMBER);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b'%1$s\uff08%2$s\uff09'\u672a\u542f\u7528\uff0c\u8bf7\u5230\u96c6\u6210\u4e91\u670d\u52a1\u6d41\u7a0b\u5217\u8868\u542f\u7528\u672c\u6d41\u7a0b\u3002", (String)"ServiceFlowHelper_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, number));
        }
        String mode = flow.getString(FIELD_INIT_MODE);
        if (MODE_EVENT.equals(mode)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u52a8[\u4e8b\u4ef6\u89e6\u53d1]\u7c7b\u578b\u7684\u670d\u52a1\u6d41\u7a0b!", (String)"ServiceFlowHelper_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (MODE_MESSAGE.equals(mode)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u52a8[\u6d88\u606f\u89e6\u53d1]\u7c7b\u578b\u7684\u670d\u52a1\u6d41\u7a0b!", (String)"ServiceFlowHelper_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private static Object[] parseExpr(List<Object> expressions) {
        Assert.notNull(expressions, (String)ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceFlowHelper_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Object[] values = new Object[expressions.size()];
        for (int i = 0; i < expressions.size(); ++i) {
            String expr = D.s((Object)expressions.get(i));
            values[i] = Script.compileSimpleScript((String)expr).eval();
        }
        return values;
    }

    public static Map<String, Object> getState(long id) {
        if (D.l((Object)id) == 0L) {
            throw ServiceFlowHelper.createIllegalArgException();
        }
        DynamicObject inst = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_SF_PROC_INST, (String)"number, state, flow, context_tag");
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(ID, id);
        result.put(FIELD_NUMBER, inst.getString(FIELD_NUMBER));
        result.put(FIELD_STATE, inst.getString(FIELD_STATE));
        Map<String, Object> output = ServiceFlowHelper.getOutputValues(inst);
        result.put("output", output);
        return result;
    }

    private static Map<String, Object> getOutputValues(DynamicObject inst) {
        if (ProcessState.Created.name().equals(inst.getString(FIELD_STATE))) {
            return Collections.emptyMap();
        }
        long procInstId = inst.getLong(ID);
        FlowRuntime runtime = ProcessRuntime.loadRuntime(procInstId);
        List variables = runtime.getFlow().getOutputVariables();
        if (CollectionUtils.isEmpty((Collection)variables)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>(variables.size());
        for (Variable v : variables) {
            String name = v.getName();
            output.put(name, runtime.get(name));
        }
        return output;
    }

    public static boolean retry(long instId) {
        if (D.l((Object)instId) > 0L) {
            return ServiceFlowEngine.resume(instId);
        }
        throw ServiceFlowHelper.createIllegalArgException();
    }

    public static boolean terminate(long id) {
        if (D.l((Object)id) > 0L) {
            return ServiceFlowEngine.terminate(id);
        }
        throw ServiceFlowHelper.createIllegalArgException();
    }

    private static IllegalArgumentException createIllegalArgException() {
        return new IllegalArgumentException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\u7a7a\u3002", (String)"ServiceFlowHelper_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public static Map<String, Object> execute(String number) {
        return ServiceFlowHelper.execute(number, Collections.emptyList());
    }

    public static Map<String, Object> execute(String number, List<Object> inputs, boolean need_procid) {
        Map<String, Object> result = ServiceFlowHelper.execute(number, inputs);
        if (need_procid) {
            return result;
        }
        return (Map)result.get("output");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> execute(String number, List<Object> inputs) {
        ServiceFlow flow = ServiceFlow.getSchema(number);
        if (flow == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u662f%s\u7684\u670d\u52a1\u6d41\u7a0b\u3002", (String)"ServiceFlowHelper_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
        }
        ServiceFlowHelper.checkFlow(flow.getFlow());
        long releasedId = flow.getReleasedFlowId();
        DataSourceResource.createConnectionPool();
        try {
            Pair<Long, Object[]> pair = ServiceFlowEngine.createAndExecute(releasedId, inputs.toArray(), Collections.emptyMap());
            Map<String, Object> outVar = ServiceFlowHelper.getSyncOutputVar(releasedId, pair);
            Map<String, Object> map = ServiceFlowHelper.getSyncOutputData(pair, outVar);
            return map;
        }
        finally {
            DataSourceResource.disposeConnectionPool();
        }
    }

    private static Map<String, Object> getSyncOutputData(Pair<Long, Object[]> pair, Map<String, Object> outVar) {
        HashMap<String, Object> output = new HashMap<String, Object>(2);
        output.put(ID, pair.getKey());
        output.put("output", outVar);
        return output;
    }

    private static Map<String, Object> getSyncOutputVar(long flowId, Pair<Long, Object[]> pair) {
        List variables = ServiceFlowParser.getFlow(flowId).getOutputVariables();
        LinkedHashMap<String, Object> outVar = new LinkedHashMap<String, Object>();
        if (pair.getValue() == null) {
            outVar.put(FIELD_STATE, ResManager.loadKDString((String)"\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u4e2d\u662f\u5426\u5305\u542b\u65f6\u95f4\u7b49\u5f85\u8282\u70b9\u3001\u4e8b\u4ef6\u7b49\u5f85\u8282\u70b9\u548c\u5b50\u6d41\u7a0b\u8282\u70b9\u7b49\u5f02\u6b65\u5904\u7406\u8282\u70b9\uff0c\u6216\u5728\u8282\u70b9\u4e0a\u542f\u7528\u4e86\u9519\u8bef\u65f6\u81ea\u52a8\u91cd\u8bd5\u673a\u5236\u3002", (String)"ServiceFlowHelper_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else {
            for (int i = 0; i < variables.size(); ++i) {
                outVar.put(((Variable)variables.get(i)).getName(), ((Object[])pair.getValue())[i]);
            }
        }
        return outVar;
    }
}

