/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.connector.ischub.HubEventBindingCache;
import kd.isc.iscb.platform.core.connector.ischub.ResourceType;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.FlowTrigger;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowFactory;
import kd.isc.iscb.platform.core.sf.parser.DataTypeCategory;
import kd.isc.iscb.platform.core.sf.parser.NodeCategory;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.platform.core.sf.parser.TransitionCategory;
import kd.isc.iscb.platform.core.sf.parser.TransitionParser;
import kd.isc.iscb.platform.core.sf.runtime.ActivitySync;
import kd.isc.iscb.platform.core.sf.runtime.CheckCancelSignalOnReady;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.SetRetryOnFailed;
import kd.isc.iscb.platform.core.sf.runtime.StateSyncOnSuccess;
import kd.isc.iscb.platform.core.sf.runtime.l.IscHubEventListener;
import kd.isc.iscb.platform.core.sf.runtime.l.ParentFlowCallListenerOnComplete;
import kd.isc.iscb.platform.core.sf.runtime.l.ParentFlowCallListenerOnTerminated;
import kd.isc.iscb.platform.core.sf.runtime.l.ServiceFlowNotificationListener;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.SfMessageUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.flow.core.BlockBuilder;
import kd.isc.iscb.util.flow.core.Builder;
import kd.isc.iscb.util.flow.core.Event;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FC;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.Logger;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.Transition;
import kd.isc.iscb.util.flow.core.TransitionBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.plugin.Listener;
import kd.isc.iscb.util.flow.core.plugin.NodeExecutionSync;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.accessor.TestedBeforeNameAccessor;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.Storer;

public class ServiceFlowParser
implements Const {
    private static final ActivitySync ACTIVITY_SYNCHRONIZER = new ActivitySync();
    private static final StateSyncOnSuccess STATE_SYNCHRONIZER = new StateSyncOnSuccess();
    private static final SetRetryOnFailed SET_RETRY = new SetRetryOnFailed();
    private static final CheckCancelSignalOnReady CHECK_CANCEL_SIGNAL = new CheckCancelSignalOnReady();
    private static final String FLOW_STARTER = "FLOW_STARTER";
    private static final String FLOW_TRIGGERS = "FLOW_TRIGGERS";
    private static final Identifier ACCESSOR = new TestedBeforeNameAccessor();
    private static final Logger RUNTIME_LOG = new Logger(){

        public void error(Execution e, Throwable t) {
            if (e.getRuntime().getLoggerLevel().getPriority() <= Logger.Level.ERROR.getPriority() && this.needRecordLog(e)) {
                long procInstId = Long.parseLong(e.getRuntime().getId());
                ProcessRuntime.saveErrorLog(procInstId, t, e.getDefine().getTitle());
            }
        }

        public void warn(Execution e, Throwable t) {
            if (e.getRuntime().getLoggerLevel().getPriority() <= Logger.Level.WARN.getPriority() && this.needRecordLog(e)) {
                long procInstId = Long.parseLong(e.getRuntime().getId());
                ProcessRuntime.saveWarnLog(procInstId, t, e.getDefine().getTitle());
            }
        }

        public void info(Execution e, String text) {
            if (e.getRuntime().getLoggerLevel().getPriority() <= Logger.Level.INFO.getPriority() && this.needRecordLog(e)) {
                long procInstId = Long.parseLong(e.getRuntime().getId());
                ProcessRuntime.saveInfoLog(procInstId, e.getDefine().getTitle() + ":" + text);
            }
        }

        private boolean needRecordLog(Execution e) {
            int max = D.i((Object)e.getRuntime().getFlow().getAttribute("log_record_count"));
            int i = ProcessRuntime.increaseLogCountAndGet(e.getRuntime());
            if (i <= max) {
                return true;
            }
            if (i == max + 1) {
                long procInstId = Long.parseLong(e.getRuntime().getId());
                ProcessRuntime.saveInfoLog(procInstId, String.format(ResManager.loadKDString((String)"%1$s:\u5931\u8d25\u6570\u91cf\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff08%2$s\u6761\uff09\uff0c\u672c\u6b21\u6267\u884c\u5c06\u4e0d\u8bb0\u5f55\u540e\u7eed\u65e5\u5fd7\u3002", (String)"ServiceFlowParser_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getDefine().getTitle(), max));
                return false;
            }
            return false;
        }
    };

    public static Flow getFlow(long releasedFlowId) {
        return CacheableObjectManager.get(Flow.class, releasedFlowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findReleasedFlowId(long flowId) {
        String sql = "SELECT top 1 fid FROM t_isc_service_flow_r WHERE fflow_id=? ORDER BY fcreatetime DESC, fversion DESC";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            Object value = DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(flowId), Collections.singletonList(-5));
            long l = D.l((Object)value);
            return l;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    public static Flow parse(Map<String, Object> define) {
        String id = (String)define.get("id");
        String title = (String)define.get("title");
        int version = D.i((Object)define.get("version"));
        boolean isSubFlow = D.x((Object)define.get("is_sub_flow"));
        FlowBuilder flow = FC.getFactory().newInstance(id, title, version, "ISC", isSubFlow);
        flow.setLogger(RUNTIME_LOG);
        flow.setAttribute("flow_id", define.get("flow_id"));
        flow.setAttribute("disable_trace", (Object)D.x((Object)define.get("disable_trace")));
        flow.setAttribute("flow_number", define.get("name"));
        flow.setAttribute("job_mutex_id", define.get("job_mutex_id"));
        ServiceFlowParser.setLogLevel(define, flow);
        ServiceFlowParser.setAutoSaveTime(define, flow);
        ServiceFlowParser.setMaxLogRecordCount(define, flow);
        ServiceFlowParser.parseVariables(flow, (List)define.get("variables"));
        ServiceFlowParser.parseResources(flow, (List)define.get("resources"));
        ServiceFlowParser.parseNodes((BlockBuilder)flow, (Map)define.get("diagram"));
        ServiceFlowParser.parseTrans(flow, (Map)define.get("diagram"));
        ServiceFlowParser.setProcessDigest(define, flow);
        ServiceFlowParser.setProcessNotificationListeners(flow);
        ServiceFlowParser.setEventListeners(flow);
        ServiceFlowParser.setFlowListeners(flow);
        ServiceFlowParser.verifyFlow(flow, define);
        return flow.end();
    }

    public static long getMutex(Flow flow) {
        return D.l((Object)flow.getAttribute("job_mutex_id"));
    }

    private static void setFlowListeners(FlowBuilder flow) {
        flow.getRootBuilder().listener(Event.ON_COMPLETED, (Listener)new ParentFlowCallListenerOnComplete());
        flow.getRootBuilder().listener(Event.ON_TERMINATED, (Listener)new ParentFlowCallListenerOnTerminated());
    }

    private static void setAutoSaveTime(Map<String, Object> define, FlowBuilder flow) {
        flow.setAttribute("auto_save_time", (Object)Math.max(D.i((Object)define.get("auto_save_time")), 5));
    }

    private static void setMaxLogRecordCount(Map<String, Object> define, FlowBuilder flow) {
        int logRecordCount = D.i((Object)define.get("log_record_count"));
        flow.setAttribute("log_record_count", (Object)(logRecordCount > 0 ? logRecordCount : 500));
    }

    private static void setEventListeners(FlowBuilder flow) {
        long flowId = ServiceFlowParser.getServiceFlowId(flow);
        Map<String, Event> eventMap = ServiceFlowParser.getActionEventMap();
        for (Map.Entry<String, Event> entry : eventMap.entrySet()) {
            if (!ServiceFlowParser.needListen(flowId, entry.getKey())) continue;
            flow.getRootBuilder().listener(entry.getValue(), (Listener)new IscHubEventListener(entry.getKey(), flowId));
        }
    }

    private static Map<String, Event> getActionEventMap() {
        HashMap<String, Event> eventMap = new HashMap<String, Event>(8);
        eventMap.put("end", Event.ON_COMPLETED);
        eventMap.put("fail", Event.ON_SUSPENED);
        eventMap.put("cancel", Event.ON_TERMINATED);
        return eventMap;
    }

    private static boolean needListen(long evtSchemaId, String action) {
        List<EventRequest> eventRequests = HubEventBindingCache.find(ResourceType.isc_service_flow.name(), evtSchemaId, action);
        return !CollectionUtils.isEmpty(eventRequests);
    }

    private static void setProcessNotificationListeners(FlowBuilder flow) {
        long flowId = ServiceFlowParser.getServiceFlowId(flow);
        Map<Event, List<SfMessageUtil.MessageInfo>> msgMap = SfMessageUtil.getServiceFlowMessage(flowId);
        for (Map.Entry<Event, List<SfMessageUtil.MessageInfo>> entry : msgMap.entrySet()) {
            ServiceFlowNotificationListener sfNoticeListener = new ServiceFlowNotificationListener(entry.getKey(), flow, entry.getValue());
            flow.getRootBuilder().listener(entry.getKey(), (Listener)sfNoticeListener);
        }
    }

    private static void setProcessDigest(Map<String, Object> define, FlowBuilder flow) {
        String digest = D.s((Object)define.get("proc_digest"));
        if (digest != null) {
            Map<String, Object> ctx = ServiceFlowParser.getScriptContext(flow);
            flow.setAttribute("proc_digest", (Object)Format.parse((String)digest, ctx));
        }
    }

    public static boolean isDisableTrace(Flow flow) {
        return D.x((Object)flow.getAttribute("disable_trace"));
    }

    public static Format getProcessDigest(Flow flow) {
        return (Format)flow.getAttribute("proc_digest");
    }

    private static void setLogLevel(Map<String, Object> define, FlowBuilder flow) {
        String s = D.s((Object)define.get("loglevel"));
        s = s == null ? "WARN" : s.toUpperCase();
        flow.setAttribute("loglevel", (Object)Logger.Level.valueOf((String)s));
    }

    public static Logger.Level getLogLevel(Flow flow) {
        return (Logger.Level)flow.getAttribute("loglevel");
    }

    public static long getServiceFlowId(Flow flow) {
        return D.l((Object)flow.getAttribute("flow_id"));
    }

    public static long getServiceFlowId(FlowBuilder flow) {
        return D.l((Object)flow.getAttribute("flow_id"));
    }

    private static void verifyFlow(FlowBuilder flow, Map<String, Object> define) {
        ServiceFlowParser.verifyInitMode(flow, define);
        ServiceFlowParser.verifyPriorTrans(flow, (Map)define.get("diagram"));
    }

    private static void verifyPriorTrans(FlowBuilder flow, Map<String, Object> diagram) {
        Map define = (Map)diagram.get("nodes");
        for (NodeBuilder node : flow.getRootBuilder().children()) {
            Map item = (Map)define.get(node.getId());
            if (((String)item.get("type")).endsWith("Starter") || node.hasInComings()) continue;
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u4e0d\u662f\u542f\u52a8\u8282\u70b9\uff0c\u5fc5\u987b\u6dfb\u52a0\u8fde\u63a5\u4e14\u4f5c\u4e3a\u8fde\u63a5\u7684\u76ee\u6807\u8282\u70b9\uff01", (String)"ServiceFlowParser_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle()));
        }
    }

    private static void verifyInitMode(FlowBuilder flow, Map<String, Object> define) {
        if (flow.isSubFlow()) {
            return;
        }
        FlowStarter starter = ServiceFlowParser.getStarter(flow);
        if (starter == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\uff08%s\uff09\u6ca1\u6709\u542f\u52a8\u8282\u70b9\uff01", (String)"ServiceFlowParser_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flow.getTitle()));
        }
        String initMode = (String)define.get("INIT_MODE");
        if (!starter.getType().name().equals(initMode)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b(%1$s)\u8981\u6c42\u7684\u542f\u52a8\u6a21\u5f0f\u662f(%2$s)\uff0c\u4e0e\u542f\u52a8\u8282\u70b9\u7684\u7c7b\u578b\uff08%3$s\uff09\u4e0d\u5339\u914d\uff01", (String)"ServiceFlowParser_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[]{flow.getTitle(), initMode, starter.getType()}));
        }
    }

    public static void parseTrans(FlowBuilder flow, Map<String, Object> diagram) {
        Collection links = ((Map)diagram.get("links")).values();
        for (Map item : links) {
            TransitionCategory category = TransitionCategory.valueOf((String)item.get("type"));
            TransitionParser parser = category.getParser();
            if (parser == null) continue;
            String id = (String)item.get("id");
            String title = (String)item.get("title");
            String sourceId = (String)item.get("source");
            String targetId = (String)item.get("target");
            Transition.Type type = category.getType();
            TransitionBuilder trans = flow.transition(id, title, sourceId, targetId, type);
            parser.parse(trans, item);
        }
    }

    public static void parseNodes(BlockBuilder flow, Map<String, Object> diagram) {
        Collection nodes = ((Map)diagram.get("nodes")).values();
        for (Map item : nodes) {
            NodeCategory type = NodeCategory.valueOf((String)item.get("type"));
            NodeParser parser = type.getParser();
            if (parser == null) continue;
            String id = (String)item.get("id");
            String title = (String)item.get("title");
            NodeBuilder node = flow.node(id, title);
            node.setSynchronizer((NodeExecutionSync)ACTIVITY_SYNCHRONIZER);
            parser.parse(node, item);
            node.smartMerge();
            node.multiChoice();
            ServiceFlowParser.setListeners(item, node);
        }
    }

    private static void setListeners(Map<String, Object> item, NodeBuilder node) {
        String schedule;
        node.listener(Event.ON_READY, (Listener)CHECK_CANCEL_SIGNAL);
        if (D.x((Object)item.get("save_state_on_success"))) {
            node.listener(Event.ON_APP_STARTED, (Listener)STATE_SYNCHRONIZER);
        }
        if ((schedule = D.s((Object)item.get("wait_for_on_failed"))) != null) {
            Script script = Script.compile((String)schedule);
            node.setAttribute("wait_for_on_failed", (Object)script);
            String premise = D.s((Object)item.get("wait_for_premise"));
            if (premise != null) {
                node.setAttribute("wait_for_premise", (Object)Script.compile((String)premise));
            }
            node.insertCommand((Command)SET_RETRY);
        }
    }

    private static void parseResources(FlowBuilder flow, List<Map<String, Object>> list) {
        LinkedHashMap<String, Resource> resources = new LinkedHashMap<String, Resource>(list.size());
        for (Map<String, Object> item : list) {
            long id = D.l((Object)item.get("id"));
            String name = (String)item.get("name");
            String title = (String)item.get("title");
            ResourceCategory category = ResourceCategory.valueOf((String)item.get("category"));
            Resource res = category.create(id, name, title);
            resources.put(name, res);
            resources.put(String.valueOf(id), res);
        }
        flow.setAttribute("resources", Collections.unmodifiableMap(resources));
    }

    private static FlowStarter getStarter(FlowBuilder flow) {
        return (FlowStarter)flow.getAttribute(FLOW_STARTER);
    }

    public static FlowStarter getStarter(Flow flow) {
        return (FlowStarter)flow.getAttribute(FLOW_STARTER);
    }

    public static void setStarter(FlowBuilder flow, FlowStarter starter) {
        if (flow.getAttribute(FLOW_STARTER) != null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\uff08%s\uff09\u4e2d\u5b58\u5728\u591a\u4e2a\u542f\u52a8\u8282\u70b9\uff01", (String)"ServiceFlowParser_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flow.getTitle()));
        }
        flow.setAttribute(FLOW_STARTER, (Object)starter);
        ServiceFlowParser.registerFlowTrigger(flow, starter);
    }

    public static Set<FlowTrigger> getFlowTriggers(Flow flow) {
        Set triggers = (Set)flow.getAttribute(FLOW_TRIGGERS);
        if (triggers == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(triggers);
    }

    public static void registerFlowTrigger(FlowBuilder flow, FlowTrigger trigger) {
        HashSet<FlowTrigger> triggers = (HashSet<FlowTrigger>)flow.getAttribute(FLOW_TRIGGERS);
        if (triggers == null) {
            triggers = new HashSet<FlowTrigger>(16);
            flow.setAttribute(FLOW_TRIGGERS, triggers);
        }
        triggers.add(trigger);
    }

    public static Map<String, Resource> getResources(FlowBuilder flow) {
        return (Map)flow.getAttribute("resources");
    }

    public static Map<String, Resource> getResources(Flow flow) {
        return (Map)flow.getAttribute("resources");
    }

    public static Resource getResource(FlowBuilder flow, String name, String nodeTitle) {
        Map<String, Resource> map = ServiceFlowParser.getResources(flow);
        Resource res = map.get(name);
        if (res != null) {
            return res;
        }
        if (Hex.isNumber((String)name)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"ID\u4e3a\uff3b%1$s\uff3d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff3b%2$s\uff3d\u8282\u70b9\u7684\u8bbe\u7f6e\uff0c\u662f\u5426\u6d41\u7a0b\u5c5e\u6027\u66f4\u6539\u4e86\u8d44\u6e90\u4f46\u6b64\u8282\u70b9\u672a\u76f8\u5e94\u8c03\u6574\uff01", (String)"ServiceFlowParser_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, nodeTitle));
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u522b\u540d\u4e3a\uff3b%1$s\uff3d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff3b%2$s\uff3d\u8282\u70b9\u7684\u8bbe\u7f6e\uff0c\u662f\u5426\u6d41\u7a0b\u5c5e\u6027\u66f4\u6539\u4e86\u8d44\u6e90\u4f46\u6b64\u8282\u70b9\u672a\u76f8\u5e94\u8c03\u6574\uff01", (String)"ServiceFlowParser_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, nodeTitle));
    }

    public static Map<String, Object> getScriptContext(Builder element) {
        return ServiceFlowParser.getScriptContext(element.getFlowBuilder());
    }

    public static Map<String, Object> getScriptContext(FlowBuilder flow) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.putAll(ServiceFlowParser.getResources(flow));
        ctx.putAll(flow.getVariables());
        return ctx;
    }

    public static ExprGetter parseExprGetter(FlowBuilder flow, String expr) {
        Map<String, Object> ctx = ServiceFlowParser.getScriptContext(flow);
        Script script = Script.compile((String)expr, ctx);
        return new ExprGetter(script);
    }

    public static ExprSetter parseExprSetter(FlowBuilder flow, String expr) {
        Map<String, Object> ctx = ServiceFlowParser.getScriptContext(flow);
        ctx.put(".", ACCESSOR);
        Storer storer = Script.compile((String)expr, ctx).asSetter();
        return new ExprSetter(storer);
    }

    private static void parseVariables(FlowBuilder flow, List<Map<String, Object>> list) {
        for (Map<String, Object> item : list) {
            String name = ServiceFlowParser.addVariable(flow, item);
            ServiceFlowParser.setInputAndOutput(flow, item, name);
        }
    }

    private static String addVariable(FlowBuilder flow, Map<String, Object> item) {
        String id = (String)item.get("id");
        String name = D.s((Object)item.get("name"));
        String title = (String)item.get("title");
        boolean isArray = D.x((Object)item.get("is_array"));
        DataType dataType = ServiceFlowParser.getDataType(item, isArray);
        Object defaultValue = ServiceFlowParser.getDefaultValue(item);
        VariableBuilder var = flow.variable(id, name, title, dataType);
        var.setAttribute("define", item);
        var.setInitValue(defaultValue);
        return name;
    }

    public static Map<String, Object> getDefine(VariableBuilder var) {
        return (Map)var.getAttribute("define");
    }

    private static DataType getDataType(Map<String, Object> item, boolean isArray) {
        String type = (String)item.get("type");
        String category = (String)item.get("category");
        DataType dataType = DataTypeCategory.valueOf(category).getDataType(type);
        if (isArray) {
            return DataTypes.listType((DataType)dataType);
        }
        return dataType;
    }

    private static Object getDefaultValue(Map<String, Object> item) {
        Object defaultValue = D.s((Object)item.get("default_value"));
        if (defaultValue != null) {
            String[] s = defaultValue;
            defaultValue = s.startsWith("[") && s.endsWith("]") ? Json.toObject((String)s) : s.split(",");
        }
        return defaultValue;
    }

    private static void setInputAndOutput(FlowBuilder flow, Map<String, Object> item, String name) {
        if (D.x((Object)item.get("is_input"))) {
            flow.addInput(name);
        }
        if (D.x((Object)item.get("is_output"))) {
            flow.addOutput(name);
        }
    }

    static {
        try {
            CacheableObjectManager.registerFactory(new ServiceFlowFactory());
            Functions.init();
        }
        catch (Throwable e) {
            Log logger = LogFactory.getLog(ServiceFlowParser.class);
            logger.error("ServiceFlowParser_init_failed.", e);
            throw e;
        }
    }
}

