/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.FlowTrigger;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.n.EventWaitingUtil;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.misc.Json;

public class ServiceFlowReleaser
implements Const {
    private static final String FIELD_ENABLE = "enable";
    private static final String FIELD_IS_RELEASED = "is_released";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_INIT_MODE = "init_mode";

    public static Map<String, Object> generateFlowDefine(DynamicObject obj) {
        LinkedHashMap<String, Object> define = new LinkedHashMap<String, Object>();
        ServiceFlowReleaser.setBasics(define, obj);
        define.put("variables", ServiceFlowReleaser.getVariables(obj));
        define.put("resources", ServiceFlowReleaser.getResources(obj));
        define.put("diagram", ServiceFlowReleaser.getDiagram(obj));
        define.put("disable_trace", TraceUtil.isDisableTrace(obj));
        return define;
    }

    private static Object getDiagram(DynamicObject obj) {
        Object diagram = Json.toObject((String)obj.getString("define_json_tag"));
        if (diagram == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6ca1\u6709\u6d41\u7a0b\u56fe\u914d\u7f6e\u4fe1\u606f\uff01", (String)"ServiceFlowReleaser_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return diagram;
    }

    private static List<Map<String, Object>> getResources(DynamicObject obj) {
        DynamicObjectCollection items = obj.getDynamicObjectCollection("resources");
        ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>(items.size());
        for (DynamicObject o : items) {
            LinkedHashMap<String, Object> v = new LinkedHashMap<String, Object>();
            String category = D.s((Object)o.get("res_category"));
            v.put("category", category.toUpperCase());
            DynamicObject ref = (DynamicObject)o.get("res_ref");
            v.put("id", ref.getPkValue());
            v.put(FIELD_NAME, o.getString("res_alias"));
            v.put("title", ref.getString(FIELD_NAME));
            resources.add(v);
        }
        return resources;
    }

    private static List<Map<String, Object>> getVariables(DynamicObject obj) {
        DynamicObjectCollection items = obj.getDynamicObjectCollection("variables");
        ArrayList<Map<String, Object>> variables = new ArrayList<Map<String, Object>>(items.size());
        for (DynamicObject o : items) {
            LinkedHashMap<String, Object> v = new LinkedHashMap<String, Object>();
            v.put("id", o.getPkValue().toString());
            v.put(FIELD_NAME, o.getString("var_name"));
            v.put("title", o.getString("var_desc"));
            String category = D.s((Object)o.get("var_category"));
            v.put("category", category.toUpperCase());
            v.put("type", ServiceFlowReleaser.getDataType(o, category));
            v.put("is_array", D.x((Object)o.get("is_array")));
            v.put("default_value", D.s((Object)o.get("default_value")));
            v.put("is_input", D.x((Object)o.get("is_input_param")));
            v.put("is_output", D.x((Object)o.get("is_output_param")));
            variables.add(v);
        }
        return variables;
    }

    private static String getDataType(DynamicObject o, String category) {
        DynamicObject type = (DynamicObject)o.get("var_type");
        if ("isc_type_simple_value".equals(category)) {
            return ((String)type.get(FIELD_NUMBER)).toUpperCase();
        }
        return type.getPkValue().toString();
    }

    private static void setBasics(Map<String, Object> define, DynamicObject obj) {
        define.put(FIELD_NAME, obj.get(FIELD_NUMBER));
        define.put("title", obj.getString(FIELD_NAME));
        define.put("proc_digest", D.s((Object)obj.getString("proc_digest")));
        define.put(FIELD_VERSION, obj.get(FIELD_VERSION));
        define.put("flow_id", obj.getPkValue());
        String initMode = D.s((Object)obj.get(FIELD_INIT_MODE));
        boolean isSubFlow = FlowStarter.Type.SUB_FLOW.name().equals(initMode);
        define.put("is_sub_flow", isSubFlow);
        define.put("INIT_MODE", initMode);
        define.put("loglevel", D.s((Object)obj.get("loglevel")));
        define.put("auto_save_time", D.s((Object)obj.get("auto_save_time")));
        define.put("log_record_count", D.i((Object)obj.get("log_record_count")));
        define.put("job_mutex_id", obj.get("job_mutex_id"));
    }

    public static boolean disableDefine(long id) {
        long flowId = ServiceFlowParser.findReleasedFlowId(id);
        if (flowId == 0L) {
            return false;
        }
        Flow flow = ServiceFlowParser.getFlow(flowId);
        for (FlowTrigger t : ServiceFlowParser.getFlowTriggers(flow)) {
            t.disable();
        }
        return true;
    }

    public static boolean enableDefine(long id) {
        long flowId = ServiceFlowParser.findReleasedFlowId(id);
        if (flowId == 0L) {
            return false;
        }
        Flow flow = ServiceFlowParser.getFlow(flowId);
        for (FlowTrigger t : ServiceFlowParser.getFlowTriggers(flow)) {
            t.enable();
        }
        return true;
    }

    public static void releaseDefine(long id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_service_flow");
        ServiceFlowReleaser.updateForRelease(obj);
        Map<String, Object> define = ServiceFlowReleaser.generateFlowDefine(obj);
        DynamicObject released = ServiceFlowReleaser.createReleaseFlow(obj, define);
        Flow flow = ServiceFlowParser.parse(define);
        Util.save(obj);
        try {
            Util.save(released);
            EventWaitingUtil.detachEvents(id);
            EventWaitingUtil.disableEvents(id);
            for (FlowTrigger t : ServiceFlowParser.getFlowTriggers(flow)) {
                t.enable();
            }
            EventWaitingUtil.deleteDisabledEvents(id);
            ServiceFlowReleaser.updateFlowStatus(obj);
        }
        catch (Throwable err) {
            ServiceFlowReleaser.restoreFlowState(obj);
            throw err;
        }
    }

    private static void updateFlowStatus(DynamicObject obj) {
        obj.set(FIELD_ENABLE, (Object)1);
        Util.save(obj);
    }

    private static void restoreFlowState(DynamicObject obj) {
        obj.set(FIELD_IS_RELEASED, (Object)Boolean.FALSE);
        Util.save(obj);
    }

    private static void updateForRelease(DynamicObject obj) {
        obj.set(FIELD_VERSION, (Object)(D.i((Object)obj.get(FIELD_VERSION)) + 1));
        obj.set(FIELD_IS_RELEASED, (Object)Boolean.TRUE);
    }

    public static Map<String, Object> getDefineJson(long id) {
        DynamicObject r = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_service_flow_r");
        String json = r.getString("define_json_tag");
        return (Map)Json.toObject((String)json);
    }

    public static Map<String, Object> getDiagramJson(long id) {
        Map<String, Object> define = ServiceFlowReleaser.getDefineJson(id);
        return (Map)define.get("diagram");
    }

    public static DynamicObject createReleaseFlow(DynamicObject obj, Map<String, Object> define) {
        DynamicObject r = BusinessDataServiceHelper.newDynamicObject((String)"isc_service_flow_r");
        long id = IDService.get().genLongId();
        r.set("id", (Object)id);
        define.put("id", String.valueOf(id));
        r.set("define_json_tag", (Object)Json.toString(define));
        r.set("define_json", (Object)"...");
        long user = D.l((Object)RequestContext.get().getUserId());
        r.set("creator", (Object)user);
        r.set("modifier", (Object)user);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        r.set("createtime", (Object)time);
        r.set("modifytime", (Object)time);
        r.set(FIELD_NUMBER, obj.get(FIELD_NUMBER));
        r.set(FIELD_NAME, obj.get(FIELD_NAME));
        r.set(FIELD_VERSION, obj.get(FIELD_VERSION));
        r.set(FIELD_INIT_MODE, obj.get(FIELD_INIT_MODE));
        r.set("status", (Object)"C");
        r.set(FIELD_ENABLE, (Object)"1");
        r.set("flow", obj.getPkValue());
        return r;
    }
}

