/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.res.dc.DataCopySchemaResource;
import kd.isc.iscb.platform.core.sf.runtime.n.DataCopySchemaApplication;
import kd.isc.iscb.platform.core.sf.util.ExprUtil;
import kd.isc.iscb.util.dt.CollectionDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.Pair;

public class DataCopySchemaParser
implements NodeParser,
Const {
    private String title = null;

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        DataCopySchemaApplication app;
        FlowBuilder flowBuilder = node.getFlowBuilder();
        this.title = node.getTitle();
        Map dataCopy = (Map)item.get("data_copy");
        if (dataCopy == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8282\u70b9[%s]\u7684\u96c6\u6210\u65b9\u6848\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DataCopySchemaParser_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.title));
        }
        String dataCopyVar = D.s(dataCopy.get("var"));
        Resource resource = ServiceFlowParser.getResource(flowBuilder, dataCopyVar, node.getTitle());
        Assert.isTrue((boolean)(resource instanceof DataCopySchemaResource), (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s]\u7684%2$s\u8d44\u6e90\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u96c6\u6210\u65b9\u6848!", (String)"DataCopySchemaParser_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.title, dataCopyVar));
        DynamicObject schema = resource.getDynamicObject();
        Pair<ExprSetter, Boolean> srcSetter = this.getVariableSetter(node, D.s((Object)item.get("src_var")));
        Pair<ExprSetter, Boolean> tarSetter = this.getVariableSetter(node, D.s((Object)item.get("tar_var")));
        if ("filters".equals(item.get("filter_type"))) {
            List<Map<String, Object>> filterList = this.getFilterList(item, flowBuilder, dataCopyVar, schema);
            app = new DataCopySchemaApplication(schema, filterList, srcSetter, tarSetter);
        } else {
            Map<String, Object> params = this.getParams(item, flowBuilder, dataCopyVar, schema);
            app = new DataCopySchemaApplication(schema, params, srcSetter, tarSetter);
        }
        node.biz((Application)app);
    }

    private List<Map<String, Object>> getFilterList(Map<String, Object> item, FlowBuilder builder, String var, DynamicObject schema) {
        List filterList = (List)item.get("filter_entries");
        if (CollectionUtils.isEmpty((Collection)filterList)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s]\u7684%2$s\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6267\u884c!", (String)"DataCopySchemaParser_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.title, var));
        }
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(item.size());
        for (Map map : filterList) {
            HashMap<String, ExprGetter> temp = new HashMap<String, ExprGetter>(map);
            String value = D.s(map.get("filter_value_fixed"));
            if (value != null) {
                temp.put("filter_value", new ExprGetter(value, null));
            } else {
                String expr = D.s(map.get("filter_value_var"));
                temp.put("filter_value", ExprUtil.eval(expr, builder, schema));
            }
            filters.add(temp);
        }
        return filters;
    }

    private Map<String, Object> getParams(Map<String, Object> item, FlowBuilder builder, String dataCopyVar, DynamicObject schema) {
        List paramEntries = (List)item.get("params_entry");
        if (CollectionUtils.isEmpty((Collection)paramEntries)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s]\u7684%2$s\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6267\u884c!", (String)"DataCopySchemaParser_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.title, dataCopyVar));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(paramEntries.size());
        for (Map m : paramEntries) {
            String paramsName = D.s(m.get("params_name"));
            String value = D.s(m.get("params_var_fixed"));
            if (value == null) {
                String expr = D.s(m.get("params_var"));
                map.put(paramsName, ExprUtil.eval(expr, builder, schema));
                continue;
            }
            map.put(paramsName, new ExprGetter(value, null));
        }
        return map;
    }

    private Pair<ExprSetter, Boolean> getVariableSetter(NodeBuilder node, String varText) {
        ExprSetter setter = null;
        Boolean isArray = Boolean.FALSE;
        if (varText != null) {
            String var = this.getVarName(varText);
            VariableBuilder builder = node.getVariable(var);
            Assert.notNull((Object)builder, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s]\u7684\u6d41\u7a0b\u53d8\u91cf%2$s\u4e0d\u5b58\u5728!", (String)"DataCopySchemaParser_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.title, var));
            if (builder.getDataType() instanceof CollectionDataType) {
                isArray = Boolean.TRUE;
            }
            setter = ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), varText);
        }
        return new Pair(setter, (Object)isArray);
    }

    private String getVarName(String varText) {
        int index = varText.indexOf(46);
        return index > 0 ? varText.substring(0, index) : varText;
    }
}

