/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.res.MetaSchemaResource;
import kd.isc.iscb.platform.core.sf.runtime.n.DataLoaderApplication;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.dt.CollectionDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class DataLoaderParser
implements NodeParser,
Const {
    private static final String CANDIDATE_KEYS = "candidateKeys";
    private static final String ENTRIES_ACTIONS = "actions";
    public static final String BATCH_SIZE = "batch_size";

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        Object proxyUser;
        FlowBuilder flowBuilder = node.getFlowBuilder();
        String title = node.getTitle();
        if (item.get("data_schema") == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%s\uff3d\u4e2d\u7684\u96c6\u6210\u5bf9\u8c61\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DataLoaderParser_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
        String schemaId = D.s((Object)item.get("data_schema"));
        Resource dataSchema = ServiceFlowParser.getResource(flowBuilder, schemaId, node.getTitle());
        if (!(dataSchema instanceof MetaSchemaResource)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%s\uff3d\u4e2d\u96c6\u6210\u5bf9\u8c61\u5b57\u6bb5\u8d44\u6e90\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u96c6\u6210\u5bf9\u8c61!", (String)"DataLoaderParser_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
        DynamicObject schema = dataSchema.getDynamicObject();
        String proxyUserVar = D.s((Object)item.get("proxy_user_var"));
        String proxyUserCom = D.s((Object)item.get("proxy_user"));
        int batchSize = D.i((Object)item.get(BATCH_SIZE));
        if (proxyUserVar != null) {
            if (proxyUserCom != null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%s\uff3d\u4e2d \u201c\u4ee3\u7406\u7528\u6237\u201d \u53ca \u201c\u4ee3\u7406\u7528\u6237\u53d8\u91cf\u201d \u53ea\u5141\u8bb8\u9009\u586b\u4e00\u9879\u3002", (String)"DataLoaderParser_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
            }
            proxyUser = ServiceFlowParser.parseExprGetter(flowBuilder, proxyUserVar);
        } else {
            if (batchSize > 1 && proxyUserCom != null && proxyUserCom.startsWith("#{") && proxyUserCom.endsWith("}")) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%s\uff3d\u4e2d\u6240\u8bbe\u7f6e\u7684\u201c\u4ee3\u7406\u7528\u6237\u201d\u5f15\u7528\u4e3a\u76ee\u6807\u5355\u636e\u5b57\u6bb5\u503c\uff0c\u8be5\u573a\u666f\u4e0b\u4e0d\u652f\u6301\u76ee\u6807\u6570\u636e\u5206\u6279\u3002", (String)"DataLoaderParser_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
            }
            proxyUser = proxyUserCom;
        }
        String tarVar = D.s((Object)item.get("tar_var"));
        VariableBuilder variable = flowBuilder.getVariable(tarVar);
        if (variable == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u4e2d\u6d41\u7a0b\u53d8\u91cf\uff1a%2$s\u4e0d\u5b58\u5728\uff01", (String)"DataLoaderParser_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title, tarVar));
        }
        String outPutId = D.s((Object)item.get("tar_ids_output_var"));
        Pair<ExprSetter, Boolean> tarOutputIds = this.getVariableSetter(node, outPutId);
        String outPutResults = D.s((Object)item.get("tar_results_output_var"));
        Pair<ExprSetter, Boolean> tarOutputResults = this.getVariableSetter(node, outPutResults);
        HashMap<String, Object> operation_params = new HashMap<String, Object>(1);
        if (!(item.get(ENTRIES_ACTIONS) instanceof List)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u4e2d\u64cd\u4f5c\u5217\u8868\uff1a%2$s\u4e0d\u5408\u6cd5", (String)"DataLoaderParser_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title, item.get(ENTRIES_ACTIONS)));
        }
        List<String> actions = this.buildActions(node, item, operation_params);
        if (!(item.get(CANDIDATE_KEYS) instanceof List)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u4e2d\u5019\u9009\u952e\u5217\u8868\uff1a%2$s\u4e0d\u5408\u6cd5", (String)"DataLoaderParser_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title, item.get(CANDIDATE_KEYS)));
        }
        List candidateKeys = (List)item.get(CANDIDATE_KEYS);
        DataLoaderApplication app = new DataLoaderApplication(schema, tarVar, actions, operation_params, candidateKeys, proxyUser, tarOutputIds, batchSize, tarOutputResults);
        node.biz((Application)app);
    }

    private List<String> buildActions(NodeBuilder node, Map<String, Object> item, Map<String, Object> target_operation_params) {
        List actions = (List)item.get(ENTRIES_ACTIONS);
        ArrayList<String> actionsList = new ArrayList<String>(actions.size());
        for (Map action : actions) {
            String actionNumber = D.s(action.get("tar_action_number"));
            if (actionNumber == null) continue;
            actionsList.add(actionNumber);
            String operation_str = D.s(action.get("tar_action_params"));
            if (StringUtil.isEmpty((String)operation_str)) continue;
            target_operation_params.put(actionNumber, ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), operation_str));
        }
        if (actionsList.isEmpty()) {
            actionsList.add(TableAction._SAVE.name());
        }
        return actionsList;
    }

    private Pair<ExprSetter, Boolean> getVariableSetter(NodeBuilder node, String varText) {
        ExprSetter setter = null;
        Boolean isArray = Boolean.FALSE;
        if (varText != null) {
            int index = varText.indexOf(46);
            String var = index > 0 ? varText.substring(0, index) : varText;
            VariableBuilder builder = node.getVariable(var);
            if (builder == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u4e2d\u6d41\u7a0b\u53d8\u91cf\uff1a%2$s\u4e0d\u5b58\u5728!", (String)"DataLoaderParser_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), varText));
            }
            DataType dataType = builder.getDataType();
            isArray = dataType instanceof CollectionDataType;
            if (builder.getDataType() instanceof CollectionDataType) {
                isArray = Boolean.TRUE;
            }
            setter = ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), varText);
        }
        return new Pair(setter, (Object)isArray);
    }
}

