/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.Assert;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.res.MetaSchemaResource;
import kd.isc.iscb.platform.core.sf.runtime.n.EventWaitingUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.dt.CollectionDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;

public class EventStarterParser
implements NodeParser,
Const {
    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        long flowDefId = ServiceFlowParser.getServiceFlowId(node.getFlowBuilder());
        String varName = D.s((Object)item.get("variables_value"));
        if (varName == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e8b\u4ef6\u542f\u52a8\u8282\u70b9[%s]\u4e2d\u7684\u8d4b\u503c\u53d8\u91cf", (String)"EventStarterParser_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle()));
        }
        VariableBuilder variableBuilder = node.getFlowBuilder().getVariable(varName);
        if (variableBuilder == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u542f\u52a8\u8282\u70b9[%1$s]\u4e2d\u7684\u8d4b\u503c\u53d8\u91cf[%2$s]\u4e0d\u5b58\u5728", (String)"EventStarterParser_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), varName));
        }
        String s = D.s((Object)item.get("bill_events"));
        if (s == null || s.length() < 3) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u542f\u52a8\u8282\u70b9[%s]\u6ca1\u6709\u9009\u62e9\u4e8b\u4ef6\uff01", (String)"EventStarterParser_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle()));
        }
        Resource resource = ServiceFlowParser.getResource(node.getFlowBuilder(), D.s((Object)item.get("data_schema")), node.getTitle());
        Assert.isTrue((boolean)(resource instanceof MetaSchemaResource), (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u5f15\u7528\u7684\u8d44\u6e90\u4e0d\u662f\u96c6\u6210\u5bf9\u8c61\uff01", (String)"EventStarterParser_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle()));
        boolean isVarArray = variableBuilder.getDataType() instanceof CollectionDataType;
        ServiceFlowParser.setStarter(node.getFlowBuilder(), new EventStarter(flowDefId, item, isVarArray, resource.getDynamicObject()));
    }

    public static class EventStarter
    implements FlowStarter {
        private long flowDefId;
        private Map<String, Object> item;
        private boolean isArray;
        private DynamicObject meta;

        public EventStarter(long flowDefId, Map<String, Object> item, boolean isVarArray, DynamicObject meta) {
            this.flowDefId = flowDefId;
            this.item = item;
            this.isArray = isVarArray;
            this.meta = meta;
        }

        @Override
        public FlowStarter.Type getType() {
            return FlowStarter.Type.EVENT;
        }

        public DynamicObject getMeta() {
            return this.meta;
        }

        public Map<String, Object> getNodeInfo() {
            return Collections.unmodifiableMap(this.item);
        }

        public String getVarName() {
            return D.s((Object)this.item.get("variables_value"));
        }

        public boolean isVarArray() {
            return this.isArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enable() {
            String s = D.s((Object)this.item.get("bill_events"));
            String[] events = s == null ? new String[]{} : s.split(",");
            String entity = this.meta.getString("full_name");
            long dataSourceId = this.meta.getLong("group_id");
            long dbLink = DataSource.get(dataSourceId).getDbLink();
            ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense("isc_service_flow", this.flowDefId));
            try (ConnectionWrapper cn = ConnectionManager.getConnection(dbLink);){
                String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
                Map<String, Object> requires = EventWaitingUtil.initRequiresMap(this.item);
                EventBindingUtil.TriggerType type = EventBindingUtil.TriggerType.ServiceFlowTrigger;
                cn.getFactory().attachEvents(cn, iscHub, type, this.flowDefId, entity, events, requires);
            }
            finally {
                ConnectionManager.popResLicense();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disable() {
            String entity = this.meta.getString("full_name");
            long dataSourceId = this.meta.getLong("group_id");
            long dbLink = DataSource.get(dataSourceId).getDbLink();
            ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense("isc_service_flow", this.flowDefId));
            try (ConnectionWrapper cn = ConnectionManager.getConnection(dbLink);){
                String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
                EventBindingUtil.TriggerType type = EventBindingUtil.TriggerType.ServiceFlowTrigger;
                cn.getFactory().detachEvents(cn, iscHub, type, this.flowDefId, entity);
            }
            finally {
                ConnectionManager.popResLicense();
            }
        }
    }
}

