/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.sf.FlowTrigger;
import kd.isc.iscb.platform.core.sf.runtime.n.EventWaitingUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;

final class EventWaitingTrigger
implements FlowTrigger {
    private final String nodeId;
    private final Map<String, Object> item;
    private final long flowId;
    private final String nodeTitle;
    private final String bill_events;

    EventWaitingTrigger(String nodeId, Map<String, Object> item, long flowId, String nodeTitle, String bill_events) {
        this.nodeId = nodeId;
        this.item = item;
        this.flowId = flowId;
        this.nodeTitle = nodeTitle;
        this.bill_events = bill_events;
    }

    @Override
    public void enable() {
        DynamicObject event = this.createEventObject();
        this.setEventInfo(event);
        EventWaitingUtil.attachEvent(event);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{event});
    }

    private void setEventInfo(DynamicObject event) {
        event.set("service_flow_id", (Object)this.flowId);
        event.set("node", (Object)this.nodeId);
        event.set("node_title", (Object)this.nodeTitle);
        event.set("meta_schema_id", (Object)D.l((Object)this.item.get("data_schema")));
        event.set("events", (Object)this.bill_events);
        event.set("requires", (Object)"...");
        event.set("requires_tag", (Object)Json.toString(EventWaitingUtil.initRequiresMap(this.item)));
        event.set("signal_fields", (Object)this.getSignalFields(this.item));
        event.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        event.set("enabled", (Object)Boolean.TRUE);
    }

    private DynamicObject createEventObject() {
        DynamicObject event = this.loadEvent();
        if (event == null) {
            event = BusinessDataServiceHelper.newDynamicObject((String)"isc_sf_waiting_event");
            event.set("id", (Object)IDService.get().genLongId());
        } else {
            event = BusinessDataServiceHelper.loadSingle((Object)event.getPkValue(), (String)"isc_sf_waiting_event");
        }
        return event;
    }

    private String getSignalFields(Map<String, Object> item) {
        StringBuilder s = new StringBuilder();
        for (Map e : (List)item.get("filter_entry")) {
            String column;
            if (s.length() > 0) {
                s.append(',');
            }
            if ((column = D.s(e.get("filter_column"))) != null) {
                s.append(column);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u6ca1\u6709\u8bbe\u7f6e\u201c\u7b49\u5f85\u6761\u4ef6\u201d\u7684\u201c\u6761\u4ef6\u5b57\u6bb5\u201d\u3002", (String)"EventWaitingTrigger_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.nodeTitle));
        }
        return s.toString();
    }

    @Override
    public void disable() {
        DynamicObject event = this.loadEvent();
        if (event != null) {
            event = BusinessDataServiceHelper.loadSingle((Object)event.getPkValue(), (String)"isc_sf_waiting_event");
            EventWaitingUtil.detachEvent(event);
            event.set("enabled", (Object)Boolean.FALSE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{event});
        }
    }

    private DynamicObject loadEvent() {
        QFilter filter = new QFilter("service_flow", "=", (Object)this.flowId).and(new QFilter("node", "=", (Object)this.nodeId));
        DynamicObject event = BusinessDataServiceHelper.loadSingle((String)"isc_sf_waiting_event", (String)"", (QFilter[])new QFilter[]{filter});
        return event;
    }
}

