/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.cache.DynamicObjectCacheProxy;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.dc.mq.ServiceFlowRouter;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;

public class MessageStarterParser
implements NodeParser,
Const {
    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        this.validateData(item);
        FlowBuilder flowBuilder = node.getFlowBuilder();
        long flowId = D.l((Object)node.getFlowBuilder().getAttribute("flow_id"));
        String subscriberName = D.s((Object)item.get("mq_subscriber"));
        Resource mqSubscriber = ServiceFlowParser.getResource(flowBuilder, subscriberName, node.getTitle());
        String varName = D.s((Object)item.get("variables_value"));
        VariableBuilder variableBuilder = node.getFlowBuilder().getVariable(varName);
        if (variableBuilder == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6d88\u606f\u542f\u52a8\u8282\u70b9[%1$s]\u4e2d\u7684\u8d4b\u503c\u53d8\u91cf[%2$s]\u4e0d\u5b58\u5728", (String)"MessageStarterParser_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), varName));
        }
        MessageStarter starter = new MessageStarter(flowId, D.l((Object)mqSubscriber.getDynamicObject().getPkValue()), varName, variableBuilder.isArray());
        ServiceFlowParser.setStarter(node.getFlowBuilder(), starter);
    }

    private void validateData(Map<String, Object> item) {
        StringBuilder sb = new StringBuilder();
        if (item.get("mq_subscriber") == null) {
            sb.append(ResManager.loadKDString((String)"\u6d88\u606f\u8ba2\u9605\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"MessageStarterParser_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (item.get("variables_value") == null) {
            sb.append(ResManager.loadKDString((String)"\u8d4b\u503c\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"MessageStarterParser_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            String re = String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s] \u4e2d\u7684%2$s", (String)"MessageStarterParser_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), item.get("title"), sb);
            throw new KDBizException(re);
        }
    }

    public static class MessageStarter
    implements FlowStarter {
        private long subscriberId;
        private long flowId;
        private String assignValName;
        private boolean is_array;

        private MessageStarter(long flowId, long subscriberId, String assignValName, boolean isArray) {
            this.flowId = flowId;
            this.subscriberId = subscriberId;
            this.assignValName = assignValName;
            this.is_array = isArray;
        }

        public String getAssignValName() {
            return this.assignValName;
        }

        public boolean isArray() {
            return this.is_array;
        }

        @Override
        public FlowStarter.Type getType() {
            return FlowStarter.Type.MESSAGE;
        }

        @Override
        public void enable() {
            DynamicObject flow = DynamicObjectCacheProxy.getById(this.flowId, "isc_service_flow");
            flow.set("mq_subscriber_id", (Object)this.subscriberId);
            Util.save(flow);
            ServiceFlowRouter.clearCache();
        }

        @Override
        public void disable() {
            ServiceFlowRouter.clearCache();
        }
    }
}

