/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.constant.MessageType;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.runtime.n.NoticeSenderApplication;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.StringUtil;

public class NoticeSenderParser
implements NodeParser,
Const {
    private static final Pattern ID_REGEX = Pattern.compile("(?<=\\()[0-9]*?(?=\\))");

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        this.validateData(item);
        String targetSystem = String.valueOf(item.get("target_system"));
        String noticeMethod = String.valueOf(item.get("notice_method"));
        String recipient = String.valueOf(item.get("recipient"));
        String recipient_noterp = String.valueOf(item.get("recipient_noterp"));
        String recipientvar_erp = String.valueOf(item.get("recipientvar_erp"));
        String recipientvar_noterp = String.valueOf(item.get("recipientvar_noterp"));
        String msgTitle = String.valueOf(item.get("msg_title"));
        String msgContent = String.valueOf(item.get("msg_content"));
        if (this.isNullStr(recipient_noterp)) {
            recipient = recipient + recipient_noterp;
        }
        String recipientvar = "";
        if (this.isNullStr(recipientvar_erp) && !(recipientvar = recipientvar_erp).endsWith(";")) {
            recipientvar = recipientvar + ';';
        }
        if (this.isNullStr(recipientvar_noterp)) {
            recipientvar = recipientvar + recipientvar_noterp;
        }
        HashMap ctx = new HashMap();
        FlowBuilder flowBuilder = node.getFlowBuilder();
        boolean is_send_flow_detail = D.x((Object)item.getOrDefault("send_flow_details", Boolean.TRUE));
        MessageType.Message message = this.buildMessage(noticeMethod, recipient, recipientvar, flowBuilder);
        node.biz((Application)new NoticeSenderApplication(MessageType.valueOf(targetSystem), Format.parse((String)msgTitle, ctx), Format.parse((String)msgContent, ctx), message, is_send_flow_detail));
    }

    private boolean isNullStr(String recipientvar_noterp) {
        return recipientvar_noterp.trim().length() > 0 && !"null".equals(recipientvar_noterp);
    }

    private MessageType.Message buildMessage(String noticeMethod, String recipent, String recipientvar, FlowBuilder flowBuilder) {
        MessageType.Message message = new MessageType.Message();
        message.setNoticeMethod(noticeMethod);
        Matcher idMatcher = ID_REGEX.matcher(recipent);
        ArrayList<Long> ids = new ArrayList<Long>();
        while (idMatcher.find()) {
            ids.add(Long.parseLong(idMatcher.group()));
        }
        message.setRecipients(ids);
        String[] vars = recipientvar.split(";");
        ArrayList<ExprGetter> getters = new ArrayList<ExprGetter>(vars.length);
        for (String var : vars) {
            getters.add(ServiceFlowParser.parseExprGetter(flowBuilder, var));
        }
        message.setRecipientsVar(getters);
        return message;
    }

    private void validateData(Map<String, Object> item) {
        StringBuilder sb = new StringBuilder();
        if (item.get("target_system") == null) {
            sb.append(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"NoticeSenderParser_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (item.get("notice_method") == null) {
            sb.append(ResManager.loadKDString((String)"\u901a\u77e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"NoticeSenderParser_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)D.s((Object)item.get("msg_title")))) {
            sb.append(ResManager.loadKDString((String)"\u901a\u77e5\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"NoticeSenderParser_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)D.s((Object)item.get("msg_content")))) {
            sb.append(ResManager.loadKDString((String)"\u901a\u77e5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"NoticeSenderParser_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            StringBuilder tmp = new StringBuilder();
            tmp.append(String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s] \u4e2d\u7684", (String)"NoticeSenderParser_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), item.get("title"))).append((CharSequence)sb);
            throw new KDBizException(tmp.toString());
        }
    }
}

