/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.SubFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.ActivitySync;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.flow.core.Event;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.flow.core.plugin.Listener;
import kd.isc.iscb.util.flow.core.plugin.SubFlowLoader;

public class SubFlowInlined {
    public static boolean isSubFlowNode(Execution e) {
        return e.getDefine().getAttribute("SUB_FLOW_ID") != null;
    }

    static void parse(NodeBuilder node, Map<String, Object> item) {
        long subflowId = SubFlowParser.getSubFlowReleasedId(node, item);
        node.setAttribute("SUB_FLOW_ID", (Object)subflowId);
        node.listener(Event.ON_CREATED, (Listener)new RecordSubFlowId());
        Flow subflow = ServiceFlowParser.getFlow(subflowId);
        List<String> inputs = SubFlowInlined.prepareInputs(node, subflow, item);
        List<String> outputs = SubFlowInlined.prepareOutputs(node, subflow, item);
        node.call((SubFlowLoader)new InlineSubFlowLoader(subflow), inputs.toArray(new String[0]), outputs.toArray(new String[0]));
    }

    private static List<String> prepareOutputs(NodeBuilder node, Flow subflow, Map<String, Object> item) {
        List outputVariables = subflow.getOutputVariables();
        ArrayList<String> list = new ArrayList<String>(outputVariables.size());
        Map outputs = (Map)item.get("output");
        for (Variable formal : outputVariables) {
            Map values = (Map)outputs.get(formal.getName());
            list.add(SubFlowInlined.getOrCreateOutputVariable(node, formal, values));
        }
        return list;
    }

    private static String getOrCreateOutputVariable(NodeBuilder node, Variable formal, Map<String, String> values) {
        if (values == null) {
            return SubFlowInlined.prepareMiddleVariable(node, formal, (ExprSetter)null);
        }
        String var = D.s((Object)values.get("value"));
        if (var == null) {
            return SubFlowInlined.prepareMiddleVariable(node, formal, (ExprSetter)null);
        }
        if (node.getFlowBuilder().getVariable(var) != null) {
            return var;
        }
        ExprSetter setter = ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), var);
        return SubFlowInlined.prepareMiddleVariable(node, formal, setter);
    }

    private static String prepareMiddleVariable(NodeBuilder node, Variable formal, ExprSetter setter) {
        String varname = "O_" + formal.getName();
        node.variable(node.getId() + "/" + varname, varname, formal.getTitle(), DataTypes.UNKNOWN);
        node.listener(Event.ON_APP_COMPLETED, (Listener)new MiddleVariableSetter(varname, setter));
        return varname;
    }

    private static List<String> prepareInputs(NodeBuilder node, Flow subflow, Map<String, Object> item) {
        ArrayList<String> vars = new ArrayList<String>();
        Map inputs = (Map)item.get("input");
        for (Variable formal : subflow.getInputVariables()) {
            Map values = (Map)inputs.get(formal.getName());
            if (values != null) {
                vars.add(SubFlowInlined.getOrCreateInputVariable(node, formal, values));
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u8f93\u5165\u53d8\u91cf\u201c%1$s\u201d\u6ca1\u6709\u8bbe\u7f6e\u53c2\u6570\u503c\uff0c\u8bf7\u6253\u5f00\u5b50\u6d41\u7a0b\u8282\u70b9\u201c%2$s\u201d\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SubFlowInlined_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), formal.getName(), node.getTitle()));
        }
        return vars;
    }

    private static String getOrCreateInputVariable(NodeBuilder node, Variable formal, Map<String, String> values) {
        String var = D.s((Object)values.get("value"));
        if (var != null) {
            if (node.getFlowBuilder().getVariable(var) != null) {
                return var;
            }
            ExprGetter getter = ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), var);
            return SubFlowInlined.prepareMiddleVariable(node, formal, getter);
        }
        ExprGetter getter = new ExprGetter(D.s((Object)values.get("fixed")), null);
        return SubFlowInlined.prepareMiddleVariable(node, formal, getter);
    }

    private static String prepareMiddleVariable(NodeBuilder node, Variable formal, ExprGetter getter) {
        String varname = "I_" + formal.getName();
        node.variable(node.getId() + "/" + varname, varname, formal.getTitle(), DataTypes.UNKNOWN);
        node.listener(Event.ON_READY, (Listener)new MiddleVariableGetter(varname, getter));
        return varname;
    }

    private static final class RecordSubFlowId
    implements Listener {
        private RecordSubFlowId() {
        }

        public void execute(Execution e) {
            String flowId = D.s((Object)e.getDefine().getAttribute("SUB_FLOW_ID"));
            ActivitySync.recordSubFlowId(e, flowId);
        }
    }

    private static final class MiddleVariableSetter
    implements Listener {
        private String var;
        private ExprSetter setter;

        public MiddleVariableSetter(String var, ExprSetter setter) {
            this.var = var;
            this.setter = setter;
        }

        public void execute(Execution e) {
            if (this.setter != null) {
                Object value = e.get(this.var);
                this.setter.set(e, value);
            }
        }
    }

    private static final class MiddleVariableGetter
    implements Listener {
        private String var;
        private ExprGetter getter;

        public MiddleVariableGetter(String var, ExprGetter getter) {
            this.var = var;
            this.getter = getter;
        }

        public void execute(Execution e) {
            Object value = this.getter.get(e);
            e.set(this.var, value);
        }
    }

    private static final class InlineSubFlowLoader
    implements SubFlowLoader {
        private final Flow flow;

        private InlineSubFlowLoader(Flow flow) {
            this.flow = flow;
        }

        public Flow getFlow(Execution parent) {
            return this.flow;
        }
    }
}

