/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.parser.n.SubFlowInlined;
import kd.isc.iscb.platform.core.sf.runtime.l.SubFlowCallListenerOnTerminated;
import kd.isc.iscb.platform.core.sf.runtime.n.SubFlowApplication;
import kd.isc.iscb.platform.core.sf.runtime.n.SubFlowCallback;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Event;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.flow.core.plugin.Callback;
import kd.isc.iscb.util.flow.core.plugin.Listener;
import kd.isc.iscb.util.misc.StringUtil;

public class SubFlowParser
implements NodeParser,
Const {
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String VALUE = "value";

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        if (this.isSubFlowEmpty(item)) {
            String title = D.s((Object)item.get("title"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9[%s]\u4e2d\u5b50\u6d41\u7a0b\u5b57\u6bb5\u5fc5\u586b", (String)"SubFlowParser_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
        if (D.x((Object)item.get("is_independent_mode"))) {
            this.parseWithObsoleteMode(node, item);
        } else {
            SubFlowInlined.parse(node, item);
        }
    }

    private void parseWithObsoleteMode(NodeBuilder node, Map<String, Object> item) {
        long subFlowReleasedId = SubFlowParser.getSubFlowReleasedId(node, item);
        Map<String, Object> input = this.getInputMap(node, item);
        Map<String, Object> outVar = this.getOutputMap(node, item);
        SubFlowApplication app = new SubFlowApplication(subFlowReleasedId, input, outVar);
        SubFlowCallback callback = new SubFlowCallback(outVar);
        node.biz((Application)app, (Callback)callback);
        node.listener(Event.ON_TERMINATED, (Listener)new SubFlowCallListenerOnTerminated());
    }

    private Map<String, Object> getOutputMap(NodeBuilder node, Map<String, Object> item) {
        Map output = (Map)item.get(OUTPUT);
        LinkedHashMap<String, Object> subFlowOutput = new LinkedHashMap<String, Object>(output.size());
        for (Map.Entry entry : output.entrySet()) {
            Map values = (Map)entry.getValue();
            String var = D.s(values.get(VALUE));
            if (StringUtil.isEmpty((String)var)) {
                subFlowOutput.put((String)entry.getKey(), null);
                continue;
            }
            subFlowOutput.put((String)entry.getKey(), ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), var));
        }
        return subFlowOutput;
    }

    private Map<String, Object> getInputMap(NodeBuilder node, Map<String, Object> item) {
        Map input = (Map)item.get(INPUT);
        LinkedHashMap<String, Object> subFlowInput = new LinkedHashMap<String, Object>(input.size());
        for (Map.Entry entry : input.entrySet()) {
            Map values = (Map)entry.getValue();
            String fixed = (String)values.get("fixed");
            String var = (String)values.get(VALUE);
            if (!StringUtil.isEmpty((String)var)) {
                subFlowInput.put((String)entry.getKey(), ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), var));
                continue;
            }
            if (!StringUtil.isEmpty((String)fixed)) {
                subFlowInput.put((String)entry.getKey(), new ExprGetter(fixed, null));
                continue;
            }
            subFlowInput.put((String)entry.getKey(), null);
        }
        return subFlowInput;
    }

    private boolean isSubFlowEmpty(Map<String, Object> item) {
        return item.get("sub_flow") == null;
    }

    static long getSubFlowReleasedId(NodeBuilder node, Map<String, Object> item) {
        FlowBuilder flowBuilder = node.getFlowBuilder();
        Resource resource = ServiceFlowParser.getResource(flowBuilder, D.s((Object)item.get("sub_flow")), D.s((Object)item.get("title")));
        long subFlowId = resource.getId();
        long releasedId = ServiceFlowParser.findReleasedFlowId(subFlowId);
        if (releasedId > 0L) {
            return releasedId;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u53d1\u5e03\u5b50\u6d41\u7a0b%s", (String)"SubFlowParser_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), item.get("title")));
    }
}

