/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import com.alibaba.fastjson.JSON;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.startjob.CronJobUtil;
import kd.isc.iscb.platform.core.task.SFTimerStarterTask;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.platform.core.util.TimerJobUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DataTypeError;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.misc.Hash;
import org.quartz.CronExpression;

public class TimerStarterParser
implements NodeParser,
Const {
    private static final String PROP_FLOW_ID = "flowid";
    private static final String ENTITY_SCH_TASKDEFINE = "sch_taskdefine";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String FIELD_NUMBER = "number";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        TimerStarterParser.validateData(item);
        String flowId = D.s((Object)node.getFlowBuilder().getAttribute("flow_id"));
        String releaseId = node.getFlowBuilder().getId();
        String cron = D.s((Object)item.get("cron_expr"));
        String interval = D.s((Object)item.get("interval"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp startTime = this.dateStringToStamp(String.valueOf(item.get("start_time")), format);
        Timestamp endTime = this.dateStringToStamp(String.valueOf(item.get("end_time")), format);
        String title = node.getFlowBuilder().getTitle();
        String jobUser = D.s((Object)item.get("exe_job_user"));
        TimerFlowStarter starter = new TimerFlowStarter(flowId, releaseId, title, cron, startTime, endTime, interval, jobUser);
        ServiceFlowParser.setStarter(node.getFlowBuilder(), starter);
    }

    private Timestamp dateStringToStamp(String dateStr, SimpleDateFormat format) {
        try {
            Date date = format.parse(dateStr);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            throw DataTypeError.INVALID_DATE_STRING.create((Throwable)e, new String[]{dateStr});
        }
    }

    public static void validateData(Map<String, Object> item) {
        String cron;
        StringBuilder sb = new StringBuilder();
        if (item.get("start_time") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"TimerStarterParser_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (item.get("end_time") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"TimerStarterParser_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if ((cron = (String)item.get("cron_expr")) == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u89e6\u53d1\u95f4\u9694\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"TimerStarterParser_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else {
            try {
                new CronExpression(cron);
                TimerStarterParser.getParser().parse(cron);
            }
            catch (Exception e) {
                sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212(cron\u8868\u8fbe\u5f0f:%1$s)\u4e0d\u5408\u6cd5,\u8bf7\u68c0\u67e5\u662f\u5426\u7f16\u5199\u6b63\u786e\u3002", (String)"TimerStarterParser_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cron)).append(e.getMessage());
            }
        }
        if (sb.length() > 0) {
            String re = String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s]\u4e2d\u7684%2$s", (String)"TimerStarterParser_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), item.get("title"), sb);
            throw new KDBizException(re);
        }
    }

    private static CronParser getParser() {
        return new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    }

    private static String getNumber(String flowId) {
        return "iscb-sf-" + flowId;
    }

    private static DynamicObject createSchedule(String flowId, DynamicObject job, Timestamp start, Timestamp end, String cron, String name, String interval) {
        String id = String.valueOf(Hash.md5i64((byte[])flowId.getBytes(StandardCharsets.UTF_8)));
        DynamicObject obj = DataCopyTaskUtil.getExistedObject(ENTITY_SCH_SCHEDULE, id);
        obj.set(FIELD_NUMBER, (Object)TimerStarterParser.getNumber(flowId));
        obj.set("job", job.getPkValue());
        obj.set("starttime", (Object)start);
        obj.set("endtime", (Object)end);
        obj.set("plan", (Object)cron);
        obj.set("txtdesc", (Object)ResManager.loadKDString((String)"\u6b64\u8c03\u5ea6\u8ba1\u5212\u7531\u96c6\u6210\u4e91\u670d\u52a1\u7f16\u6392\u7a0b\u5e8f\u81ea\u52a8\u751f\u6210", (String)"TimerStarterParser_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        obj.set("status", (Object)"1");
        if (!"0".equals(interval)) {
            DataCopyTaskUtil.setScheduleDetail(obj, interval);
        }
        obj.set("combdorw", (Object)"d");
        obj.set("name", (Object)name);
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return obj;
    }

    private static DynamicObject createSfJob(String flowId, String releaseId, String name, String jobUser) {
        String id = String.valueOf(Hash.md5i64((byte[])flowId.getBytes(StandardCharsets.UTF_8)));
        DynamicObject obj = DataCopyTaskUtil.getExistedObject(ENTITY_SCH_JOB, id);
        obj.set(FIELD_NUMBER, (Object)TimerStarterParser.getNumber(flowId));
        obj.set("jobtype", (Object)"BIZ");
        obj.set("taskclassname", (Object)TimerStarterParser.createServiceFlowTaskDefine("ISC_SF_TIMER_TASK"));
        obj.set("classname", (Object)SFTimerStarterTask.class.getName());
        TimerJobUtil.setRunJobUser(jobUser, obj);
        obj.set("status", (Object)1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PROP_FLOW_ID, releaseId);
        obj.set("params", (Object)JSON.toJSONString(params));
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObject param = new DynamicObject(entries.getDynamicObjectType());
        param.set("paramname", (Object)PROP_FLOW_ID);
        param.set("paramvalue", (Object)releaseId);
        entries.add((Object)param);
        obj.set("name", (Object)name);
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return obj;
    }

    private static void disableJobSchedule(String number) {
        DynamicObject job;
        QFilter[] qfs = QFilterUtil.builder().put(FIELD_NUMBER, "=", number).build();
        DynamicObject schedule = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_SCHEDULE, (String)"id", (QFilter[])qfs);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        if (schedule != null) {
            scheduleManager.disableSchedule((String)schedule.getPkValue());
            schedule.set("name", (Object)ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u7531\u96c6\u6210\u4e91\u540e\u53f0\u521b\u5efa\uff0c\u6b64\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u4e25\u7981\u542f\u7528\uff0c\u8bf7\u4eba\u5de5\u5220\u9664\u3002", (String)"TimerStarterParser_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            ExecutionData.execute(schedule, "save", CommonUtil.getSkipPermissionOption());
        }
        if ((job = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_JOB, (String)"id", (QFilter[])qfs)) != null) {
            scheduleManager.disableJob((String)job.getPkValue());
        }
    }

    private static String createServiceFlowTaskDefine(String number) {
        QFilter filter = new QFilter(FIELD_NUMBER, "=", (Object)number);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_TASKDEFINE, (String)"id", (QFilter[])new QFilter[]{filter});
        if (task != null) {
            return (String)task.getPkValue();
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_SCH_TASKDEFINE);
        obj.set("id", (Object)Hash.mur2base64((Object[])new Object[]{UUID.randomUUID()}));
        obj.set(FIELD_NUMBER, (Object)number);
        obj.set("name", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u670d\u52a1\u7f16\u6392\u5b9a\u65f6\u542f\u52a8\u4efb\u52a1", (String)"TimerStarterParser_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        obj.set("classname", (Object)SFTimerStarterTask.class.getName());
        obj.set("appid", (Object)"iscb");
        DynamicObjectCollection params = obj.getDynamicObjectCollection("paramentry");
        DynamicObject param = new DynamicObject(params.getDynamicObjectType());
        param.set("paramname", (Object)PROP_FLOW_ID);
        param.set("paramtype", (Object)"1");
        params.add((Object)param);
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return (String)obj.getPkValue();
    }

    private static class TimerFlowStarter
    implements FlowStarter {
        private String flowId;
        private String releaseId;
        private String cron;
        private Timestamp startTime;
        private Timestamp endTime;
        private String title;
        private String interval;
        private String jobUser;

        private TimerFlowStarter(String flowId, String releaseId, String title, String cron, Timestamp startTime, Timestamp endTime, String interval) {
            this.flowId = flowId;
            this.releaseId = releaseId;
            this.title = title;
            this.cron = cron;
            this.startTime = startTime;
            this.endTime = endTime;
            this.interval = interval;
        }

        private TimerFlowStarter(String flowId, String releaseId, String title, String cron, Timestamp startTime, Timestamp endTime, String interval, String jobUser) {
            this(flowId, releaseId, title, cron, startTime, endTime, interval);
            this.jobUser = jobUser;
        }

        @Override
        public FlowStarter.Type getType() {
            return FlowStarter.Type.TIMER;
        }

        @Override
        public void enable() {
            this.disable();
            if (CronJobUtil.isIscScheduleEnable()) {
                this.createIscJob();
            } else {
                DynamicObject job = TimerStarterParser.createSfJob(this.flowId, this.releaseId, this.title, this.jobUser);
                DynamicObject schedule = TimerStarterParser.createSchedule(this.flowId, job, this.startTime, this.endTime, this.cron, this.title, this.interval);
                ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                scheduleManager.enableJob((String)job.getPkValue());
                scheduleManager.enableSchedule((String)schedule.getPkValue());
            }
        }

        private void createIscJob() {
            long creator = D.l((Object)TimerJobUtil.getUserIdByNumber(this.jobUser));
            if (creator > 0L) {
                CronJobUtil.enable("isc_service_flow", this.cron, this.startTime, this.endTime, D.l((Object)this.flowId), this.title, creator);
            } else {
                CronJobUtil.enable("isc_service_flow", this.cron, this.startTime, this.endTime, D.l((Object)this.flowId), this.title, D.l((Object)RequestContext.get().getUserId()));
            }
        }

        @Override
        public void disable() {
            TimerStarterParser.disableJobSchedule(TimerStarterParser.getNumber(this.flowId));
            CronJobUtil.disable(D.l((Object)this.flowId));
        }
    }
}

