/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.res.dc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.DataCopyRunner;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.platform.core.sf.res.dc.ConvertFunction;
import kd.isc.iscb.platform.core.sf.res.dc.PullFunction;
import kd.isc.iscb.platform.core.sf.res.dc.PushFunction;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.NativeFunction;

public class DataCopySchemaResource
extends Resource {
    private static final String PULL = "pull";
    private static final String CONVERT = "convert";
    private static final String PUSH = "push";
    private static final ThreadLocal<Map<String, Object>> lastSrc = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> lastTar = new ThreadLocal();

    public DataCopySchemaResource(ResourceCategory category, long id, String name, String title) {
        super(category, id, name, title);
    }

    public Object eval(ScriptContext ctx) {
        return new DataCopyFunction();
    }

    public static Pair<List<Object>, List<Object>> doDataCopy(DataCopyParam param) {
        DataCopySchemaResource.resetThreadLocal();
        ArrayList<Object> srcIds = new ArrayList<Object>();
        ArrayList<Object> tarIds = new ArrayList<Object>();
        DataCopyRunner runner = new DataCopyRunner(param, DataCopySchemaResource.createCollector(param, srcIds, tarIds));
        runner.run();
        return new Pair(srcIds, tarIds);
    }

    private static DataCopyRunner.Collector createCollector(final DataCopyParam param, final List<Object> srcIds, final List<Object> tarIds) {
        return new DataCopyRunner.Collector(){

            @Override
            public void collect(Map<String, Object> src, Map<String, Object> tar, SaveDataType action, Throwable err) {
                if (err == null) {
                    lastSrc.set(src);
                    lastTar.set(tar);
                    srcIds.add(src.get(param.getSourcePrimaryKey()));
                    tarIds.add(tar.get(param.getTargetPrimaryKey()));
                }
            }
        };
    }

    private Map<String, Object> prepareFilteParams(Object[] args, DynamicObject obj) {
        DynamicObjectCollection c = obj.getDynamicObjectCollection("param_entries");
        this.checkArgs(args, obj, c);
        HashMap<String, Object> params = new HashMap<String, Object>(c.size());
        int index = -1;
        for (DynamicObject item : c) {
            String name = D.s((Object)item.get("params_name"));
            Object value = args[++index];
            params.put(name, value);
        }
        return params;
    }

    private void checkArgs(Object[] args, DynamicObject obj, DynamicObjectCollection c) {
        if (args.length == 0) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7528\u4e8e\u8c03\u7528\u96c6\u6210\u65b9\u6848\uff08%s\uff09\u7684\u53c2\u6570\uff01", (String)"DataCopySchemaResource_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), obj.get("number")));
        }
        if (c.size() != args.length) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\uff08%1$s\uff09\u8981\u6c42%2$s\u4e2a\u53c2\u6570\u503c\uff0c\u5b9e\u9645\u63d0\u4f9b\u4e86%3$s\u4e2a\uff01", (String)"DataCopySchemaResource_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), obj.get("number"), c.size(), args.length));
        }
    }

    public static void resetThreadLocal() {
        lastSrc.remove();
        lastTar.remove();
    }

    public static Map<String, Object> getLastSrc() {
        return lastSrc.get();
    }

    public static Map<String, Object> getLastTar() {
        return lastTar.get();
    }

    class DataCopyFunction
    implements NativeFunction,
    Context {
        DataCopyFunction() {
        }

        public Object call(ScriptContext ctx, Object[] args) {
            DynamicObject obj = DataCopySchema.get(DataCopySchemaResource.this.getId());
            Map filter_params = DataCopySchemaResource.this.prepareFilteParams(args, obj);
            DataCopyParam param = new DataCopyParam(obj, filter_params);
            return DataCopySchemaResource.doDataCopy(param);
        }

        public String name() {
            return DataCopySchemaResource.this.name();
        }

        public Object get(String property) {
            if (DataCopySchemaResource.PULL.equals(property)) {
                return new PullFunction(DataCopySchemaResource.this.getId());
            }
            if (DataCopySchemaResource.CONVERT.equals(property)) {
                return new ConvertFunction(DataCopySchemaResource.this.getId());
            }
            if (DataCopySchemaResource.PUSH.equals(property)) {
                return new PushFunction(DataCopySchemaResource.this.getId());
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u8d44\u6e90\uff1a%1$s\u4e0d\u5b58\u5728\u5c5e\u6027\"%2$s\"", (String)"DataCopySchemaResource_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name(), property));
        }

        public boolean set(String property, Object value) {
            return false;
        }

        public boolean contains(String property) {
            if (DataCopySchemaResource.PULL.equals(property)) {
                return true;
            }
            if (DataCopySchemaResource.CONVERT.equals(property)) {
                return true;
            }
            return DataCopySchemaResource.PUSH.equals(property);
        }
    }
}

