/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.dc.DataCopyThread;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.EventStarterParser;
import kd.isc.iscb.platform.core.sf.parser.n.MessageStarterParser;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.sf.runtime.ProcessProgress;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.except.UneatableException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.trace.TraceTask;

public abstract class AbstractProcessJob
implements Job {
    private long procInstId;
    private String title;
    private ProcessState state;
    private boolean isLight;
    private long jobMutex;
    private transient FlowRuntime runtime;

    protected AbstractProcessJob(long procInstId, String title, ProcessState state, boolean isLight, long jobMutex) {
        this.procInstId = procInstId;
        this.title = title;
        this.state = state;
        this.isLight = isLight;
        this.jobMutex = jobMutex;
    }

    protected AbstractProcessJob(String title, Map<String, Object> params) {
        this.title = title;
        this.procInstId = D.l((Object)params.get("id"));
        this.state = ProcessState.valueOf(D.s((Object)params.get("state")));
        this.isLight = D.x((Object)params.get("light"));
        this.jobMutex = D.l((Object)params.get("job_mutex"));
    }

    @Override
    public final boolean isLightTask() {
        return this.isLight;
    }

    @Override
    public final long getOwnerId() {
        return this.procInstId;
    }

    @Override
    public String getParam() {
        Map<String, Object> params = this.getParamMap();
        params.put("id", this.procInstId);
        params.put("state", (Object)this.state);
        params.put("light", this.isLight);
        params.put("job_mutex", this.jobMutex);
        return Json.toString(params, (boolean)true);
    }

    @Override
    public long getMutex() {
        return this.jobMutex;
    }

    protected Map<String, Object> getParamMap() {
        return new HashMap<String, Object>(8);
    }

    public final long getProcInstId() {
        return this.procInstId;
    }

    public final ProcessState getState() {
        return this.state;
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public final void run() {
        DataSourceResource.createConnectionPool();
        try {
            this.runServiceFlow();
        }
        catch (Throwable e) {
            this.handleError(e);
        }
        finally {
            DataSourceResource.disposeConnectionPool();
            this.handleOmittedErrorLogs();
        }
    }

    private void handleOmittedErrorLogs() {
        if (this.runtime == null) {
            return;
        }
        int omitted = ProcessRuntime.getCurrentLogTotalCount(this.runtime) - D.i((Object)this.runtime.getFlow().getAttribute("log_record_count"));
        if (omitted > 0) {
            ProcessRuntime.saveInfoLog(this.procInstId, String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u65e5\u5fd7\u6700\u5927\u6570\u91cf\u9650\u5236\uff0c\u6709%s\u6761\u65e5\u5fd7\u88ab\u4e22\u5f03\u3002", (String)"AbstractProcessJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), omitted));
        }
    }

    private void handleError(Throwable e) throws UneatableException {
        ProcessRuntime.saveState(this.procInstId, this.runtime, e);
        if (e instanceof UneatableException) {
            throw (UneatableException)e;
        }
        IscRuntimeInfo.get().incServiceFlowFailedCount();
    }

    private void runServiceFlow() {
        this.runtime = ProcessRuntime.loadRuntime(this.procInstId);
        String state = D.s((Object)this.runtime.getTransientProperty("PROCESS_STATE"));
        if (!this.state.name().equals(state)) {
            return;
        }
        if (this.runtime.isClosed() || this.runtime.isTerminated()) {
            return;
        }
        String key = this.getPushedDataLock();
        if (key != null) {
            this.doJobWithDataLock(key);
        } else {
            this.doJob();
        }
    }

    private void doJobWithDataLock(String key) {
        try (DLock lock = DLock.create((String)key).fastMode();){
            if (lock.tryLock()) {
                this.doJob();
            } else {
                JobEngine.submit(this, DataCopyThread.nextScheduleTime());
            }
        }
    }

    private String getPushedDataLock() {
        FlowStarter starter = ServiceFlowParser.getStarter(this.runtime.getFlow());
        if (starter instanceof EventStarterParser.EventStarter) {
            String varName = ((EventStarterParser.EventStarter)starter).getVarName();
            return DataCopyParam.getPushedDataLock(this.runtime.get(varName));
        }
        if (starter instanceof MessageStarterParser.MessageStarter) {
            String varName = ((MessageStarterParser.MessageStarter)starter).getAssignValName();
            return DataCopyParam.getPushedDataLock(this.runtime.get(varName));
        }
        return null;
    }

    private void doJob() {
        if (ProcessRuntime.setRunning(this.procInstId, this.state)) {
            this.runtime.setLoggerLevel(ServiceFlowParser.getLogLevel(this.runtime.getFlow()));
            ScheduleManager.submit((Task)new ProcessProgress(this.runtime), 13);
            long flowId = ServiceFlowParser.getServiceFlowId(this.runtime.getFlow());
            ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense("isc_service_flow", flowId));
            try {
                this.executeServiceFlowJob(this.runtime);
            }
            finally {
                ConnectionManager.popResLicense();
            }
            ProcessRuntime.saveState(this.procInstId, this.runtime);
        } else {
            JobEngine.submit(this, new Timestamp(System.currentTimeMillis() + 180000L));
        }
    }

    private void executeServiceFlowJob(final FlowRuntime runtime) {
        if (!ConnectionManager.hasResLicense() && !this.isDataSourceFree(runtime)) {
            IscLicenseUtil.check_PRO_ISCB_License();
        }
        DynamicObject proc = ProcessRuntime.getProcessObj(runtime);
        TraceStack.run(this.getTraceType(), proc, new TraceTask(){

            public void run() {
                ServiceFlowEngine.checkDisableTrace(runtime);
                SignalManager.registerTask(runtime.getId());
                try {
                    AbstractProcessJob.this.doJob(runtime);
                }
                catch (TaskCancelException e) {
                    runtime.terminate();
                    throw e;
                }
                finally {
                    SignalManager.unregisterTask(runtime.getId());
                }
            }
        });
    }

    private boolean isDataSourceFree(FlowRuntime runtime) {
        Flow flow = runtime.getFlow();
        for (Resource res : ServiceFlowParser.getResources(flow).values()) {
            boolean isFree;
            if (!(res instanceof DataSourceResource) || (isFree = ((DataSourceResource)res).eval(null).isFree())) continue;
            return false;
        }
        return true;
    }

    protected abstract TraceType getTraceType();

    protected abstract void doJob(FlowRuntime var1);
}

