/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.FlowRuntime;

public abstract class AbstractProcessJobFactory
implements JobFactory {
    @Override
    public final void cancel(long procInstId) {
        AbstractProcessJobFactory.terminate(procInstId);
    }

    public static boolean terminate(long procInstId) {
        if (AbstractProcessJobFactory.setTerminated(procInstId)) {
            AbstractProcessJobFactory.innerTerminate(procInstId);
            return true;
        }
        return false;
    }

    private static void innerTerminate(long procInstId) {
        try {
            FlowRuntime runtime = ProcessRuntime.loadRuntime(procInstId);
            if (!runtime.isClosed()) {
                runtime.terminate();
                ProcessRuntime.saveState(procInstId, runtime);
            }
        }
        catch (Throwable e) {
            ProcessRuntime.saveState(procInstId, null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setTerminated(long procInstId) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "UPDATE t_isc_sf_proc_inst SET fstate='Terminated', fmodified_time=?  WHERE fid=? AND fstate IN('Created','Waiting','Failed','Interrupted','Ignored')";
            Timestamp now = new Timestamp(System.currentTimeMillis());
            int affected = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{now, procInstId}), (List)D.asList((Object[])new Integer[]{93, -5}));
            boolean bl = affected > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

