/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.EventWaitingJobFactory;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessSignalJob;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;

public class EventWaitingJob
implements Job {
    private static final Log LOG = LogFactory.getLog(EventWaitingJob.class);
    public static final JobFactory FACTORY = new EventWaitingJobFactory();
    private int hash_code;
    private String title;

    public EventWaitingJob(int hash_code, String title) {
        this.hash_code = hash_code;
        this.title = title;
    }

    @Override
    public String getParam() {
        return String.valueOf(this.hash_code);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        try (DLock lock = DLock.create((String)("/isc/sf/event/" + this.hash_code)).fastMode();){
            if (lock.tryLock(30000L)) {
                HashMap<Triple<Long, String, String>, DataRow> dataMap = new HashMap<Triple<Long, String, String>, DataRow>(4);
                ArrayList<DataRow> signalList = new ArrayList<DataRow>(4);
                this.loadData(dataMap, signalList);
                this.createSignalJobs(dataMap, signalList);
            } else {
                LOG.warn("\u7b49\u5f85\u5206\u5e03\u5f0f\u9501\u8d85\u65f6:" + this.hash_code);
                Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + 60000L);
                JobEngine.submit(new EventWaitingJob(this.hash_code, "RETRY:" + this.hash_code), scheduledTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData(Map<Triple<Long, String, String>, DataRow> dataMap, List<DataRow> signalList) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            this.loadEventData(cn, dataMap);
            this.loadSignalList(cn, signalList);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void createSignalJobs(Map<Triple<Long, String, String>, DataRow> dataMap, List<DataRow> signalList) {
        for (DataRow signalRow : signalList) {
            String identifier;
            String nodeId;
            Long flowId = D.l((Object)signalRow.get((Object)"fservice_flow_id"));
            DataRow dataRow = dataMap.get(new Triple((Object)flowId, (Object)(nodeId = D.s((Object)signalRow.get((Object)"fnode_id"))), (Object)(identifier = D.s((Object)signalRow.get((Object)"fsignal_identifier")))));
            if (dataRow == null) continue;
            this.createSignalJob(signalRow, dataRow);
        }
    }

    private void createSignalJob(DataRow signalRow, DataRow dataRow) {
        try {
            long procInstId = D.l((Object)signalRow.get((Object)"fservice_process_id"));
            FlowRuntime runtime = ProcessRuntime.loadRuntime(procInstId);
            if (runtime.isClosed()) {
                this.setIgnored(signalRow, dataRow, runtime.getState());
            } else {
                this.createSignalJob(procInstId, signalRow, dataRow, runtime.getFlow());
                this.setSuccess(signalRow, dataRow);
            }
        }
        catch (Throwable err) {
            this.setFailed(signalRow, dataRow, err);
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFailed(DataRow signalRow, DataRow dataRow, Throwable err) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = "UPDATE t_isc_sf_waiting_signal SET fstate='F', fstack_trace='error', fstack_trace_tag=?, fmodified_time=? WHERE fid=?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(StringUtil.toString((Throwable)err), now, D.l((Object)signalRow.get((Object)"fid"))), Arrays.asList(12, 93, -5));
            sql = "UPDATE t_isc_sf_waiting_data SET fstate='F', fdata=?, fmodified_time=? WHERE fid=?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\u53c2\u8003\u76f8\u540c\u54c8\u5e0c\u7801\u7684\u670d\u52a1\u6d41\u7a0b\u7b49\u5f85\u4fe1\u53f7", (String)"EventWaitingJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), now, D.l((Object)dataRow.get((Object)"fid"))), Arrays.asList(12, 93, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void createSignalJob(long procInstId, DataRow signalRow, DataRow dataRow, Flow flow) {
        String activityId = D.s((Object)signalRow.get((Object)"factivity_id"));
        String number = D.s((Object)signalRow.get((Object)"fservice_process_number"));
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("signal_identifier", D.s((Object)signalRow.get((Object)"fsignal_identifier")));
        params.put("data", Json.toObject((String)D.s((Object)dataRow.get((Object)"fdata_tag"))));
        ProcessSignalJob job = new ProcessSignalJob(procInstId, String.format(ResManager.loadKDString((String)"\u5524\u9192\u6d41\u7a0b\uff1a%s", (String)"EventWaitingJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number), activityId, params, ServiceFlowParser.getMutex(flow));
        JobEngine.submit(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSuccess(DataRow signalRow, DataRow dataRow) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String sql = "DELETE FROM t_isc_sf_waiting_signal WHERE fid=?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(D.l((Object)signalRow.get((Object)"fid"))), Collections.singletonList(-5));
            sql = "DELETE FROM t_isc_sf_waiting_data WHERE fid=?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(D.l((Object)dataRow.get((Object)"fid"))), Collections.singletonList(-5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIgnored(DataRow signalRow, DataRow dataRow, FlowRuntime.State state) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String message = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u72b6\u6001\uff1a%s", (String)"EventWaitingJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), state);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = "UPDATE t_isc_sf_waiting_signal SET fstate='N', fstack_trace=?, fmodified_time=? WHERE fid=?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(message, now, D.l((Object)signalRow.get((Object)"fid"))), Arrays.asList(12, 93, -5));
            sql = "UPDATE t_isc_sf_waiting_data SET fstate='N', fdata=?, fmodified_time=? WHERE fid=?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(message, now, D.l((Object)dataRow.get((Object)"fid"))), Arrays.asList(12, 93, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void loadSignalList(Connection cn, List<DataRow> signalList) {
        String sql = "SELECT fid,fservice_flow_id,fservice_process_id,fnode_id,factivity_id,fsignal_identifier,fservice_process_number  FROM t_isc_sf_waiting_signal WHERE fstate in('W','F') AND fhash_code=?";
        List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(this.hash_code), Collections.singletonList(4));
        signalList.addAll(list);
    }

    private void loadEventData(Connection cn, Map<Triple<Long, String, String>, DataRow> dataMap) {
        String sql = "SELECT fid,fservice_flow_id,fnode_id,fsignal_identifier,fdata_tag  FROM t_isc_sf_waiting_data WHERE fstate in('W','F') AND fhash_code=? ORDER BY fcreated_time";
        for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(this.hash_code), Collections.singletonList(4))) {
            Long flowId = D.l((Object)row.get((Object)"fservice_flow_id"));
            String nodeId = D.s((Object)row.get((Object)"fnode_id"));
            String identifier = D.s((Object)row.get((Object)"fsignal_identifier"));
            dataMap.put((Triple<Long, String, String>)new Triple((Object)flowId, (Object)nodeId, (Object)identifier), row);
        }
    }
}

