/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime;

import java.sql.Timestamp;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.ProcessExecuteJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.sf.runtime.n.TimerWaitingApplication;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.RuntimeImpl;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.Context;

public class SetRetryOnFailed
extends Command
implements Const {
    private static final String RETRY_COUNT = "RETRY_COUNT";

    public SetRetryOnFailed() {
        super(26000001);
    }

    public int invoke(ExecutionImpl e) {
        if (e.isAppStarted()) {
            return 1;
        }
        if (ServiceFlowEngine.withoutProcInst((FlowRuntime)e.getRuntime())) {
            return 1;
        }
        Script premise = (Script)e.getDefine().getAttribute("wait_for_premise");
        if (premise != null ? !D.x((Object)premise.eval((Context)e)) : D.isFatal((Throwable)e.getRuntime().getError())) {
            return 1;
        }
        Script schedule = (Script)e.getDefine().getAttribute("wait_for_on_failed");
        int index = D.i((Object)e.getProperty(RETRY_COUNT));
        e.setProperty(RETRY_COUNT, (Object)(index + 1));
        long t = TimerWaitingApplication.calcScheduleTime(schedule, (Execution)e, index, true);
        if (t < System.currentTimeMillis() || index > 15) {
            return 1;
        }
        return this.submitRetryJob(e, t);
    }

    private int submitRetryJob(ExecutionImpl e, long scheduleTime) {
        RuntimeImpl runtime = e.getRuntime();
        long procInstId = Long.parseLong(runtime.getId());
        String number = ProcessRuntime.getNumber((FlowRuntime)runtime);
        String title = "[R] " + number + " / " + e.getDefine().getTitle();
        boolean isLight = ServiceFlowEngine.isLight((Execution)e);
        ProcessExecuteJob job = new ProcessExecuteJob(procInstId, title, ProcessState.Failed, isLight, ServiceFlowParser.getMutex(runtime.getFlow()));
        JobEngine.submit(job, new Timestamp(scheduleTime));
        return 27000000;
    }
}

