/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.l;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.util.SfMessageUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Event;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.plugin.Listener;

public class ServiceFlowNotificationListener
implements Listener {
    private List<SfMessageUtil.CompiledMessageInfo> compiledMessageInfos;
    private String expectedState;
    private static final Log logger = LogFactory.getLog(ServiceFlowNotificationListener.class);

    public ServiceFlowNotificationListener(Event event, FlowBuilder flow, List<SfMessageUtil.MessageInfo> msgList) {
        Map<String, Object> ctx = ServiceFlowParser.getScriptContext(flow);
        this.expectedState = SfMessageUtil.MessageProcessState.getStateByEvent(event);
        this.parseMsgObj(ctx, msgList);
    }

    private void parseMsgObj(Map<String, Object> ctx, List<SfMessageUtil.MessageInfo> msgList) {
        this.compiledMessageInfos = new ArrayList<SfMessageUtil.CompiledMessageInfo>(msgList.size());
        for (SfMessageUtil.MessageInfo messageInfo : msgList) {
            this.compiledMessageInfos.add(new SfMessageUtil.CompiledMessageInfo(messageInfo, ctx));
        }
    }

    public void execute(Execution e) {
        FlowRuntime runtime = e.getRuntime();
        if (ServiceFlowEngine.withoutProcInst(runtime)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u65e0\u5b9e\u4f8b\u6a21\u5f0f\u6267\u884c\u670d\u52a1\u6d41\u7a0bapi\u4e0d\u652f\u6301\u914d\u7f6e\u670d\u52a1\u6d41\u7a0b\u901a\u77e5\uff0c\u8bf7\u5230\u83dc\u5355\u3010\u96c6\u6210\u7ba1\u7406-\u670d\u52a1\u6d41\u7a0b-\u670d\u52a1\u6d41\u7a0b\u901a\u77e5\u3011\u4e0b\u7981\u7528\u5173\u8054\u7684\u670d\u52a1\u6d41\u7a0b\u3002", (String)"ServiceFlowNotificationListener_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject proc = ProcessRuntime.getProcessObj(runtime);
        proc.set("state", (Object)this.expectedState);
        for (SfMessageUtil.CompiledMessageInfo compiledMessageInfo : this.compiledMessageInfos) {
            try {
                compiledMessageInfo.buildMessageAndSend(e);
            }
            catch (Throwable err) {
                logger.warn(String.format("\u670d\u52a1\u6d41\u7a0b\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8bId : %s", e.getId()), err);
            }
        }
    }
}

