/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.datacomp.DataCompTask;
import kd.isc.iscb.platform.core.datacomp.DataCompThread;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.res.DataCompResource;
import kd.isc.iscb.platform.core.sf.util.ExprUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompApplication
implements Application {
    private DynamicObject schema;
    private Map<String, Object> map;

    public DataCompApplication(DynamicObject schema, Map<String, Object> map) {
        this.schema = schema;
        this.map = map;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        Map<String, Object> params = this.getInputMap((Map)this.map.get("input"), e);
        DynamicObject dataCompTask = DataCompTask.createExe(this.schema, params, DataCompTask.InitType.SF_SYNC);
        long taskId = dataCompTask.getLong("id");
        DataCompResource.Refresher refresher = new DataCompResource.Refresher();
        new DataCompThread(taskId, refresher).run();
        this.setOutputVar(e, taskId, refresher);
    }

    private void setOutputVar(Execution e, long taskId, DataCompResource.Refresher refresher) {
        if (refresher.getError() != null) {
            throw D.e((Throwable)refresher.getError());
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"isc_data_comp_exe");
        this.setSrcDataVar(e, task);
        this.setStateVar(e, task);
    }

    private void setSrcDataVar(Execution e, DynamicObject task) {
        if (this.map.get("src_data_var") != null) {
            QFilter filter = new QFilter("data_comp_exe", "=", (Object)task.getString("id"));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)"isc_data_comp_exe_det", (String)"source_data,source_data_tag", (QFilter[])new QFilter[]{filter}, (String)"createtime desc", (int)1000);
            ArrayList<Object> srcData = new ArrayList<Object>(collection.length);
            for (DynamicObject object : collection) {
                String source_data_tag = object.getString("source_data_tag");
                String source_data = object.getString("source_data");
                if (StringUtil.isEmpty((String)source_data_tag)) {
                    srcData.add(Json.toObject((String)source_data));
                    continue;
                }
                srcData.add(JSON.parse((String)source_data_tag));
            }
            Pair pair = (Pair)this.map.get("src_data_var");
            this.setVarValue(e, (Pair<ExprSetter, Boolean>)pair, srcData);
        }
    }

    private void setStateVar(Execution e, DynamicObject task) {
        if (this.map.get("state_var") != null) {
            HashMap<String, Object> stateResult = new HashMap<String, Object>(7);
            stateResult.put("state", task.get("state"));
            stateResult.put("id", task.get("id"));
            stateResult.put("number", task.get("number"));
            stateResult.put("total", task.get("source_count"));
            stateResult.put("not_existed", task.get("tar_no_exist_count"));
            stateResult.put("changed", task.get("tar_no_syn_count"));
            stateResult.put("sync", task.get("execute_count"));
            ExprSetter stateSetter = (ExprSetter)this.map.get("state_var");
            stateSetter.set(e, stateResult);
        }
    }

    private void setVarValue(Execution e, Pair<ExprSetter, Boolean> setter, List<Object> list) {
        ExprSetter s = (ExprSetter)setter.getA();
        if (s != null) {
            if (D.x((Object)setter.getB())) {
                s.set(e, list);
            } else if (list.size() == 1) {
                s.set(e, list.get(0));
            } else if (list.isEmpty()) {
                s.set(e, null);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u7684\u8f93\u51fa\u6e90\u5355%s\u4e0d\u662f\u591a\u503c\u7c7b\u578b\uff0c\u65e0\u6cd5\u63a5\u6536ID\u5217\u8868!", (String)"DataCompApplication_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s.getExpr()));
            }
        }
    }

    private Map<String, Object> getInputMap(Map<String, Object> input, Execution e) {
        LinkedHashMap<String, Object> dcInput = new LinkedHashMap<String, Object>(input.size());
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            dcInput.put(entry.getKey(), ExprUtil.evalAssignValue(e, entry.getValue()));
        }
        return dcInput;
    }
}

