/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.res.DataCopyTriggerResource;
import kd.isc.iscb.platform.core.sf.util.ExprUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;

public class DataCopyTriggerApplication
implements Application {
    private DynamicObject trigger;
    private Map<String, Object> params;
    private List<Map<String, Object>> filterList;
    private ExprSetter executionVarSetter;
    private ExprSetter stateVarSetter;

    private DataCopyTriggerApplication(DynamicObject trigger, ExprSetter executionVarSetter, ExprSetter stateVarSetter) {
        this.trigger = trigger;
        this.executionVarSetter = executionVarSetter;
        this.stateVarSetter = stateVarSetter;
    }

    public DataCopyTriggerApplication(DynamicObject trigger, Map<String, Object> paramGetterMap, ExprSetter executionVarSetter, ExprSetter stateVarSetter) {
        this(trigger, executionVarSetter, stateVarSetter);
        this.params = paramGetterMap;
    }

    public DataCopyTriggerApplication(DynamicObject trigger, List<Map<String, Object>> filterList, ExprSetter executionVarSetter, ExprSetter stateVarSetter) {
        this(trigger, executionVarSetter, stateVarSetter);
        this.filterList = filterList;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        DynamicObject execution;
        DynamicObject dynamicObject = execution = CollectionUtils.isEmpty(this.params) ? this.initByFilters(e) : this.initByParams(e);
        if (this.executionVarSetter != null) {
            this.executionVarSetter.set(e, execution.getPkValue());
        }
        String state = null;
        try {
            state = DataCopyTriggerResource.doCopy(execution);
        }
        catch (Exception ex) {
            DynamicObject exe = BusinessDataServiceHelper.loadSingle((Object)execution.getPkValue(), (String)"isc_data_copy_execution", (String)"state");
            state = exe.getString("state");
            throw ex;
        }
        finally {
            if (this.stateVarSetter != null) {
                this.stateVarSetter.set(e, state);
            }
        }
    }

    private DynamicObject initByParams(Execution e) {
        HashMap<String, Object> filterParams = new HashMap<String, Object>(this.params.size());
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            String key = entry.getKey();
            Object value = ExprUtil.evalAssignValue(e, entry.getValue());
            filterParams.put(key, value);
        }
        return DataCopyTask.create(this.trigger, filterParams, DataCopyTask.InitType.SF_SYNC);
    }

    private DynamicObject initByFilters(Execution e) {
        ArrayList<Map<String, Object>> pushFilters = new ArrayList<Map<String, Object>>(this.filterList.size());
        for (Map<String, Object> filter : this.filterList) {
            HashMap<String, Object> temp = new HashMap<String, Object>(filter);
            temp.put("filter_value", ExprUtil.evalAssignValue(e, filter.get("filter_value")));
            pushFilters.add(temp);
        }
        Map<String, Object> data = this.constructPushData(pushFilters);
        return DataCopyTask.create(this.trigger, null, null, null, data, DataCopyTask.InitType.SF_SYNC);
    }

    private Map<String, Object> constructPushData(List<Map<String, Object>> filters) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("$is_filter", Boolean.TRUE);
        data.put("$filter_items", filters);
        return data;
    }

    public String toString() {
        return "DataCopyTriggerApplication\uff1a" + this.trigger.getString("number");
    }
}

