/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.connector.self.triggerhandler.DataFlowHandler;
import kd.isc.iscb.platform.core.sf.runtime.n.ApiFunctionApplication;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;

public class DataFlowInvokeApplication
implements Application {
    private final long dataFlowTriggerId;
    private final Map<String, Object> params;
    private final String stateVar;

    public DataFlowInvokeApplication(long dataFlowTriggerId, Map<String, Object> params, String stateVar) {
        this.dataFlowTriggerId = dataFlowTriggerId;
        this.params = params;
        this.stateVar = stateVar;
    }

    public long getDataFlowTriggerId() {
        return this.dataFlowTriggerId;
    }

    public void invoke(Execution e) {
        long streamId = D.l((Object)e.getProperty("DATA_STREAM_ID"));
        if (streamId != 0L) {
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)streamId, (String)"iscx_data_stream");
            String state = info.getString("state");
            if ("S".equals(state)) {
                e.set(this.stateVar, DataFlowHandler.getDataFlowState(info));
                return;
            }
            if ("X".equals(state)) {
                String message = ResManager.loadKDString((String)"\u6570\u636e\u6d41\uff08%s\uff09\u5df2\u64a4\u9500\u3002", (String)"DataFlowInvokeApplication_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                throw new TaskCancelException(String.format(message, info.get("number")));
            }
            this.executeDataStream(e, info);
        } else {
            this.validateParams(e);
            Map<String, Object> params = ApiFunctionApplication.getInputMap(e, this.params);
            DynamicObject info = DataFlowHandler.createDataStream(this.dataFlowTriggerId, params);
            this.backupDataStreamId(e, info);
            e.setProperty("DATA_STREAM_ID", info.get("id"));
            this.executeDataStream(e, info);
        }
    }

    private void backupDataStreamId(Execution e, DynamicObject info) {
        ProcessElement node = e.getDefine();
        String key = "DATA_STREAM_ID_LIST/" + node.getId() + "/" + node.getFlow().getId();
        ArrayList<String> list = (ArrayList<String>)e.getRuntime().getProperty(key);
        if (list == null) {
            list = new ArrayList<String>();
            e.getRuntime().setProperty(key, list);
        }
        list.add(info.get("id") + "|" + info.get("number"));
    }

    private void executeDataStream(Execution e, DynamicObject info) {
        Map<String, Object> state = DataFlowHandler.executeDataStream(info);
        Throwable last_error = (Throwable)state.get("last_error");
        if (last_error != null) {
            String message = ResManager.loadKDString((String)"\u6570\u636e\u6d41\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5230\u201c\u6570\u636e\u6d41 - \u76d1\u63a7\u7edf\u8ba1 - \u6570\u636e\u6d41\u5b9e\u4f8b\u201d\u4f7f\u7528\u201c%s\u201d\u4f5c\u4e3a\u7f16\u7801\u67e5\u8be2\u4e86\u89e3\u8be6\u60c5\u3002", (String)"DataFlowInvokeApplication_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(message, state.get("number")), last_error);
        }
        if ("F".equals(state.get("state"))) {
            String message = ResManager.loadKDString((String)"\u6570\u636e\u6d41\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5230\u201c\u6570\u636e\u6d41 - \u76d1\u63a7\u7edf\u8ba1 - \u6570\u636e\u6d41\u5b9e\u4f8b\u201d\u4f7f\u7528\u201c%s\u201d\u4f5c\u4e3a\u7f16\u7801\u67e5\u8be2\u4e86\u89e3\u8be6\u60c5\u3002", (String)"DataFlowInvokeApplication_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(message, state.get("number")));
        }
        if ("U".equals(state.get("state"))) {
            String message = ResManager.loadKDString((String)"\u6570\u636e\u6d41\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u5230\u201c\u6570\u636e\u6d41 - \u76d1\u63a7\u7edf\u8ba1 - \u6570\u636e\u6d41\u5b9e\u4f8b\u201d\u4f7f\u7528\u201c%s\u201d\u4f5c\u4e3a\u7f16\u7801\u67e5\u8be2\u4e86\u89e3\u8be6\u60c5\u3002", (String)"DataFlowInvokeApplication_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(message, state.get("number")));
        }
        e.set(this.stateVar, state);
    }

    private void validateParams(Execution e) {
        for (IscApiParam.Field f : DataFlowHandler.getDataFlowParam(this.dataFlowTriggerId)) {
            if (this.params.containsKey(f.getName())) continue;
            String message = ResManager.loadKDString((String)"\u8282\u70b9\uff08%1$s\uff09\u8c03\u7528\u7684\u6570\u636e\u6d41\u53c2\u6570\uff08%2$s\uff09\u672a\u7ed1\u5b9a\u8d4b\u503c\uff0c\u5e94\u8be5\u662f\u6570\u636e\u6d41\u4fee\u6539\u540e\u6ca1\u6709\u76f8\u5e94\u8c03\u6574\u670d\u52a1\u6d41\u7a0b\u6240\u81f4\u3002", (String)"DataFlowInvokeApplication_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IllegalArgumentException(String.format(message, e.getDefine().getTitle(), f.getName()));
        }
    }

    public void compile(VariableScope scope) {
    }
}

