/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyOutput;
import kd.isc.iscb.platform.core.dc.e.v.PropertyEvaluator;
import kd.isc.iscb.platform.core.dc.meta.DefaultDataCopyConsumer;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.util.ExprUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public class DataLoaderApplication
implements Application {
    private final DynamicObject schema;
    private final String tarVar;
    private final List<String> actions;
    private final List<Map<String, Object>> candidateKeys;
    private final Object proxyUser;
    private final Pair<ExprSetter, Boolean> tarOutputIds;
    private final int batchSize;
    private final Pair<ExprSetter, Boolean> tarOutputResults;
    private final Map<String, Object> targetActionParams;
    private final Map<String, Set<String>> targetFields = new ConcurrentHashMap<String, Set<String>>();

    public DataLoaderApplication(DynamicObject schema, String tarVar, List<String> actions, Map<String, Object> targetActionParams, List<Map<String, Object>> candidateKeys, Object proxyUser, Pair<ExprSetter, Boolean> tarOutputIds, int batchSize, Pair<ExprSetter, Boolean> tarOutputResults) {
        this.schema = schema;
        this.tarVar = tarVar;
        this.actions = actions;
        this.targetActionParams = targetActionParams;
        this.candidateKeys = candidateKeys;
        this.proxyUser = proxyUser;
        this.tarOutputIds = tarOutputIds;
        this.batchSize = this.initBatchSize(batchSize);
        this.tarOutputResults = tarOutputResults;
    }

    private int initBatchSize(int batchSize) {
        return Math.max(batchSize, 1);
    }

    public void compile(VariableScope scope) {
    }

    public String toString() {
        return "DataLoaderApplication: " + this.schema.getString("number");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Execution e) {
        DataSource dataSource = DataSource.get(this.schema.getLong("group_id"));
        try (ConnectionWrapper cn = ConnectionManager.getConnection(dataSource.getDbLink());){
            if (!cn.isFree()) {
                IscLicenseUtil.check_PRO_ISCB_License();
            }
            this.doAction(e, cn);
        }
    }

    private void doAction(Execution e, ConnectionWrapper cn) {
        Map<String, List<String>> judgeFields = this.prepareJudgeFields();
        Object tarVar = e.get(this.tarVar);
        if (tarVar != null) {
            List tarList = CollectionUtils.toList(tarVar);
            IscRuntimeInfo iscRuntimeInfo = IscRuntimeInfo.get();
            ArrayList<Object> results = new ArrayList<Object>(tarList.size());
            DataCopyOutput output = this.initDataLoadOutput(e, cn, judgeFields, tarList);
            boolean isBatch = this.supportsBizBatchAction(cn, this.batchSize);
            HashMap<String, Object> data = new HashMap();
            try {
                for (Map tar : tarList) {
                    SignalManager.checkCancelSignal();
                    data = tar;
                    output.write(data);
                }
                output.commit();
                this.getOutput(tarList, results, isBatch);
                this.setOutput(e, results, isBatch);
            }
            catch (Throwable err) {
                output.rollback(err);
                iscRuntimeInfo.incDataCopyWriteFailedCount();
                if (err instanceof IscBizException) {
                    ((IscBizException)err).setData(isBatch ? this.getFailedList(tarList) : Json.toString(data));
                    throw err;
                }
                IscBizException err2 = new IscBizException(err.getMessage(), err);
                err2.setData(isBatch ? this.getFailedList(tarList) : Json.toString(data));
                throw err2;
            }
            finally {
                output.dispose();
                iscRuntimeInfo.incDataCopyWriteTotalCount();
            }
        }
    }

    private String getFailedList(List<Map<String, Object>> tarList) {
        ArrayList<Map<String, Object>> failedList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> tar : tarList) {
            if (!SaveDataType.FAILED.equals(tar.get("$action"))) continue;
            failedList.add(tar);
        }
        return Json.toString(failedList);
    }

    private DataCopyOutput initDataLoadOutput(final Execution e, ConnectionWrapper cn, Map<String, List<String>> judgeFields, List<Map<String, Object>> tarList) {
        this.initTargetFields(tarList);
        Map<String, Object> target_operation_params = this.initTargetOperationParams(e);
        DefaultDataCopyConsumer consumer = new DefaultDataCopyConsumer(this.schema, cn, judgeFields, this.actions, target_operation_params, null, this.targetFields, this.batchSize, DefaultDataCopyConsumer.Mode.BreakOnError, null, null, null, null, new Counter()){

            @Override
            public void saveTargetErrorLog(Throwable error, Map<String, Object> tar) {
            }

            @Override
            public String getProxyUser(Map<String, Object> data) {
                return DataLoaderApplication.this.getRealProxyUser(e, data);
            }
        };
        return new DataCopyOutput(consumer);
    }

    private Map<String, Object> initTargetOperationParams(Execution e) {
        HashMap<String, Object> target_operation_params = new HashMap<String, Object>(this.targetActionParams.size());
        for (Map.Entry<String, Object> entry : this.targetActionParams.entrySet()) {
            target_operation_params.put(entry.getKey(), ExprUtil.evalAssignValue(e, entry.getValue()));
        }
        return target_operation_params;
    }

    private boolean supportsBizBatchAction(ConnectionWrapper cn, int batchSize) {
        if (batchSize <= 1) {
            return false;
        }
        return cn.getFactory().supportsBizBatchAction(cn);
    }

    private void initTargetFields(List<Map<String, Object>> tarList) {
        if (tarList.size() > 0) {
            Map<String, Object> tar = tarList.get(0);
            LinkedHashSet<String> tarFields = new LinkedHashSet<String>(tar.keySet());
            this.targetFields.put("", tarFields);
        }
    }

    private void getOutput(List<Map<String, Object>> tarList, List<Object> results, boolean isBatch) {
        for (Map<String, Object> tar : tarList) {
            Object act = tar.get("$action");
            if (act == null) continue;
            if (isBatch) {
                HashMap<String, Object> result = new HashMap<String, Object>(2);
                result.put(this.getPrimaryKey(this.schema), tar.get(this.getPrimaryKey(this.schema)));
                result.put("$action", act);
                results.add(result);
                continue;
            }
            results.add(tar.get(this.getPrimaryKey(this.schema)));
        }
    }

    private String getRealProxyUser(Execution e, Map<String, Object> tarData) {
        if (this.proxyUser == null) {
            return null;
        }
        if (this.proxyUser instanceof String) {
            String s = (String)this.proxyUser;
            if (s.startsWith("#{") && s.endsWith("}") && this.batchSize > 0) {
                return this.getUserByExpr(tarData, s);
            }
            return s;
        }
        if (this.proxyUser instanceof ExprGetter) {
            return this.getUserByFlowVar(e);
        }
        return D.s((Object)this.proxyUser);
    }

    private String getUserByExpr(Map<String, Object> tarData, String s) {
        PropertyEvaluator propertyEvaluator = new PropertyEvaluator(s.substring(2, s.length() - 1));
        Object proxy_user = propertyEvaluator.eval(null, tarData, null);
        if (proxy_user instanceof Object[]) {
            return D.s((Object)((Object[])proxy_user)[0]);
        }
        return D.s((Object)proxy_user);
    }

    private String getUserByFlowVar(Execution e) {
        Object o = ((ExprGetter)this.proxyUser).get(e);
        if (o instanceof List || o instanceof Map) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4ee3\u7406\u7528\u6237\u53d8\u91cf\u8d4b\u503c\u4e0d\u652f\u6301\u591a\u503c\u6216\u57fa\u7840\u8d44\u6599\uff1a%s", (String)"DataLoaderApplication_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), o));
        }
        return D.s((Object)o);
    }

    private Map<String, List<String>> prepareJudgeFields() {
        HashMap<String, List<String>> judgeFields = new HashMap<String, List<String>>();
        for (Map<String, Object> candidateKey : this.candidateKeys) {
            String judgeField = D.s((Object)candidateKey.get("candidate_key"));
            int index = judgeField.lastIndexOf(46);
            if (index < 0) {
                DataLoaderApplication.innerGetJudgeFields(judgeFields, "$", judgeField);
                continue;
            }
            String entryKey = judgeField.substring(0, index);
            DataLoaderApplication.innerGetJudgeFields(judgeFields, entryKey, judgeField.substring(index + 1));
        }
        return judgeFields;
    }

    private static void innerGetJudgeFields(Map<String, List<String>> judgeFields, String key, String field) {
        List<String> fields = judgeFields.get(key);
        if (fields == null) {
            fields = new ArrayList<String>();
            fields.add(field);
            judgeFields.put(key, fields);
        } else {
            fields.add(field);
        }
    }

    private void setOutput(Execution e, List<Object> resultIds, boolean isBatch) {
        if (isBatch) {
            ExprSetter outputResults = (ExprSetter)this.tarOutputResults.getA();
            if (outputResults != null) {
                outputResults.set(e, resultIds);
            }
            return;
        }
        ExprSetter outputIds = (ExprSetter)this.tarOutputIds.getA();
        if (outputIds != null) {
            if (((Boolean)this.tarOutputIds.getB()).booleanValue()) {
                outputIds.set(e, resultIds);
            } else if (resultIds.size() == 1) {
                outputIds.set(e, resultIds.get(0));
            } else if (resultIds.size() == 0) {
                outputIds.set(e, null);
            } else {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u7ed3\u679c\u96c6\u53d8\u91cf\u4e0d\u662f\u6570\u7ec4\uff0c\u65e0\u6cd5\u63a5\u6536ID\u5217\u8868!", (String)"DataLoaderApplication_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
        }
    }

    private String getPrimaryKey(DynamicObject meta) {
        String pk = null;
        for (DynamicObject item : meta.getDynamicObjectCollection("prop_entryentity")) {
            if (!item.getBoolean("is_primary_key")) continue;
            String field = D.s((Object)item.get("prop_name"));
            if (pk == null || field.equals(pk)) {
                pk = field;
                continue;
            }
            return null;
        }
        return pk;
    }
}

