/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.cache.data.PublishTopicSchema;
import kd.isc.iscb.platform.core.dc.e.DataCopyOutput;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.runtime.n.MessagePublisherParam;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.Json;

public class MessagePublisherApplication
implements Application {
    private Resource res;
    private final String metadataVarName;
    private final int batchSize;
    private final List<Map<String, Object>> fields;
    private final DynamicObject metaschema;

    public MessagePublisherApplication(Resource res, String var, DynamicObject metaschema, int batchSize, List<Map<String, Object>> fields) {
        this.res = res;
        this.metadataVarName = var;
        this.metaschema = metaschema;
        this.fields = fields;
        this.batchSize = Math.max(batchSize, 0);
    }

    private DataCopyOutput initOutput() {
        PublishTopicSchema pubTopic = PublishTopicSchema.get(this.res.getId());
        DynamicObject publisher = pubTopic.getConfig();
        MessagePublisherParam param = new MessagePublisherParam(this.metaschema, publisher, this.batchSize);
        return new DataCopyOutput(param);
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        Object data = e.get(this.metadataVarName);
        if (data instanceof Map) {
            this.pushListData(Collections.singletonList((Map)data));
        } else if (data instanceof List) {
            this.pushListData((List)data);
        }
    }

    private void pushListData(List<Map<String, Object>> data) {
        DataCopyOutput output = this.initOutput();
        try {
            for (Map<String, Object> val : data) {
                val = this.buildDataBySchema(val);
                output.write(val);
            }
            output.commit();
        }
        catch (Throwable err) {
            output.rollback(err);
            if (err instanceof IscBizException) {
                ((IscBizException)err).setData(Json.toString(data));
                throw err;
            }
            IscBizException err2 = new IscBizException(err.getMessage(), err);
            err2.setData(Json.toString(data));
            throw err2;
        }
        finally {
            output.dispose();
        }
    }

    private Map<String, Object> buildDataBySchema(Map<String, Object> data) {
        if (this.fields.isEmpty()) {
            return data;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(data.size());
        for (Map<String, Object> field : this.fields) {
            String field_name = D.s((Object)field.get("field_name"));
            Object value = this.getValue(data, field_name);
            this.putValues(map, field_name, value);
        }
        return map;
    }

    private void putValues(Map<String, Object> map, String field_name, Object value) {
        if (field_name.contains(".")) {
            int endIndex = field_name.indexOf(46);
            String entryName = field_name.substring(0, endIndex);
            Object entryMap = map.get(entryName);
            if (entryMap != null) {
                this.setTarEntryMap(entryMap, field_name.substring(endIndex + 1), value);
            } else {
                map.put(entryName, value);
            }
        } else {
            map.put(field_name, value);
        }
    }

    private void setTarEntryMap(Object entryTarMap, String field_name, Object entrySrcValue) {
        if (entryTarMap instanceof List && entrySrcValue instanceof List) {
            List<Object> entryTarList = (List<Object>)entryTarMap;
            List entrySrcList = (List)entrySrcValue;
            for (int i = 0; i < entrySrcList.size(); ++i) {
                entryTarList = this.calcEntryValue(field_name, entryTarList, entrySrcList, i);
            }
        } else if (entryTarMap instanceof Map && entrySrcValue instanceof Map) {
            Map tarMap = (Map)entryTarMap;
            Map srcMap = (Map)entrySrcValue;
            tarMap.putAll(srcMap);
        }
    }

    private List<Object> calcEntryValue(String field_name, List<Object> entryTarList, List<Object> entrySrcList, int i) {
        int endIndex = field_name.indexOf(46);
        String entryName = endIndex == -1 ? field_name : field_name.substring(0, endIndex);
        Object entryTarVal = entryTarList.get(i);
        Object entrySrcVal = entrySrcList.get(i);
        if (entryTarVal instanceof Map && entrySrcVal instanceof Map) {
            Map tarMap = (Map)entryTarVal;
            Object tarVal = tarMap.get(entryName);
            Map srcMap = (Map)entrySrcVal;
            Object srcVal = srcMap.get(entryName);
            if (tarVal == null && (srcVal instanceof List || srcVal instanceof Map)) {
                tarMap.put(entryName, srcVal);
            } else if (!(srcVal instanceof Map) && !(srcVal instanceof List)) {
                tarMap.putAll(srcMap);
            } else {
                this.setTarEntryMap(tarVal, endIndex == -1 ? field_name : field_name.substring(endIndex + 1), srcVal);
            }
        } else {
            entryTarList = entrySrcList;
        }
        return entryTarList;
    }

    private Object getValue(Map<String, Object> data, String field_name) {
        int index = 0;
        index = field_name.indexOf(46);
        if (index > 0) {
            String entryName = field_name.substring(0, index);
            Object entryData = data.get(entryName);
            if (entryData instanceof List) {
                List entryList = (List)entryData;
                ArrayList tmpList = new ArrayList(entryList.size());
                for (Map entryDataMap : entryList) {
                    if (entryDataMap == null) continue;
                    String fieldName = field_name.substring(index + 1);
                    HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                    Object value = this.getValue(entryDataMap, fieldName);
                    String[] nextName = fieldName.split("\\.");
                    tmpMap.put(nextName[0], value);
                    tmpList.add(tmpMap);
                }
                return tmpList;
            }
            if (entryData instanceof Map) {
                String fieldName = field_name.substring(index + 1);
                HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                String[] nextName = fieldName.split("\\.");
                tmpMap.put(nextName[0], this.getValue((Map)entryData, fieldName));
                return tmpMap;
            }
            return entryData;
        }
        return data.get(field_name);
    }

    public static Object getValue(Execution e, Object value) {
        if (value instanceof ExprGetter) {
            ExprGetter exprGetter = (ExprGetter)value;
            value = exprGetter.get(e);
        }
        return value;
    }
}

