/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.solution.SolutionResourceCompareJobFactory;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class SolutionResourceCompareJob
implements Job {
    public static final SolutionResourceCompareJobFactory FACTORY = new SolutionResourceCompareJobFactory();
    private long id;
    private String tile;
    private String param;
    private int total;
    private String current;
    private AtomicInteger completed = new AtomicInteger(0);
    private DynamicObject comp;

    public SolutionResourceCompareJob(String tile, String param) {
        this.tile = tile;
        this.param = param;
        Map params = (Map)Json.toObject((String)this.param);
        this.id = D.l(params.get("id"));
        this.comp = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_resource_compare");
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.tile;
    }

    @Override
    public long getOwnerId() {
        return Math.abs(Hash.mur64((byte[])"SolutionResourceCompareJob".getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.total, this.completed.get(), this.current);
    }

    @Override
    public void run() {
        this.comp.set("progress", (Object)"COMPARING");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.comp});
        DynamicObjectCollection mainResources = this.comp.getDynamicObjectCollection("main_resources");
        Graph g = new Graph();
        this.total = mainResources.size();
        ArrayList<DynamicObject> mainObjects = new ArrayList<DynamicObject>(mainResources.size());
        for (DynamicObject main : mainResources) {
            SignalManager.checkCancelSignal();
            String pk = D.s((Object)main.get("main_res_pk"));
            DynamicObject type = main.getDynamicObject("main_res_type");
            String entity = D.s((Object)type.getPkValue());
            Object resPK = FileResourceUtil.parseResPK(pk, entity);
            DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)resPK, (String)entity);
            mainObjects.add(o);
            this.current = o.getDataEntityType().getDisplayName().toString() + "(" + main.get("main_res_number") + ")";
            ExportDynamicObject.append((Graph<DynamicObject>)g, o);
            this.completed.incrementAndGet();
        }
        List refResources = g.topSort();
        if (refResources.size() != g.getNodeCount()) {
            Map<String, List<String>> bills = ExportDynamicObject.getCrossRefs((Graph<DynamicObject>)g, refResources);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e4b\u95f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u51fa\uff01\u6d89\u53ca\u7684\u5355\u636e\u6709\uff1a%s", (String)"SolutionResourceCompareJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), bills));
        }
        this.updateEntries(refResources, mainObjects);
    }

    private void updateEntries(List<DynamicObject> refResources, List<DynamicObject> mainResources) {
        this.compareMainEntries(mainResources);
        Map<String, DynamicObject> refMap = SolutionUtil.convertToMap(refResources, mainResources);
        this.compareRefResources(refMap);
        this.comp.set("progress", (Object)"COMPARED");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.comp});
    }

    private void compareRefResources(Map<String, DynamicObject> refMap) {
        Object type;
        DynamicObjectCollection entries = this.comp.getDynamicObjectCollection("ref_resources");
        for (DynamicObject item : entries) {
            String resPk = D.s((Object)item.get("ref_res_pk"));
            type = item.getDynamicObject("ref_res_type");
            String entity = type.getString("id");
            DynamicObject localRes = refMap.remove(SolutionUtil.getFullKey(entity, resPk));
            Timestamp localTime = SolutionUtil.getLocalTime(entity, resPk);
            Timestamp resTime = D.t((Object)item.get("ref_res_time"));
            item.set("ref_local_time", (Object)localTime);
            if (localRes == null) {
                item.set("ref_importing_operation", (Object)"DELETE");
                continue;
            }
            if (localTime != null && resTime != null && localTime.after(resTime)) {
                item.set("ref_importing_operation", (Object)"UPDATE");
                this.setEntryValue(item, localRes);
                continue;
            }
            item.set("ref_importing_operation", (Object)"IGNORE");
        }
        for (DynamicObject data : refMap.values()) {
            DynamicObject item = entries.addNew();
            type = data.getDynamicObjectType().getName();
            this.setEntryValue(item, data);
            item.set("ref_res_time", (Object)D.t((Object)System.currentTimeMillis()));
            item.set("ref_res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)type, (String)"bos_objecttype"));
            item.set("ref_res_pk", data.getPkValue());
            item.set("ref_importing_operation", (Object)"INSERT");
        }
    }

    private void compareMainEntries(List<DynamicObject> mainResources) {
        DynamicObjectCollection mainEntries = this.comp.getDynamicObjectCollection("main_resources");
        for (DynamicObject item : mainEntries) {
            Object id;
            String resPk = D.s((Object)item.get("main_res_pk"));
            DynamicObject type = item.getDynamicObject("main_res_type");
            String entity = type.getString("id");
            Timestamp localTime = SolutionUtil.getLocalTime(entity, resPk);
            Timestamp resTime = D.t((Object)item.get("main_res_time"));
            item.set("main_local_time", (Object)localTime);
            if (localTime == null) {
                item.set("main_importing_operation", (Object)"DELETE");
            } else if (resTime != null && localTime.after(resTime)) {
                item.set("main_importing_operation", (Object)"UPDATE");
                id = FileResourceUtil.parseResPK(resPk, entity);
                this.setMainEntryValue(item, entity, id);
            } else {
                item.set("main_importing_operation", (Object)"IGNORE");
            }
            if (localTime == null) continue;
            id = FileResourceUtil.parseResPK(resPk, entity);
            mainResources.add(BusinessDataServiceHelper.loadSingle((Object)id, (String)entity));
        }
    }

    private void setMainEntryValue(DynamicObject item, String entity, Object pk) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entity);
        item.set("main_res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)entity, (String)"bos_objecttype"));
        item.set("main_res_number", (Object)res.getString("number"));
        item.set("main_res_name", (Object)res.getString("name"));
        Object pkValue = res.getPkValue();
        item.set("main_res_pk", pkValue);
        item.set("main_res_remark", (Object)SolutionUtil.getRemark(res));
        Map<String, Object> map = DynamicObjectUtil.object2Map(res);
        map.put("$id", pkValue);
        map.put("$entityname", entity);
        map.put("$isref", Boolean.FALSE);
        String content = Json.toString(map);
        item.set("main_res_content_tag", (Object)content);
        item.set("main_res_size", (Object)content.length());
    }

    private void setEntryValue(DynamicObject item, DynamicObject data) {
        item.set("ref_res_number", (Object)data.getString("number"));
        item.set("ref_res_name", (Object)data.getString("name"));
        Map<String, Object> map = DynamicObjectUtil.object2Map(data);
        map.put("$id", data.getPkValue());
        map.put("$entityname", data.getDynamicObjectType().getName());
        map.put("$isref", Boolean.FALSE);
        String content = Json.toString(map);
        item.set("ref_res_content_tag", (Object)content);
        item.set("ref_res_size", (Object)content.length());
        Object value = data.get(SolutionUtil.getTimeField(data.getDynamicObjectType().getName()));
        item.set("ref_res_time", value);
        item.set("ref_local_time", value);
    }
}

