/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.util.FileNameUtils;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.solution.SolutionResourceImportJobFactory;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.ClassInfo;

public class SolutionResourceImportJob
implements Job {
    public static final SolutionResourceImportJobFactory FACTORY = new SolutionResourceImportJobFactory();
    private String title;
    private String _package = "isc/iscb/solution";
    private volatile transient String progress;
    private volatile int total;
    private AtomicInteger success = new AtomicInteger(0);
    private AtomicInteger omitted = new AtomicInteger(0);
    private AtomicInteger failed = new AtomicInteger(0);
    private static final Log logger = LogFactory.getLog(SolutionResourceImportJob.class);

    public SolutionResourceImportJob(String title) {
        this.title = title;
    }

    @Override
    public long getOwnerId() {
        return Hash.mur64((byte[])this._package.getBytes(D.UTF_8));
    }

    @Override
    public String getParam() {
        return this._package;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.progress;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.total, this.success.get() + this.failed.get() + this.omitted.get(), this.progress);
    }

    @Override
    public String getJobSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u603b\u6570\uff1a%1$s\u4e2a\uff0c\u6210\u529f\uff1a%2$s\u4e2a\uff0c\u5931\u8d25\uff1a%3$s\u4e2a\u3002", (String)"SolutionResourceImportJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.success, this.failed));
        if (this.omitted.get() > 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\u5ffd\u7565\uff1a%s\uff0c\u672c\u5730\u65b9\u6848\u7248\u672c\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u7cfb\u7edf\u7248\u672c\u3002", (String)"SolutionResourceImportJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.omitted));
        }
        sb.deleteCharAt(sb.length() - 1).append('\u3002');
        return sb.toString();
    }

    @Override
    public void run() {
        URL url = this.getClass().getClassLoader().getResource("kd/isc/iscb/platform/res/Stub.class");
        Assert.notNull((Object)url, (String)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u5305isc-iscb-platform-res\u672a\u627e\u5230Stub.class\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5305\u662f\u5426\u90e8\u7f72\u6b63\u786e\u3002", (String)"SolutionResourceImportJob_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        try (ZipFile zip = ClassInfo.getZipFile((String)url.toString());){
            this.total = this.scan(zip);
            this.doImporting(zip);
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }

    private void doImporting(ZipFile zip) {
        Enumeration<? extends ZipEntry> it = zip.entries();
        while (it.hasMoreElements()) {
            String name = it.nextElement().getName();
            this.progress = name.substring(name.lastIndexOf(47) + 1);
            if (!this.isRequiredResource(name)) continue;
            SignalManager.checkCancelSignal();
            URL res = this.getClass().getClassLoader().getResource(name);
            this.importSingle(name, res);
        }
    }

    private void importSingle(String name, URL res) {
        block16: {
            try (ZipInputStream in = new ZipInputStream(res.openStream());){
                UploadState state = SolutionResourceImportJob.uploadSolution(in);
                if (UploadState.SUCCESS == state) {
                    this.success.incrementAndGet();
                    break block16;
                }
                if (UploadState.OMITTED == state) {
                    this.omitted.incrementAndGet();
                    break block16;
                }
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848[%s]\u5931\u8d25\u3002", (String)"SolutionResourceImportJob_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
            }
            catch (Exception e) {
                this.failed.incrementAndGet();
                logger.error("\u5bfc\u5165\u89e3\u51b3\u65b9\u6848[" + name + "]\u51fa\u9519\u3002" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            }
        }
    }

    public static UploadState uploadSolution(ZipInputStream in) throws Exception {
        ZipEntry entry;
        List<String> dts = Collections.emptyList();
        String logoURL = null;
        while ((entry = in.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (name.endsWith(".dts")) {
                dts = SolutionResourceImportJob.parseDtsFile(in);
                continue;
            }
            if (!name.contains("logo")) continue;
            logoURL = SolutionResourceImportJob.uploadLogoToFileServer(new ImageInputStream(in), entry);
        }
        return SolutionResourceImportJob.innerImport(dts, logoURL);
    }

    private static String uploadLogoToFileServer(InputStream in, ZipEntry entry) throws IOException {
        String fileName = entry.getName();
        String simpleName = fileName.substring(fileName.lastIndexOf("logo"));
        long randId = IDService.get().genLongId();
        String path = FileNameUtils.getImageFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"iscb", (String)"isc_solution_center_m", (Object)randId, (String)simpleName);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] data = new byte[1024];
            int len = 0;
            while ((len = in.read(data)) != -1) {
                byteArrayOutputStream.write(data, 0, len);
            }
            FileItem fileItem = new FileItem(fileName, path, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            fileItem.setCreateNewFileWhenExists(true);
            String url = FileServiceFactory.getImageFileService().upload(fileItem);
            logger.info("upload image " + fileName + " success. path: " + path + "; url: " + url);
            String string = url;
            return string;
        }
    }

    private static UploadState innerImport(List<String> dts, String logoURL) {
        String solution;
        Map dtMap;
        String entity;
        if (dts.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u538b\u7f29\u6587\u4ef6\u4e2d\u83b7\u53d6\u7684\u65b9\u6848\uff08dts\u6587\u4ef6\uff09\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u52a0\u8f7d\uff0c\u8bf7\u786e\u4fdd\u65b9\u6848zip\u5305\u5b8c\u6574\u3002", (String)"SolutionResourceImportJob_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (dts.size() > 1) {
            ImportDynamicObject.innerImport(dts.subList(0, dts.size() - 1));
        }
        if ((entity = D.s((dtMap = (Map)Json.toObject((String)(solution = dts.get(dts.size() - 1)))).get("$entityname"))) != null && !"isc_solution_center_m".equals(entity) && !"isc_solution_center".equals(entity)) {
            String name = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
            throw new IscBizException(String.format(ResManager.loadKDString((String)"dts\u6587\u4ef6\u7c7b\u578b\u4e0d\u662f[\u89e3\u51b3\u65b9\u6848]\uff0c\u800c\u662f[%s]", (String)"SolutionResourceImportJob_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
        }
        if (logoURL != null) {
            dtMap.put("logo", logoURL);
        }
        dtMap.remove("is_deployed");
        if (SolutionUtil.isOmitted(dtMap)) {
            return UploadState.OMITTED;
        }
        ImportDynamicObject.innerImport(Json.toString((Object)dtMap));
        return UploadState.SUCCESS;
    }

    private static List<String> parseDtsFile(InputStream input) throws Exception {
        ArrayList<String> dts = new ArrayList<String>();
        int size = 0;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
        int temp = input.read();
        while (temp >= 0) {
            SolutionResourceImportJob.checkSize(++size);
            if (temp != 10) {
                buffer.write(temp);
            } else {
                dts.add(new String(buffer.toByteArray(), StandardCharsets.UTF_8));
                buffer = new ByteArrayOutputStream(2048);
            }
            temp = input.read();
        }
        return dts;
    }

    private static void checkSize(int size) {
        if (size > 0x2800000) {
            throw new IscBizException(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u5185\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8640MB", (String)"SolutionResourceImportJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private int scan(ZipFile zip) {
        Enumeration<? extends ZipEntry> it = zip.entries();
        int total = 0;
        while (it.hasMoreElements()) {
            String name = it.nextElement().getName();
            if (!this.isRequiredResource(name)) continue;
            ++total;
        }
        return total;
    }

    private boolean isRequiredResource(String name) {
        return name.endsWith(".zip") && name.startsWith(this._package);
    }

    static class ImageInputStream
    extends InputStream {
        private InputStream in;
        private int count = 0;

        ImageInputStream(InputStream input) {
            this.in = input;
        }

        @Override
        public int read() throws IOException {
            SolutionResourceImportJob.checkSize(++this.count);
            return this.in.read();
        }
    }

    public static enum UploadState {
        SUCCESS,
        FAILED,
        OMITTED;

    }
}

