/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.solution.SolutionResourceUpdateJobFactory;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class SolutionResourceUpdateJob
implements Job {
    public static final SolutionResourceUpdateJobFactory FACTORY = new SolutionResourceUpdateJobFactory();
    private String title;
    private volatile transient String progress;
    private volatile int total;
    private AtomicInteger completed = new AtomicInteger(0);
    private String param;
    private DynamicObject comp;
    private long solutionId;

    public SolutionResourceUpdateJob(String title, String param) {
        this.title = title;
        this.param = param;
        Map params = (Map)Json.toObject((String)this.param);
        this.comp = BusinessDataServiceHelper.loadSingle((Object)D.l(params.get("id")), (String)"isc_resource_compare");
        this.solutionId = D.l(params.get("solution_id"));
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public long getOwnerId() {
        return Math.abs(Hash.mur64((byte[])"SolutionResourceUpdateJob".getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void run() {
        DynamicObjectCollection mainResources = this.comp.getDynamicObjectCollection("main_resources");
        DynamicObjectCollection refResources = this.comp.getDynamicObjectCollection("ref_resources");
        this.total = mainResources.size() + refResources.size();
        try {
            DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)this.solutionId, (String)"isc_solution_center_m");
            this.updateMainResources(solution, mainResources);
            this.updateRefResources(solution, refResources);
            solution.set("modifier", (Object)RequestContext.get().getUserId());
            solution.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
            SolutionUtil.evalPackageSize(solution);
            ConnectorUtil.save(solution);
            this.comp.set("progress", (Object)"UPDATED");
        }
        catch (Exception e) {
            try {
                this.comp.set("progress", (Object)"UPDATE_FAILED");
                throw e;
            }
            catch (Throwable throwable) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.comp});
                throw throwable;
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.comp});
    }

    private void updateMainResources(DynamicObject solution, DynamicObjectCollection mainResources) {
        DynamicObjectCollection main = solution.getDynamicObjectCollection("main_resources");
        Map<String, DynamicObject> mainResMap = this.convertToMap(mainResources, "main_res_type", "main_res_pk");
        Iterator it = main.iterator();
        while (it.hasNext()) {
            Object pkValue;
            DynamicObject o = (DynamicObject)it.next();
            DynamicObject type = o.getDynamicObject("main_res_type");
            String entity = D.s((Object)type.getPkValue());
            String fullKey = SolutionUtil.getFullKey(entity, pkValue = FileResourceUtil.parseResPK((String)o.get("main_res_pk"), entity));
            DynamicObject item = mainResMap.remove(fullKey);
            if (item == null) {
                it.remove();
            } else {
                String mode = D.s((Object)item.get("main_importing_operation"));
                if (!"IGNORE".equals(mode)) {
                    if ("DELETE".equals(mode)) {
                        it.remove();
                    } else if ("UPDATE".equals(mode)) {
                        this.setMainValues(o, type, entity, pkValue, item);
                    }
                }
            }
            this.progress = type.getString("name") + ':' + o.getString("main_res_name");
            this.completed.incrementAndGet();
        }
        for (DynamicObject item : mainResMap.values()) {
            String mode = D.s((Object)item.get("main_importing_operation"));
            if ("INSERT".equals(mode)) {
                DynamicObject type = item.getDynamicObject("main_res_type");
                String entity = D.s((Object)type.getPkValue());
                Object pkValue = FileResourceUtil.parseResPK((String)item.get("main_res_pk"), entity);
                DynamicObject o = main.addNew();
                this.setMainValues(o, type, entity, pkValue, item);
                this.progress = type.getString("name") + ':' + o.getString("main_res_name");
            }
            this.completed.incrementAndGet();
        }
    }

    private void setMainValues(DynamicObject o, DynamicObject type, String entity, Object pkValue, DynamicObject item) {
        o.set("main_res_pk", pkValue);
        o.set("main_res_type", (Object)type);
        o.set("main_res_number", (Object)item.getString("main_res_number"));
        o.set("main_res_name", (Object)item.getString("main_res_name"));
        o.set("main_res_time", item.get("main_local_time"));
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entity);
        Map<String, Object> map = DynamicObjectUtil.object2Map(res);
        map.put("$id", pkValue);
        map.put("$entityname", entity);
        map.put("$isref", Boolean.FALSE);
        String content = Json.toString(map);
        o.set("main_res_content_tag", (Object)content);
        o.set("main_res_size", (Object)content.length());
        o.set("main_res_remark", (Object)SolutionUtil.getRemark(res));
    }

    private void updateRefResources(DynamicObject solution, DynamicObjectCollection refResources) {
        DynamicObjectCollection ref = solution.getDynamicObjectCollection("ref_resources");
        Map<String, DynamicObject> refResMap = this.convertToMap(refResources, "ref_res_type", "ref_res_pk");
        Iterator it = ref.iterator();
        while (it.hasNext()) {
            Object pkValue;
            DynamicObject o = (DynamicObject)it.next();
            DynamicObject type = o.getDynamicObject("ref_res_type");
            String entity = D.s((Object)type.getPkValue());
            String fullKey = SolutionUtil.getFullKey(entity, pkValue = FileResourceUtil.parseResPK((String)o.get("ref_res_pk"), entity));
            DynamicObject item = refResMap.remove(fullKey);
            if (item == null) {
                it.remove();
            } else {
                String mode = D.s((Object)item.get("ref_importing_operation"));
                if (!"IGNORE".equals(mode)) {
                    if ("DELETE".equals(mode)) {
                        it.remove();
                    } else if ("UPDATE".equals(mode)) {
                        this.setRefValues(o, type, entity, pkValue, item);
                    }
                }
            }
            this.progress = type.getString("name") + ':' + o.getString("ref_res_name");
            this.completed.incrementAndGet();
        }
        for (DynamicObject item : refResMap.values()) {
            String mode = D.s((Object)item.get("ref_importing_operation"));
            if ("INSERT".equals(mode)) {
                DynamicObject type = item.getDynamicObject("ref_res_type");
                String entity = D.s((Object)type.getPkValue());
                Object pkValue = FileResourceUtil.parseResPK((String)item.get("ref_res_pk"), entity);
                DynamicObject o = ref.addNew();
                this.setRefValues(o, type, entity, pkValue, item);
                this.progress = type.getString("name") + ':' + o.getString("ref_res_name");
            }
            this.completed.incrementAndGet();
        }
    }

    private void setRefValues(DynamicObject o, DynamicObject type, String entity, Object pkValue, DynamicObject item) {
        o.set("ref_res_pk", pkValue);
        o.set("ref_res_type", (Object)type);
        o.set("ref_res_number", item.get("ref_res_number"));
        o.set("ref_res_name", item.get("ref_res_name"));
        o.set("ref_res_time", item.get("ref_local_time"));
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entity);
        Map<String, Object> map = DynamicObjectUtil.object2Map(res);
        map.put("$id", pkValue);
        map.put("$entityname", entity);
        map.put("$isref", Boolean.FALSE);
        String content = Json.toString(map);
        o.set("ref_res_content_tag", (Object)content);
        o.set("ref_res_size", (Object)content.length());
    }

    private Map<String, DynamicObject> convertToMap(DynamicObjectCollection resources, String typeKey, String pkKey) {
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>(resources.size());
        for (DynamicObject resource : resources) {
            String entity = D.s((Object)resource.getDynamicObject(typeKey).getPkValue());
            String pk = D.s((Object)resource.get(pkKey));
            map.put(SolutionUtil.getFullKey(entity, pk), resource);
        }
        return map;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.progress;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.total, this.completed.get(), this.progress);
    }
}

