/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionResourceDeployJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceUtil;
import kd.isc.iscb.platform.core.solution.resources.DeployResourceFromSolution;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.platform.core.util.ZipUtils;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Quad;
import kd.isc.iscb.util.misc.StringUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SolutionUtil {
    private static final String BASE64_HEADER = "data:image/png;base64,";
    private static final int IMAGE_MAX_SIZE = 0x200000;

    public static Timestamp getLocalTime(String entity, String pk) {
        String field = SolutionUtil.getTimeField(entity);
        Object id = FileResourceUtil.parseResPK(pk, entity);
        DynamicObject obj = QueryServiceHelper.queryOne((String)entity, (String)field, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        return obj == null ? null : D.t((Object)obj.get(field));
    }

    public static String getTimeField(String entity) {
        String field = "isc_apic_permission".equals(entity) ? "created_time" : "modifytime";
        return field;
    }

    public static String getRemark(DynamicObject res) {
        DynamicObjectType type = res.getDynamicObjectType();
        if (type.getProperty("remark") != null) {
            return res.getString("remark");
        }
        if (type.getProperty("description") != null) {
            return res.getString("description");
        }
        if (type.getProperty("comment") != null) {
            return res.getString("comment");
        }
        if (type.getProperty("describe") != null) {
            return res.getString("describe");
        }
        return null;
    }

    public static String getFullKey(String entity, Object pk) {
        if (entity != null) {
            return entity + ',' + pk;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u884cID[%s]\u5bf9\u5e94\u7684\u5b9e\u4f53\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"SolutionUtil_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), pk));
    }

    public static Map<String, DynamicObject> convertToMap(List<DynamicObject> objects, List<DynamicObject> mainResources) {
        String key;
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>(objects.size());
        for (DynamicObject object : objects) {
            key = SolutionUtil.getFullKey(object.getDataEntityType().getName(), object.getPkValue());
            map.put(key, object);
        }
        for (DynamicObject obj : mainResources) {
            key = SolutionUtil.getFullKey(obj.getDataEntityType().getName(), obj.getPkValue());
            map.remove(key);
        }
        return map;
    }

    public static List<DynamicObject> getMainResources(List<DynamicObject> objects, List<DynamicObject> mainResources) {
        HashSet<String> mainKeySet = new HashSet<String>(mainResources.size());
        for (DynamicObject obj : mainResources) {
            String key = SolutionUtil.getFullKey(obj.getDataEntityType().getName(), obj.getPkValue());
            mainKeySet.add(key);
        }
        LinkedList<DynamicObject> list = new LinkedList<DynamicObject>();
        for (DynamicObject object : objects) {
            String key = SolutionUtil.getFullKey(object.getDataEntityType().getName(), object.getPkValue());
            if (!mainKeySet.contains(key)) continue;
            list.add(object);
        }
        return list;
    }

    public static void evalPackageSize(DynamicObject obj) {
        long size = SolutionUtil.evalLogoSize(obj);
        size += SolutionUtil.evalDetailSize(obj);
        size += SolutionUtil.evalResourceSize(obj.getDynamicObjectCollection("main_resources"), "main_res_size");
        obj.set("size", (Object)SolutionUtil.toText(size += SolutionUtil.evalResourceSize(obj.getDynamicObjectCollection("ref_resources"), "ref_res_size")));
    }

    private static long evalLogoSize(DynamicObject obj) {
        long size = 0L;
        String logo = D.s((Object)obj.get("logo"));
        if (logo != null) {
            int p = logo.indexOf(63);
            if (p > 0) {
                logo = logo.substring(0, p);
            }
            size += SolutionUtil.getSize(logo);
        }
        return size;
    }

    private static long evalDetailSize(DynamicObject obj) {
        long size = 0L;
        String detail = D.s((Object)obj.get("detail_tag"));
        if (detail != null) {
            Document doc = Jsoup.parse((String)detail);
            List<String> urls = SolutionUtil.getImageUrls(doc);
            for (String url : urls) {
                size += SolutionUtil.getSize(url);
            }
            size += (long)detail.getBytes(StandardCharsets.UTF_8).length;
        }
        return size;
    }

    private static long getSize(String url) {
        int total;
        long size = 0L;
        try (BufferedInputStream in = new BufferedInputStream(SolutionUtil.getInputStream(url));){
            int len;
            byte[] bytes = new byte[1024];
            total = 0;
            while ((len = in.read(bytes)) != -1) {
                SolutionUtil.checkMaxImageSize(total += len);
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        return size += (long)total;
    }

    public static long evalResourceSize(DynamicObjectCollection entries, String sizeName) {
        long size = 0L;
        for (DynamicObject entry : entries) {
            size += D.l((Object)entry.get(sizeName));
        }
        return size;
    }

    public static String toText(long bytes) {
        DecimalFormat f = new DecimalFormat("0.00");
        long KB = 1024L;
        long MB = 0x100000L;
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return f.format((float)bytes / 1024.0f) + "KB";
        }
        if (bytes <= 0x2800000L) {
            return f.format((float)bytes / 1048576.0f) + "MB";
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5305\u5df2\u7ecf\u8d85\u8fc7\u4e8640MB\uff0c\u8bf7\u8c03\u6574\u56fe\u7247\u3001\u5f15\u7528\u8d44\u6e90\u5927\u5c0f", (String)"SolutionUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private static List<String> getImageUrls(Document doc) {
        Elements images = doc.getElementsByTag("img");
        ArrayList<String> urls = new ArrayList<String>(images.size());
        for (Element img : images) {
            String src = img.attr("src");
            if (src.startsWith(BASE64_HEADER)) continue;
            String path = SolutionUtil.getPath(src);
            SolutionUtil.checkValid(path);
            String name = path.substring(path.lastIndexOf(47) + 1);
            img.attr("src", name);
            urls.add(path);
        }
        return urls;
    }

    private static File getOrCreateDirectory(DynamicObject object) {
        String number = object.getString("number");
        String name = object.getString("name");
        String version = D.s((Object)object.get("version"));
        String str = FileUtil.removeIllegalChar(name + "_" + number + "_v" + version);
        String path = System.getProperty("user.home") + File.separator + "downloads" + File.separator + "temp" + File.separator + str;
        return new File(FileUtil.checkDirectory(true, path));
    }

    private static void saveVersion(DynamicObject object) {
        String version = D.s((Object)object.get("version"));
        int seq = 1;
        if (version != null) {
            int index = version.lastIndexOf(45);
            seq = index > 0 ? D.i((Object)version.substring(index + 1)) + 1 : 1;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String format = sdf.format(new Date());
        object.set("version", (Object)(format + "-" + seq));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public static File export2(Object pk) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"isc_solution_center_m");
        SolutionUtil.saveVersion(object);
        SolutionUtil.convertBase64Image(object);
        File dir = SolutionUtil.getOrCreateDirectory(object);
        String baseDir = dir.getAbsolutePath();
        String url = D.s((Object)object.get("logo"));
        if (url != null) {
            SolutionUtil.downloadLogo(baseDir, url);
        }
        SolutionUtil.downloadDts(baseDir, object);
        try {
            return ZipUtils.compressFolder(dir);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private static void convertBase64Image(DynamicObject object) {
        String detail = D.s((Object)object.get("detail_tag"));
        if (detail != null) {
            Document doc = Jsoup.parse((String)detail);
            Elements images = doc.getElementsByTag("img");
            for (Element img : images) {
                String url = img.attr("src");
                if (url.startsWith(BASE64_HEADER)) continue;
                String path = SolutionUtil.getPath(url);
                String data = SolutionUtil.getImageBase64ByIO(path);
                img.attr("src", data);
            }
            String content = doc.outerHtml();
            object.set("detail_tag", (Object)content);
        }
    }

    private static String getPath(String url) {
        String[] params;
        int index = url.indexOf(63);
        if (index < 0) {
            return url;
        }
        int p = url.indexOf("/attachment/downloadImage");
        if (p > 0) {
            return url.substring(p + "/attachment/downloadImage".length(), index);
        }
        String s = url.substring(index + 1);
        for (String a : params = s.split("&")) {
            String[] split = a.split("=");
            if (!"path".equalsIgnoreCase(split[0])) continue;
            return split[1];
        }
        return url.substring(0, index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getImageBase64ByIO(String url) {
        try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
            byte[] bs = new byte[1024];
            int total = 0;
            try (InputStream in = SolutionUtil.getInputStream(url);){
                int len;
                while ((len = in.read(bs)) != -1) {
                    ba.write(bs, 0, len);
                    SolutionUtil.checkMaxImageSize(total += len);
                }
            }
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] imgByte = encoder.encode(ba.toByteArray());
            String string = BASE64_HEADER + new String(imgByte, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }

    private static void checkMaxImageSize(int total) {
        if (total > 0x200000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u56fe\u7247\u5927\u5c0f\u8d85\u8fc72M\uff0c\u8bf7\u8c03\u6574\u5927\u5c0f\u540e\u4e0a\u4f20\u3002", (String)"SolutionUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void downloadDts(String baseDir, DynamicObject object) {
        File file = new File(baseDir + File.separator + "solution.dts");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
            try {
                boolean isExisted = file.createNewFile();
                if (!isExisted) {
                    // empty if block
                }
            }
            catch (IOException e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728%s\u4e0b\u521b\u5efa\u6587\u4ef6\u6216\u76ee\u5f55\u5f02\u5e38\uff01", (String)"SolutionUtil_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), file.getAbsolutePath()), (Throwable)e);
            }
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            ExportDynamicObject.export((OutputStream)out, object);
            return;
        }
        catch (Exception e) {
            FileUtil.delete(file);
            throw D.e((Throwable)e);
        }
    }

    private static void downloadLogo(String baseDir, String url) {
        int p = url.indexOf(63);
        if (p > 0) {
            url = url.substring(0, p);
        }
        url = SolutionUtil.trimVersion(url);
        int index = url.lastIndexOf(46);
        String suffix = url.substring(index);
        File tempFile = FileUtil.createNewFile(baseDir, "logo", suffix);
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            byte[] bytes = new byte[1024];
            try (BufferedInputStream in = new BufferedInputStream(SolutionUtil.getInputStream(url));){
                int len;
                while ((len = in.read(bytes)) != -1) {
                    ((OutputStream)out).write(bytes, 0, len);
                }
            }
        }
        catch (Exception e) {
            FileUtil.delete(tempFile);
            throw D.e((Throwable)e);
        }
    }

    private static String trimVersion(String url) {
        return url.replace("&v=1.0", "").replace("&v=0.5", "");
    }

    private static InputStream getInputStream(String url) throws IOException {
        url = SolutionUtil.trimVersion(url);
        SolutionUtil.checkValid(url);
        if (url.startsWith("http")) {
            URLConnection cn = new URL(url).openConnection();
            cn.setConnectTimeout(10000);
            return cn.getInputStream();
        }
        SolutionUtil.checkFileExisted(url);
        return FileServiceFactory.getImageFileService().getInputStream(url);
    }

    private static void checkFileExisted(String url) {
        if (!FileServiceFactory.getImageFileService().exists(url)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fe\u7247\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4e0b\u8f7d\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\uff08%s\uff09\u662f\u5426\u6b63\u786e\u3002", (String)"SolutionUtil_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), url));
        }
    }

    private static void checkValid(String url) {
        int index = url.lastIndexOf(46);
        if (index < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u56fe\u7247\u8def\u5f84url\uff1a%s\u4e0d\u5408\u6cd5\uff0c\u5e94\u4e3a.png/.jpg/.svg...\u7b49\u683c\u5f0f\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SolutionUtil_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), url));
        }
    }

    public static boolean isOmitted(Map<String, Object> solution) {
        long id = D.l((Object)solution.get("id"));
        DynamicObject solutionFormDb = QueryServiceHelper.queryOne((String)"isc_solution_center_m", (String)"main_resources,version,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (solutionFormDb != null) {
            if (!solution.get("status").equals(solutionFormDb.get("status"))) {
                return false;
            }
            String importVersion = D.s((Object)solution.get("version"));
            String currentVersion = D.s((Object)solutionFormDb.get("version"));
            if (currentVersion == null) {
                return false;
            }
            if (SolutionUtil.solutionMainResourceIsEmpty(solutionFormDb)) {
                return false;
            }
            return SolutionUtil.compareVersion(importVersion, currentVersion);
        }
        return false;
    }

    private static boolean solutionMainResourceIsEmpty(DynamicObject solutionFormDb) {
        return D.l((Object)solutionFormDb.get("main_resources")) == 0L;
    }

    public static boolean compareVersion(String cloudVersion, String currentVersion) {
        cloudVersion = cloudVersion.replace("-", "");
        currentVersion = currentVersion.replace("-", "");
        return D.i((Object)cloudVersion) <= D.i((Object)currentVersion);
    }

    public static Map<String, Object> buildSolutionResource(DynamicObject object) {
        Map<String, Object> localSolution = DynamicObjectUtil.object2Map(object);
        Quad quad = SolutionUtil.buildResourceStatistics(object);
        localSolution.put(ResManager.loadKDString((String)"\u4e3b\u8d44\u6e90\u603b\u6570", (String)"SolutionUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), quad.getA());
        localSolution.put(ResManager.loadKDString((String)"\u603b\u4e3b\u8d44\u6e90\u5927\u5c0f", (String)"SolutionUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), quad.getB());
        localSolution.put(ResManager.loadKDString((String)"\u4f9d\u8d56\u8d44\u6e90\u603b\u6570", (String)"SolutionUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), quad.getC());
        localSolution.put(ResManager.loadKDString((String)"\u603b\u4f9d\u8d56\u8d44\u6e90\u5927\u5c0f", (String)"SolutionUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), quad.getD());
        localSolution.remove("main_resources");
        localSolution.remove("ref_resources");
        return localSolution;
    }

    private static Quad buildResourceStatistics(DynamicObject object) {
        DynamicObjectCollection mainResource = object.getDynamicObjectCollection("main_resources");
        DynamicObjectCollection refResource = object.getDynamicObjectCollection("ref_resources");
        int mainResourceCount = mainResource.size();
        long mainResourceSize = SolutionUtil.evalResourceSize(mainResource, "main_res_size");
        int refResourceCount = refResource.size();
        long refResourceSize = SolutionUtil.evalResourceSize(refResource, "ref_res_size");
        return new Quad((Object)mainResourceCount, (Object)SolutionUtil.toText(mainResourceSize), (Object)refResourceCount, (Object)SolutionUtil.toText(refResourceSize));
    }

    public static void saveDeployHistory(DynamicObject obj) {
        String json = Json.toString(DynamicObjectUtil.object2Map(obj), (boolean)true);
        DynamicObject histories = BusinessDataServiceHelper.newDynamicObject((String)"isc_res_history");
        histories.set("res_type", (Object)obj.getDataEntityType().getName());
        histories.set("operate_key", (Object)"deploy");
        histories.set("res_number", obj.get("number"));
        histories.set("res_name", (Object)obj.getString("name"));
        histories.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        histories.set("operator", (Object)D.l((Object)RequestContext.get().getUserId()));
        histories.set("res_content", (Object)"...");
        histories.set("res_content_tag", (Object)json);
        histories.set("resid", obj.getPkValue());
        histories.set("version", SolutionUtil.getVersion(obj.getPkValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{histories});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getVersion(Object pkValue) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "SELECT MAX(fversion) FROM t_iscb_res_history WHERE fres_id=?";
            int version = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(pkValue), Collections.singletonList(-5)));
            Integer n = version + 1;
            return n;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    public static List<File> batchExport(Object[] pks) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_solution_center_m");
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)entityType);
        ArrayList<File> fileList = new ArrayList<File>(objects.length);
        for (DynamicObject object : objects) {
            SolutionUtil.convertBase64Image(object);
            File dir = SolutionUtil.getOrCreateDirectory(object);
            String baseDir = dir.getAbsolutePath();
            String url = D.s((Object)object.get("logo"));
            if (url != null) {
                SolutionUtil.downloadLogo(baseDir, url);
            }
            SolutionUtil.downloadDts(baseDir, object);
            try {
                fileList.add(ZipUtils.compressFolder(dir));
            }
            catch (Exception e) {
                throw D.e((Throwable)e);
            }
        }
        return fileList;
    }

    public static Map<String, Object> subscribeById(long solutionId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SolutionUtil.updateSolutionCategory();
            SolutionUtil.updateSolutionDomain();
            String apiUrl = SolutionUtil.getApiUrl(Collections.singletonList(solutionId));
            List<Map<String, Object>> solutionList = PublicResourceUtil.queryListByGet(apiUrl, null);
            if (solutionList.isEmpty()) {
                throw new IscBizException(ResManager.loadKDString((String)"\u6839\u636e\u65b9\u6848\u5305id\u4ece\u4e91\u7aef\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u6216\u4e91\u7aef\u662f\u5426\u5b58\u5728\u8be5\u65b9\u6848\u3002", (String)"SolutionUtil_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            String msg = null;
            for (Map<String, Object> solution : solutionList) {
                String solutionNumber = D.s((Object)solution.get("number"));
                if (SolutionUtil.isOmitted(solution)) {
                    msg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\uff1a%s\u5ffd\u7565\u8ba2\u9605\uff0c\u539f\u56e0\u662f\u4e91\u7aef\u65b9\u6848\u7248\u672c\u53f7\u5c0f\u4e8e\u6216\u7b49\u4e8e\u672c\u5730\u7248\u672c\u53f7\u3002", (String)"SolutionUtil_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), solutionNumber);
                    continue;
                }
                SolutionUtil.saveSolutionAndResource(solution);
                msg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\uff1a%s\u6210\u529f\u8ba2\u9605\u3002", (String)"SolutionUtil_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), solutionNumber);
            }
            result.put("success", Boolean.TRUE);
            result.put("msg", msg);
        }
        catch (Exception e) {
            result.put("success", Boolean.FALSE);
            result.put("msg", StringUtil.toString((Throwable)e));
        }
        return result;
    }

    public static long selectDeploy(long sulotionId, List<String> resIds, boolean mainOverride, boolean refOverride) {
        List<Long> entryIds = SolutionUtil.getEntryIds(sulotionId, resIds);
        if (entryIds.size() != resIds.size()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4e3b\u8d44\u6e90id\u5217\u8868\u4e0e\u67e5\u8be2\u5f97\u5230\u7684\u5206\u5f55id\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u4e2d\u65b9\u6848\u5305id\u6216\u4e3b\u8d44\u6e90id\u662f\u5426\u6709\u8bef\u3002", (String)"SolutionUtil_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        LinkedHashSet<DynamicObject> deployRefEntryList = new LinkedHashSet<DynamicObject>();
        ArrayList<DynamicObject> deployMainEntryList = new ArrayList<DynamicObject>(30);
        DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)sulotionId, (String)"isc_solution_center_m");
        String solutionNumber = D.s((Object)solution.get("number"));
        DeployResourceFromSolution deploys = new DeployResourceFromSolution(solutionNumber);
        for (Long entryId : entryIds) {
            List<DynamicObject> dependentEntry = deploys.loadDependencies(entryId);
            deployRefEntryList.addAll(dependentEntry);
            deployMainEntryList.add(deploys.loadMain(entryId));
        }
        DynamicObject[] refArray = new DynamicObject[deployRefEntryList.size()];
        List<DynamicObject> reflist = Arrays.asList(deployRefEntryList.toArray(refArray));
        String billno = Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()});
        long billId = SolutionUtil.saveHead(solution, billno);
        SolutionUtil.saveMainContents(billId, deployMainEntryList, mainOverride);
        SolutionUtil.saveRefContents(billId, reflist, refOverride);
        SolutionResourceDeployJob job = new SolutionResourceDeployJob(billId, String.format(ResManager.loadKDString((String)"\u65b9\u6848\u90e8\u7f72\uff0c\u6279\u53f7\uff1a%s", (String)"SolutionUtil_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), billno));
        long jobId = JobEngine.submit(job);
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Long> getEntryIds(long sulotionId, List<String> resIds) {
        String sb = SolutionUtil.buildSqlByList(resIds);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        ArrayList<Long> entryIds = new ArrayList<Long>();
        try {
            String sql = "SELECT fentryid FROM t_isc_solution_mr WHERE fid = ? and fres_pk in (" + sb + ")";
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(sulotionId), Collections.singletonList(-5))) {
                long fentryid = D.l((Object)row.get((Object)"fentryid"));
                entryIds.add(fentryid);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return entryIds;
    }

    private static String buildSqlByList(List<String> resIds) {
        int size = resIds.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            String s = resIds.get(i);
            sb.append("'");
            sb.append(s);
            sb.append("'");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static long saveHead(DynamicObject solution, String billno) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"isc_dts_solution_deploy");
        long billId = IDService.get().genLongId();
        object.set("id", (Object)billId);
        object.set("billstatus", (Object)Character.valueOf('A'));
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("billno", (Object)billno);
        object.set("resid", solution.getPkValue());
        object.set("res_version", solution.get("version"));
        object.set("res_type", (Object)FileResourceUtil.getEntityTitle("isc_solution_center_m"));
        object.set("progress", (Object)"PARSED");
        object.set("state", (Object)"READY");
        object.set("modifytime", (Object)D.t((Object)System.currentTimeMillis()));
        object.set("modifier", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        return billId;
    }

    public static String getApiUrl(List<Long> ids) {
        StringBuilder api = new StringBuilder("kapi/v2/kdec/iscb/isc_solution_center/query_solution_by_id?");
        for (int i = 0; i < ids.size(); ++i) {
            api.append("id=");
            api.append(ids.get(i));
            if (i == ids.size() - 1) continue;
            api.append('&');
        }
        return D.s((Object)api);
    }

    public static void updateSolutionCategory() {
        String api = "kapi/v2/kdec/iscb/isc_solution_category/query_solution_category_list";
        List<Map<String, Object>> solutionCategoryList = PublicResourceUtil.queryListByGet(api, null);
        DynamicObject[] saveData = new DynamicObject[solutionCategoryList.size()];
        for (int i = 0; i < solutionCategoryList.size(); ++i) {
            DynamicObject object;
            Map<String, Object> item = solutionCategoryList.get(i);
            if ("0".equals(item.get("parent_id"))) {
                item.put("parent", "");
            }
            saveData[i] = object = DynamicObjectUtil.map2Object("isc_solution_category", item);
        }
        ConnectorUtil.doBatchAction(saveData, "save");
    }

    public static void updateSolutionDomain() {
        String api = "kapi/v2/kdec/iscb/isc_solution_domain/query_solution_domain_list";
        List<Map<String, Object>> solutionDomainList = PublicResourceUtil.queryListByGet(api, null);
        DynamicObject[] saveData = new DynamicObject[solutionDomainList.size()];
        for (int i = 0; i < solutionDomainList.size(); ++i) {
            DynamicObject object;
            Map<String, Object> item = solutionDomainList.get(i);
            if ("0".equals(item.get("parent_id"))) {
                item.put("parent", "");
            }
            saveData[i] = object = DynamicObjectUtil.map2Object("isc_solution_domain", item);
        }
        ConnectorUtil.doBatchAction(saveData, "save");
    }

    public static void saveSolutionAndResource(Map<String, Object> solution) {
        SolutionUtil.uploadLogo(solution);
        SolutionUtil.setResource(solution);
        ImportDynamicObject.innerImport(Json.toString(solution));
    }

    public static void setResource(Map<String, Object> solution) {
        long id = D.l((Object)solution.get("id"));
        solution.put("$id", id);
        solution.put("$entityname", "isc_solution_center_m");
        solution.put("$isref", Boolean.FALSE);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(1);
        params.put("id", id);
        List<Map<String, Object>> list = PublicResourceUtil.queryListByGet("kapi/v2/kdec/iscb/isc_solution_center/load_solution", params);
        if (CollectionUtils.isEmpty(list)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6%s\u672a\u80fd\u83b7\u53d6\u89e3\u51b3\u65b9\u6848\u8be6\u60c5\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u8d44\u6e90\u5217\u8868\u3002", (String)"SolutionUtil_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]), params));
        }
        if (list.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6%s\u83b7\u53d6\u5230\u591a\u4e2a\u89e3\u51b3\u65b9\u6848\u8be6\u60c5\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"SolutionUtil_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]), params));
        }
        Map<String, Object> solutionResource = list.get(0);
        SolutionResourceUtil.removeUnnecessaryFields(solutionResource);
        DynamicObject object = DynamicObjectUtil.map2Object("isc_solution_center_m", solutionResource);
        if (object.getDynamicObjectCollection("main_resources").isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e91\u7aef\u8d44\u6e90\u5217\u8868\u4e3a\u7a7a\u4e0d\u652f\u6301\u4e0b\u8f7d\uff0c\u8bf7\u67e5\u9605\u8be6\u7ec6\u4fe1\u606f\u5e76\u54a8\u8be2\u5bf9\u5e94\u9879\u76ee\u7ec4\u83b7\u53d6\u652f\u6301\u3002", (String)"SolutionUtil_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        solution.put("main_resources", solutionResource.get("main_resources"));
        solution.put("ref_resources", solutionResource.get("ref_resources"));
    }

    public static void uploadLogo(Map<String, Object> solution) {
        String logo = D.s((Object)solution.get("logo"));
        if (StringUtils.isNotBlank((CharSequence)logo)) {
            solution.put("logo", SolutionResourceUtil.uploadLogoToFileServer(logo));
        }
    }

    public static void saveMainContents(long billId, List<DynamicObject> entries, boolean override) {
        if (entries.isEmpty()) {
            return;
        }
        String operation = SolutionUtil.setOperation(override);
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            String pk;
            String entity;
            Object[] params;
            DynamicObject e = entries.get(i);
            if (e.getDataEntityType().getName().equals("main_resources")) {
                params = new Object[12];
                params[0] = billId;
                params[1] = IDService.get().genLongId();
                params[2] = i + 1;
                params[3] = operation;
                params[4] = e.getString("main_res_name");
                params[5] = e.getString("main_res_number");
                params[6] = D.t((Object)e.get("main_res_time"));
                entity = e.getString("main_res_type");
                pk = D.s((Object)e.get("main_res_pk"));
                params[7] = SolutionUtil.getLocalTime(entity, pk);
                params[8] = "READY";
                params[9] = e.getString("main_res_content_tag");
                params[10] = pk;
                params[11] = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName() + "(" + entity + ")";
                allParams.add(params);
                continue;
            }
            params = new Object[12];
            params[0] = billId;
            params[1] = IDService.get().genLongId();
            params[2] = i + 1;
            params[3] = operation;
            params[4] = e.getString("ref_res_name");
            params[5] = e.getString("ref_res_number");
            params[6] = D.t((Object)e.get("ref_res_time"));
            entity = e.getString("ref_res_type");
            pk = D.s((Object)e.get("ref_res_pk"));
            params[7] = SolutionUtil.getLocalTime(entity, pk);
            params[8] = "READY";
            params[9] = e.getString("ref_res_content_tag");
            params[10] = pk;
            params[11] = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName() + "(" + entity + ")";
            allParams.add(params);
        }
        String sql = "INSERT INTO T_ISCB_DTS_IMP_MRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,    FCONTENT,FRES_PK, FTYPE)VALUES(?,?,?,?,    ?,?,?,?,?,    ?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, allParams);
    }

    private static String setOperation(boolean override) {
        String operation = override ? "UPDATE" : "INSERT";
        return operation;
    }

    public static void saveRefContents(long billId, List<DynamicObject> entries, boolean override) {
        if (entries.isEmpty()) {
            return;
        }
        String operation = SolutionUtil.setOperation(override);
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            String pk;
            String entity;
            Object[] params;
            DynamicObject e = entries.get(i);
            if (e.getDataEntityType().getName().equals("main_resources")) {
                params = new Object[12];
                params[0] = billId;
                params[1] = IDService.get().genLongId();
                params[2] = i + 1;
                params[3] = operation;
                params[4] = e.getString("main_res_name");
                params[5] = e.getString("main_res_number");
                params[6] = D.t((Object)e.get("main_res_time"));
                entity = e.getString("main_res_type");
                pk = D.s((Object)e.get("main_res_pk"));
                params[7] = SolutionUtil.getLocalTime(entity, pk);
                params[8] = "READY";
                params[9] = e.getString("main_res_content_tag");
                params[10] = pk;
                params[11] = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName() + "(" + entity + ")";
                allParams.add(params);
                continue;
            }
            params = new Object[12];
            params[0] = billId;
            params[1] = IDService.get().genLongId();
            params[2] = i + 1;
            params[3] = operation;
            params[4] = e.getString("ref_res_name");
            params[5] = e.getString("ref_res_number");
            params[6] = D.t((Object)e.get("ref_res_time"));
            entity = e.getString("ref_res_type");
            pk = D.s((Object)e.get("ref_res_pk"));
            params[7] = SolutionUtil.getLocalTime(entity, pk);
            params[8] = "READY";
            params[9] = e.getString("ref_res_content_tag");
            params[10] = pk;
            params[11] = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName() + "(" + entity + ")";
            allParams.add(params);
        }
        String sql = "INSERT INTO T_ISCB_DTS_IMP_RRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,    FCONTENT,FRES_PK,FTYPE)VALUES(?,?,?,?,     ?,?,?,?,    ?,?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, allParams);
    }
}

