/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution.resources;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.solution.resources.DependentParser;
import kd.isc.iscb.platform.core.solution.resources.ResourceMapping;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;

public class DeployResourceFromSolution {
    private static final String FTYPE = "ftype";
    private final String SOLUTION_NUMBER;
    private final ResourceMapping resourceMapping = new ResourceMapping();

    public DeployResourceFromSolution(String solutionNumber) {
        this.SOLUTION_NUMBER = solutionNumber;
        this.queryResourcesFromSolution();
    }

    private void queryResourcesFromSolution() {
        String mainResSql = "select en.fid, en.fentryid, en.ftype, en.fnumber, en.fname, en.fres_pk, en.fres_time, en.fcontent_tag, so.fnumber as solution_number from t_isc_solution_mr en, t_isc_solution_center so where so.fnumber = ? and en.fid = so.fid";
        String refResSql = "select en.fid, en.fentryid, en.ftype, en.fnumber, en.fname, en.fres_pk, en.fres_time, en.fcontent_tag, so.fnumber as solution_number from t_isc_solution_rr en, t_isc_solution_center so where so.fnumber = ? and en.fid = so.fid";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List mainDataRows = DbUtil.executeList((Connection)cn, (String)mainResSql, Collections.singletonList(this.SOLUTION_NUMBER), Collections.singletonList(12));
            List refDataRows = DbUtil.executeList((Connection)cn, (String)refResSql, Collections.singletonList(this.SOLUTION_NUMBER), Collections.singletonList(12));
            this.addResourcesToMapping(mainDataRows, refDataRows);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void addResourcesToMapping(List<DataRow> mainDataRows, List<DataRow> refDataRows) {
        DynamicObjectCollection mainResources;
        for (DataRow row : mainDataRows) {
            mainResources = BusinessDataServiceHelper.newDynamicObject((String)"isc_solution_center").getDynamicObjectCollection("main_resources");
            DynamicObject mainResRow = mainResources.addNew();
            mainResRow.set("id", row.get((Object)"fentryid"));
            mainResRow.set("main_res_type", row.get((Object)FTYPE));
            mainResRow.set("main_res_number", row.get((Object)"fnumber"));
            mainResRow.set("main_res_name", row.get((Object)"fname"));
            mainResRow.set("main_res_pk", row.get((Object)"fres_pk"));
            mainResRow.set("main_res_time", row.get((Object)"fres_time"));
            mainResRow.set("main_res_content_tag", row.get((Object)"fcontent_tag"));
            this.resourceMapping.addMainResMapping(D.s((Object)row.get((Object)FTYPE)), mainResRow);
        }
        for (DataRow row : refDataRows) {
            mainResources = BusinessDataServiceHelper.newDynamicObject((String)"isc_solution_center").getDynamicObjectCollection("ref_resources");
            DynamicObject refResRow = mainResources.addNew();
            refResRow.set("id", row.get((Object)"fentryid"));
            refResRow.set("ref_res_type", row.get((Object)FTYPE));
            refResRow.set("ref_res_number", row.get((Object)"fnumber"));
            refResRow.set("ref_res_name", row.get((Object)"fname"));
            refResRow.set("ref_res_pk", row.get((Object)"fres_pk"));
            refResRow.set("ref_res_time", row.get((Object)"fres_time"));
            refResRow.set("ref_res_content_tag", row.get((Object)"fcontent_tag"));
            this.resourceMapping.addRefResMapping(D.s((Object)row.get((Object)FTYPE)), refResRow);
        }
    }

    public List<DynamicObject> loadDependencies(long entryid) {
        Map<String, Object> data = this.resourceMapping.load(entryid);
        String entity = D.s((Object)data.get("$entityname"));
        DependentParser parser = new DependentParser(entity, data, this.resourceMapping);
        List<Pair<String, String>> resKeys = parser.parse();
        ArrayList<Pair<String, String>> newKeys = new ArrayList<Pair<String, String>>(resKeys.size());
        for (Pair<String, String> pair : resKeys) {
            if (((String)pair.getA()).equals(D.s((Object)data.get("$entityname"))) && ((String)pair.getB()).equals(D.s((Object)data.get("id")))) continue;
            newKeys.add(pair);
        }
        return this.resourceMapping.findEntryByKey(newKeys);
    }

    public DynamicObject loadMain(long entryid) {
        return this.resourceMapping.get(entryid);
    }
}

