/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.starter;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.starter.StarterType;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.connector.s.IDUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceTask;

public abstract class AbstractMqStarter {
    private static final String FIELD_MESSAGE_TAG = "message_tag";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_DETAIL_TAG = "detail_tag";
    private static final String FIELD_DETAIL = "detail";
    private static final String FIELD_STATE = "state";
    private static final String FIELD_BOID = "boid";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_ENTITY = "entity";
    private static final String FIELD_FUNCTION = "function";
    private static final String FIELD_APPID = "appid";
    private static final String ISC_MQ_STARTER_LOG = "isc_mq_starter_log";
    private static final String FIELD_ID = "id";
    protected static final Log LOGGER = LogFactory.getLog(AbstractMqStarter.class);

    public abstract Object start(Map<String, Object> var1);

    public abstract StarterType getStarterType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startService(String messageId, Map<String, Object> message, MessageAcker ack) {
        DynamicObject log = this.generateLog(messageId, message);
        try {
            boolean isNew = this.generateId(log, messageId, message);
            this.handleMessage(log, isNew, message);
        }
        catch (Exception e) {
            this.saveLog(log, null, e);
        }
        finally {
            this.ack(messageId, ack);
        }
    }

    private void handleMessage(final DynamicObject log, Boolean isNew, final Map<String, Object> message) {
        if (!isNew.booleanValue()) {
            this.saveIgnoreLog(log);
            return;
        }
        TraceStack.run(TraceType.IMQC, D.s((Object)log.get(FIELD_FUNCTION)), log.getLong(FIELD_ID), new TraceTask(){

            public void run() {
                Object result = AbstractMqStarter.this.start(message);
                AbstractMqStarter.this.saveLog(log, result, null);
            }
        });
    }

    private void ack(String messageId, MessageAcker ack) {
        if (ack != null) {
            ack.ack(messageId);
        }
    }

    private boolean generateId(DynamicObject log, String messageId, Map<String, Object> data) {
        String numberKey = this.getStarterType().getNumberKey();
        String apiNumber = D.s((Object)data.get(numberKey));
        String appId = D.s((Object)data.get(FIELD_APPID));
        String entity = D.s((Object)data.get(FIELD_ENTITY));
        String operation = D.s((Object)data.get(FIELD_OPERATION));
        String boid = D.s((Object)data.get(FIELD_BOID));
        Assert.notNull((Object)apiNumber, (String)String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801[%s]\u4e0d\u80fd\u4e3a\u7a7a.", (String)"AbstractMqStarter_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), numberKey));
        Assert.notNull((Object)appId, (String)ResManager.loadKDString((String)"\u5e94\u7528ID[appid]\u4e0d\u80fd\u4e3a\u7a7a.", (String)"AbstractMqStarter_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Assert.notNull((Object)entity, (String)ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801[entity]\u4e0d\u80fd\u4e3a\u7a7a.", (String)"AbstractMqStarter_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Assert.notNull((Object)operation, (String)ResManager.loadKDString((String)"\u64cd\u4f5c[operation]\u4e0d\u80fd\u4e3a\u7a7a.", (String)"AbstractMqStarter_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Assert.notNull((Object)boid, (String)ResManager.loadKDString((String)"\u5355\u636eid[boid]\u4e0d\u80fd\u4e3a\u7a7a.", (String)"AbstractMqStarter_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        String function = this.getStarterType().name();
        long id = D.l((Object)IDUtil.newIerpID((Object)String.join((CharSequence)",", function, appId, entity, operation, boid, messageId)));
        return this.innerGenerateId(log, function, appId, entity, operation, boid, id);
    }

    private boolean innerGenerateId(DynamicObject log, String function, String appId, String entity, String operation, String boid, long id) {
        boolean isNew;
        DynamicObject object = QueryServiceHelper.queryOne((String)ISC_MQ_STARTER_LOG, (String)"function,appid,entity,operation,boid", (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "=", (Object)id)});
        if (object != null) {
            if (this.equalsFields(function, appId, entity, operation, boid, object)) {
                isNew = false;
                id = this.findUniqueId(function, appId, entity, operation, boid, id);
            } else {
                isNew = true;
                id = this.findUniqueId(function, appId, entity, operation, boid, id);
            }
        } else {
            isNew = true;
        }
        log.set(FIELD_ID, (Object)id);
        return isNew;
    }

    private long findUniqueId(String function, String appId, String entity, String operation, String boid, long id) {
        ++id;
        while (this.isDuplicateMessage(id, function, appId, entity, operation, boid)) {
            ++id;
        }
        return id;
    }

    private boolean isDuplicateMessage(long id, String function, String appId, String entity, String operation, String boid) {
        DynamicObject object = QueryServiceHelper.queryOne((String)ISC_MQ_STARTER_LOG, (String)"function,appid,entity,operation,boid", (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "=", (Object)id)});
        if (object == null) {
            return false;
        }
        return this.equalsFields(function, appId, entity, operation, boid, object);
    }

    private boolean equalsFields(String function, String appId, String entity, String operation, String boid, DynamicObject object) {
        return function.equals(object.getString(FIELD_FUNCTION)) && appId.equals(object.getString(FIELD_APPID)) && entity.equals(object.getString(FIELD_ENTITY)) && operation.equals(object.getString(FIELD_OPERATION)) && boid.equals(object.getString(FIELD_BOID));
    }

    private void saveLog(DynamicObject log, Object result, Exception e) {
        try {
            if (e == null) {
                log.set(FIELD_STATE, (Object)"S");
                String s = D.s((Object)result);
                if (s != null && s.length() > 150) {
                    log.set(FIELD_DETAIL, (Object)StringUtil.trim((String)s, (int)150));
                    log.set(FIELD_DETAIL_TAG, (Object)s);
                } else {
                    log.set(FIELD_DETAIL, (Object)s);
                }
            } else {
                log.set(FIELD_STATE, (Object)"F");
                String stack = StringUtil.toString((Throwable)e);
                log.set(FIELD_DETAIL, (Object)StringUtil.trim((String)stack, (int)150));
                log.set(FIELD_DETAIL_TAG, (Object)stack);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        catch (Exception ex) {
            LOGGER.warn("failed to save isc_mq_starter_log", (Throwable)ex);
        }
    }

    private void saveIgnoreLog(DynamicObject log) {
        try {
            log.set(FIELD_STATE, (Object)"N");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        catch (Exception ex) {
            LOGGER.warn("failed to save isc_mq_starter_log", (Throwable)ex);
        }
    }

    private DynamicObject generateLog(String messageId, Map<String, Object> data) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)ISC_MQ_STARTER_LOG);
        log.set("messageid", (Object)messageId);
        log.set(FIELD_FUNCTION, (Object)this.getStarterType().name());
        log.set(FIELD_APPID, (Object)D.s((Object)data.get(FIELD_APPID)));
        log.set(FIELD_ENTITY, (Object)D.s((Object)data.get(FIELD_ENTITY)));
        log.set(FIELD_OPERATION, (Object)D.s((Object)data.get(FIELD_OPERATION)));
        log.set(FIELD_BOID, (Object)D.s((Object)data.get(FIELD_BOID)));
        log.set(FIELD_NUMBER, (Object)D.s((Object)data.get(this.getStarterType().getNumberKey())));
        log.set("received_time", (Object)D.t((Object)System.currentTimeMillis()));
        log.set(FIELD_MESSAGE, (Object)StringUtil.trim((String)Json.toString(data), (int)50));
        log.set(FIELD_MESSAGE_TAG, (Object)Json2.toString(data));
        return log;
    }
}

