/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.syndata.ProgressCache;
import kd.isc.iscb.platform.core.syndata.SynDataUtil;
import kd.isc.iscb.platform.core.syndata.SyncDataJobFactory;

public class SyncDataJob
implements Job {
    public static final JobFactory FACTORY = new SyncDataJobFactory();
    private long id;
    private String title;
    private ProgressCache progressCache;

    public SyncDataJob(long id, String title) {
        this.id = id;
        this.title = title;
    }

    @Override
    public String getParam() {
        return String.valueOf(this.id);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        this.progressCache = new ProgressCache(0, 0);
        SynDataUtil.executeSyncData(this.id, this.progressCache);
    }

    @Override
    public long getOwnerId() {
        return this.id;
    }

    @Override
    public String refreshProgress() {
        return this.progressCache.getCompleted() + "/" + this.progressCache.getTotal();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.progressCache.getTotal(), this.progressCache.getCompleted(), String.format(ResManager.loadKDString((String)"\u5171\uff1a%1$s\u6761\uff0c\u5df2\u540c\u6b65\uff1a%2$s\u6761\u3002", (String)"SyncDataJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.progressCache.getTotal(), this.progressCache.getCompleted()));
    }

    @Override
    public String getJobSummary() {
        return String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5b8c\u6210\uff0c\u5171\u540c\u6b65 %s \u6761\u3002", (String)"SyncDataJob_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.progressCache.getTotal());
    }
}

