/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.meta.SyncProgressRefresher;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class SyncDataProgressRefresher
extends SyncProgressRefresher {
    private static Log logger = LogFactory.getLog(SyncDataProgressRefresher.class);
    private IAppCache cache;

    public SyncDataProgressRefresher(String id, Object logId) {
        if (StringUtil.isEmpty((String)id)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a", (String)"SyncDataProgressRefresher_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.cache = AppCache.get((String)("ISCB_SYNC_" + id));
        this.cache.put("log_id", logId);
    }

    @Override
    public int refresh(int i, int total) {
        try {
            if (this.cache.get("startprogress", String.class) != null) {
                float value = Math.min(100.0f, (float)(i + 1) * 100.0f / (float)(total + 1));
                String progress = SyncDataProgressRefresher.getNumberFormatter().format(value);
                this.cache.put("progress", (Object)progress);
                if (this.isStop()) {
                    return -1;
                }
            }
            return i;
        }
        catch (Throwable e) {
            logger.warn(e);
            return i;
        }
    }

    @Override
    public void reset() {
    }

    @Override
    protected boolean isStop() {
        String startProgress = (String)this.cache.get("startprogress", String.class);
        return !StringUtils.isBlank((String)startProgress) && "false".equals(startProgress);
    }

    @Override
    public void notifyError() {
        this.cache.put("text", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u51fa\u73b0\u5f02\u5e38!", (String)"SyncDataProgressRefresher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.cache.put("startprogress", (Object)"false");
        this.cache.put("progress", (Object)"100");
    }
}

