/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.syndata.AbstractSynData;
import kd.isc.iscb.platform.core.syndata.DataResp;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class TableSynData
extends AbstractSynData {
    private static final String NAME = "name";
    private static final String CUS_FIELD_3 = "cus_field3";
    private static final String CUS_FIELD_2 = "cus_field2";
    private static final String CUS_FIELD_1 = "cus_field1";

    public TableSynData(DynamicObject baseSchema) {
        super(baseSchema);
    }

    public TableSynData(DynamicObject baseSchema, boolean isLog) {
        super(baseSchema, isLog);
    }

    @Override
    public String getOid(Map<String, Object> item) {
        return D.s((Object)item.get("oid"));
    }

    @Override
    public void updateBaseData(DynamicObject baseData, Map<String, Object> item) {
        baseData.set("number", (Object)D.s((Object)item.get("number1")));
        baseData.set(NAME, (Object)D.s((Object)item.get(NAME)));
        baseData.set(CUS_FIELD_1, (Object)D.s((Object)item.get("c1")));
        baseData.set(CUS_FIELD_2, (Object)D.s((Object)item.get("c2")));
        baseData.set(CUS_FIELD_3, (Object)D.s((Object)item.get("c3")));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{baseData});
    }

    @Override
    public void insertBaseData(long baseSchemaId, long dataSchemaId, Map<String, Object> item) {
        DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)"isc_basic_data");
        newObject.set("oid", (Object)D.s((Object)item.get("oid")));
        newObject.set("number", (Object)D.s((Object)item.get("number1")));
        newObject.set(NAME, (Object)D.s((Object)item.get(NAME)));
        newObject.set(CUS_FIELD_1, (Object)D.s((Object)item.get("c1")));
        newObject.set(CUS_FIELD_2, (Object)D.s((Object)item.get("c2")));
        newObject.set(CUS_FIELD_3, (Object)D.s((Object)item.get("c3")));
        newObject.set("baseschema", (Object)baseSchemaId);
        newObject.set("dataschema", (Object)dataSchemaId);
        newObject.set("enable", (Object)"1");
        newObject.set("status", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
    }

    @Override
    public DataResp<? extends Map<String, Object>> queryData(ConnectionWrapper connectionWrapper, DynamicObject dataSchema) {
        Table table = connectionWrapper.getTable(dataSchema.getString("table_name"));
        String sql = this.generateSelectSql(table, this.baseSchema);
        long count = connectionWrapper.executeCount(sql, new ArrayList<Object>(), new ArrayList<Integer>());
        ObjectReader<DataRow> reader = connectionWrapper.executeQuery(sql, new ArrayList<Object>(), new ArrayList<Integer>());
        return new DataResp<DataRow>(count, reader);
    }

    @Override
    public long queryCount(ConnectionWrapper connectionWrapper, DynamicObject dataSchema) {
        Table table = connectionWrapper.getTable(dataSchema.getString("table_name"));
        String sql = "SELECT COUNT(*) FROM " + table.getQuotedName();
        return connectionWrapper.executeCount(sql, new ArrayList<Object>(), new ArrayList<Integer>());
    }

    private String generateSelectSql(Table table, DynamicObject baseSchema) {
        Column pk = table.getPrimaryKey();
        if (pk == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5355\u5b57\u6bb5\u4e3b\u952e\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u53c2\u7167\u6570\u636e\u3002", (String)"TableSynData_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), table.getName()));
        }
        Column number = table.getField(baseSchema.getString("number_field"));
        Column name = table.getField(baseSchema.getString("name_field"));
        String cus_field1 = D.s((Object)baseSchema.get(CUS_FIELD_1));
        String cus_field2 = D.s((Object)baseSchema.get(CUS_FIELD_2));
        String cus_field3 = D.s((Object)baseSchema.get(CUS_FIELD_3));
        Column c1 = cus_field1 != null ? table.getField(cus_field1) : null;
        Column c2 = cus_field2 != null ? table.getField(cus_field2) : null;
        Column c3 = cus_field3 != null ? table.getField(cus_field3) : null;
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(pk.getBinding()).append(" oid,").append(number.getBinding()).append(" number1,").append(name.getBinding()).append(" name");
        if (c1 != null) {
            sb.append(',').append(c1.getBinding()).append(" c1");
        }
        if (c2 != null) {
            sb.append(',').append(c2.getBinding()).append(" c2");
        }
        if (c3 != null) {
            sb.append(',').append(c3.getBinding()).append(" c3");
        }
        sb.append(" from ");
        sb.append(table.getQuotedName());
        return sb.toString();
    }
}

