/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.data.LocalCache;
import kd.isc.iscb.util.except.TaskCancelException;

public class SignalManager {
    private static final ThreadLocal<Set<String>> tasks = new ThreadLocal();
    private static final LocalCache<String, Signal> cache = new LocalCache(128);
    private static final Log log = LogFactory.getLog(TaskManager.class);

    public static void checkCancelSignal() throws TaskCancelException {
        if (cache.isEmpty()) {
            return;
        }
        Set<String> set = tasks.get();
        if (set != null) {
            for (String taskId : set) {
                SignalManager.checkCancelSignal(taskId);
            }
        }
    }

    private static void checkCancelSignal(String taskId) {
        Signal params;
        try {
            params = (Signal)cache.get((Object)taskId);
        }
        catch (Throwable e) {
            log.warn(e);
            return;
        }
        if (params != null && "cancel".equals(params.signal)) {
            String name = params.userName;
            throw new TaskCancelException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u201c%s\u201d\u7684\u64a4\u9500\u8bf7\u6c42\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)"SignalManager_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
        }
    }

    public static void sendCancelSignal(String taskId) {
        String name = RequestContext.get().getUserName();
        SignalManager.putCancelSignal(taskId, name);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)SignalManager.class.getName(), (String)"innerSaveCancelSignal", (Object[])new Object[]{taskId, name});
    }

    public static void innerSaveCancelSignal(String taskId, String name) {
        SignalManager.putCancelSignal(taskId, name);
    }

    private static void removeSignal(String taskId) {
        try {
            if (cache.remove((Object)taskId) != null) {
                BroadcastService.broadcastMessageWithApp((String)"iscb", (String)SignalManager.class.getName(), (String)"innerRemoveSignal", (Object[])new Object[]{taskId});
            }
        }
        catch (Throwable e) {
            log.warn(e);
        }
    }

    public static void innerRemoveSignal(String taskId) {
        cache.remove((Object)taskId);
    }

    private static void putCancelSignal(String taskId, String name) {
        cache.put((Object)taskId, (Object)new Signal(name, "cancel", taskId));
    }

    public static void unregisterTask(String taskId) {
        if (taskId != null) {
            SignalManager.innerUnregisterTask(taskId);
            SignalManager.removeSignal(taskId);
        }
    }

    private static void innerUnregisterTask(String taskId) {
        Set<String> set = tasks.get();
        if (set != null) {
            set.remove(taskId);
            if (set.isEmpty()) {
                tasks.remove();
            }
        }
    }

    public static void registerTask(String taskId) {
        if (taskId != null) {
            SignalManager.innerRegisterTask(taskId);
        }
    }

    public static void registerBackTask(String taskId) {
        if (taskId != null) {
            SignalManager.registerTask(taskId);
        }
    }

    private static void innerRegisterTask(String taskId) {
        Set<String> set = tasks.get();
        if (set == null) {
            set = new HashSet<String>();
            tasks.set(set);
        } else if (set.size() > 100) {
            set.clear();
            log.warn("\u7591\u4f3c\u5185\u5b58\u6cc4\u6f0f, \u6267\u884c\u4e2d\u4efb\u52a1\u6ce8\u518c\u6570\u8d85\u8fc7\u4e86100\u4e2a.");
        }
        set.add(taskId);
    }

    public static List<String> currentTasks() {
        Set<String> set = tasks.get();
        if (set == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(set);
    }

    public static void registerOnSubTaskBegin(List<String> tasks) {
        SignalManager.tasks.set(new HashSet<String>(tasks));
    }

    public static void unregisterOnSubTaskEnd() {
        tasks.remove();
    }

    static {
        ScheduleManager.submit((Task)new DaemonTask(){
            private String id = UUID.randomUUID().toString();

            @Override
            public String getId() {
                return this.id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long now = System.currentTimeMillis();
                    for (Signal s : cache.values()) {
                        if (s.timeout >= now) continue;
                        SignalManager.removeSignal(s.taskId);
                    }
                }
                finally {
                    ScheduleManager.submit((Task)this, 5);
                }
            }
        }, 5);
    }

    private static final class Signal {
        private static final String CANCEL = "cancel";
        private String userName;
        private String signal;
        private long timeout = System.currentTimeMillis() + 180000L;
        private String taskId;

        private Signal(String userName, String signal, String taskId) {
            this.userName = userName;
            this.signal = signal;
            this.taskId = taskId;
        }
    }
}

