/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.util.SystemProperties;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskWorker;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.trace.TraceItem;

public class TaskManager {
    private static final TaskWorker queue;

    public static String getInstanceId() {
        return Hash.md5((String)Instance.getInstanceId()).toUpperCase() + "@" + Hash.mur16((Object[])new Object[]{Instance.getClusterName()});
    }

    public static String getClusterId() {
        return Hash.mur16((Object[])new Object[]{Instance.getClusterName()});
    }

    public static int getQueueSize() {
        return queue.getQueueSize();
    }

    public static Set<String> getBusyAccounts() {
        return queue.getBusyAccounts();
    }

    public static void submit(Task task) {
        queue.submit(task);
    }

    public static void submit(Task task, RequestContext ctx) {
        queue.submit(task, ctx);
    }

    static void submit(Task task, TraceItem current, RequestContext ctx) {
        queue.submit(task, current, ctx);
    }

    public static boolean exists(String taskId) {
        return queue.exists(taskId);
    }

    public static int tasksBefore(String taskId) {
        return queue.tasksBefore(taskId);
    }

    static {
        int count;
        try {
            count = D.i((Object)SystemProperties.getWithEnv((String)"ISC_TASK_THREADS"));
            if (count <= 0) {
                count = 16;
            }
        }
        catch (Exception e) {
            count = 16;
        }
        queue = new TaskWorker("ISC_TASK_WORKER", Math.max(5, count));
    }
}

