/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.ThreadLocals;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskQueue;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.script.encoding.Murmur;
import kd.isc.iscb.util.trace.TraceItem;
import kd.isc.iscb.util.trace.TraceTask;

public final class TaskWorker {
    private int running_count = 0;
    private TaskQueue task_queue;
    private final ThreadPool workerThreadPool;
    private final int MAX_THREADS;
    private static final Log log = LogFactory.getLog(TaskWorker.class);
    private static final Map<Task, Triple<RequestContext, Thread, Long>> runningTasks = new ConcurrentHashMap<Task, Triple<RequestContext, Thread, Long>>(128);

    public void submit(Task task) {
        this.submit(task, RequestContext.get());
    }

    public void submit(Task task, RequestContext ctx) {
        TraceItem current = TraceStack.current();
        this.submit(task, current, ctx);
    }

    public void submitWithoutTrace(Task task) {
        this.submit(task, null, RequestContext.get());
    }

    public synchronized void submit(Task task, TraceItem current, RequestContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is null.");
        }
        this.task_queue.in(ctx, (Triple<TraceItem, Task, RequestContext>)new Triple((Object)current, (Object)task, (Object)ctx));
        this.startWorkThread();
    }

    public synchronized Set<String> getBusyAccounts() {
        return this.task_queue.getBusyAccounts();
    }

    public synchronized int getQueueSize() {
        return this.task_queue.size();
    }

    public synchronized boolean exists(String taskId) {
        return this.task_queue.containsTask(taskId);
    }

    private synchronized void startWorkThread() {
        if (this.running_count < this.MAX_THREADS) {
            ++this.running_count;
            this.workerThreadPool.execute((Runnable)new Worker());
        }
    }

    private synchronized void decRunningCount() {
        --this.running_count;
        if (this.task_queue.hasReadyTasks()) {
            this.startWorkThread();
        }
    }

    private synchronized Triple<TraceItem, Task, RequestContext> take() {
        if (this.task_queue.hasReadyTasks()) {
            return this.task_queue.out();
        }
        return null;
    }

    private static void execute(RequestContext ctx, Task task, TraceItem current) {
        if (ctx == null) {
            throw new NullPointerException("ctx is null.");
        }
        if (task == null) {
            throw new NullPointerException("task is null.");
        }
        if (current == null) {
            TaskWorker.innerExecute(ctx, task);
        } else {
            TaskWorker.executeWithTrace(ctx, task, current);
        }
    }

    private static void executeWithTrace(final RequestContext ctx, final Task task, TraceItem current) {
        TraceStack.trace(current, new TraceTask(){

            public void run() {
                TaskWorker.innerExecute(ctx, task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerExecute(RequestContext ctx, Task task) {
        runningTasks.put(task, (Triple<RequestContext, Thread, Long>)new Triple((Object)ctx, (Object)Thread.currentThread(), (Object)System.currentTimeMillis()));
        try {
            RequestContextCreator.restoreForMQ((RequestContext)ctx);
            task.run();
        }
        catch (Throwable e) {
            String id = task.getId() + "@" + ctx.getAccountId() + ":" + ctx.getTenantCode();
            log.warn("isc_task_failed. task=" + id, e);
        }
        finally {
            runningTasks.remove(task);
        }
    }

    private synchronized void release() {
        this.task_queue.done();
    }

    synchronized int tasksBefore(String taskId) {
        return this.task_queue.tasksBefore(taskId);
    }

    public TaskWorker(String threadPoolName, int maxThreadCount) {
        this.MAX_THREADS = maxThreadCount;
        this.workerThreadPool = ThreadPools.newCachedThreadPool((String)threadPoolName, (int)0, (int)(this.MAX_THREADS * 2), (String)"iscb");
        this.task_queue = new TaskQueue(maxThreadCount);
    }

    public static List<Map<String, Object>> getRunningTasks() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(32);
        LinkedHashMap<String, Object> env = new LinkedHashMap<String, Object>(8);
        TenantInfo tenant = LicenseCache.getTenant();
        env.put("serverId", NetUtil.getServerId());
        env.put("getStartTime", tenant.getStartTime());
        list.add(env);
        RequestContext current = RequestContext.get();
        long now = System.currentTimeMillis();
        for (Map.Entry<Task, Triple<RequestContext, Thread, Long>> item : runningTasks.entrySet()) {
            LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>(8);
            RequestContext ctx = (RequestContext)item.getValue().getA();
            String tenantId = ctx.getTenantId();
            String accountId = ctx.getAccountId();
            String suffix = current.getAccountId().equals(accountId) ? "*" : "";
            e.put("class", item.getKey().getClass().getName() + suffix);
            e.put("startTime", new Timestamp((Long)item.getValue().getC()));
            e.put("elpasedTime", now - (Long)item.getValue().getC() + "ms");
            e.put("thread", ((Thread)item.getValue().getB()).getName());
            e.put("tenant", tenantId.substring(0, 1) + "_" + Murmur.calc32((Object[])new Object[]{tenantId}));
            e.put("account", accountId.substring(accountId.length() - 4) + "_" + Murmur.calc32((Object[])new Object[]{accountId}));
            list.add(e);
        }
        return list;
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                this.executeTask();
            }
            finally {
                TaskWorker.this.decRunningCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeTask() {
            Triple p;
            while ((p = TaskWorker.this.take()) != null) {
                String tagName = ((Task)p.getB()).toString() + '@' + ((RequestContext)p.getC()).getAccountId();
                try {
                    MemSpanTrace span = MemSpanTrace.create((String)"isc_task", (String)tagName);
                    Throwable throwable = null;
                    try {
                        try {
                            TaskWorker.execute((RequestContext)p.getC(), (Task)p.getB(), (TraceItem)p.getA());
                        }
                        finally {
                            TaskWorker.this.release();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (span == null) continue;
                        if (throwable != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        span.close();
                    }
                }
                finally {
                    ThreadLocals.release();
                }
            }
        }
    }
}

