/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.trace;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.isc.iscb.platform.core.sf.runtime.ActivitySync;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.util.flow.core.FlowRuntime;

public enum TraceType {
    NEW_JOB{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u65b0\u5efa\u540e\u53f0\u4efb\u52a1", "TraceType_0", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_job_inst";
        }
    }
    ,
    EXE_JOB{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u540e\u53f0\u4efb\u52a1", "TraceType_1", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_job_inst";
        }
    }
    ,
    NEW_SFP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u65b0\u5efa\u670d\u52a1\u6d41\u7a0b\u5b9e\u4f8b", "TraceType_2", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_sf_proc_inst";
        }
    }
    ,
    EXE_SFP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u670d\u52a1\u6d41\u7a0b\u5b9e\u4f8b", "TraceType_3", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_sf_proc_inst";
        }

        @Override
        protected Map<String, Object> getExtInfo(String number, long defId, String tag) {
            FlowRuntime runtime = ProcessRuntime.loadRuntime(defId);
            return ActivitySync.getTraceInfo(runtime, tag);
        }
    }
    ,
    SFP_TW{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u670d\u52a1\u6d41\u7a0b\u65f6\u95f4\u7b49\u5f85", "TraceType_4", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_sf_proc_inst";
        }
    }
    ,
    TM_SFP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u64a4\u9500\u670d\u52a1\u6d41\u7a0b\u5b9e\u4f8b", "TraceType_5", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_sf_proc_inst";
        }
    }
    ,
    REDO_SFP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u91cd\u8bd5\u670d\u52a1\u6d41\u7a0b\u5b9e\u4f8b", "TraceType_6", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_sf_proc_inst";
        }
    }
    ,
    JUMP_SFP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6d41\u7a0b\u5b9e\u4f8b\u8df3\u8f6c", "TraceType_7", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_sf_proc_inst";
        }
    }
    ,
    IGN_SFP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5ffd\u7565\u6d3b\u52a8\u5b9e\u4f8b", "TraceType_8", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_sf_proc_inst";
        }
    }
    ,
    EXE_SFF{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u670d\u52a1\u6d41\u7a0b(F)", "TraceType_9", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_service_flow_r";
        }
    }
    ,
    NEW_DCE{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u65b0\u5efa\u6570\u636e\u96c6\u6210\u4efb\u52a1", "TraceType_10", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_data_copy_execution";
        }
    }
    ,
    EXE_DCE{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u6570\u636e\u96c6\u6210(E)", "TraceType_11", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_data_copy_execution";
        }
    }
    ,
    EXE_DCS{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u6570\u636e\u96c6\u6210(S)", "TraceType_12", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_data_copy";
        }
    }
    ,
    EXE_DCT{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u6570\u636e\u96c6\u6210(T)", "TraceType_13", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_data_copy_trigger";
        }
    }
    ,
    NEW_DCB{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u65b0\u5efa\u6570\u636e\u96c6\u6210\u5206\u6279", "TraceType_14", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_data_copy_taskstage";
        }
    }
    ,
    EXE_DCB{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u6570\u636e\u96c6\u6210\u5206\u6279", "TraceType_15", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_data_copy_taskstage";
        }
    }
    ,
    EXE_APIF{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884cAPI(F)", "TraceType_16", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity(String number) {
            int i = number.indexOf(47);
            return i < 0 ? null : number.substring(0, i);
        }
    }
    ,
    EXE_RPC{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884c\u901a\u7528RPC", "TraceType_17", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    EXE_APIL{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6267\u884cAPI(L)", "TraceType_18", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_apic_log";
        }
    }
    ,
    HTTP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("Web\u8bbf\u95ee", "TraceType_19", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    XMQC{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5916\u90e8MQ\u6d88\u8d39\u6d88\u606f", "TraceType_20", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_mq_data_received";
        }
    }
    ,
    XMQP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5916\u90e8MQ\u53d1\u5e03\u6d88\u606f", "TraceType_21", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_mq_data_published";
        }
    }
    ,
    XMQP2{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u91cd\u53d1\u5916\u90e8MQ\u6d88\u606f", "TraceType_22", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_mq_data_published";
        }
    }
    ,
    XMQB{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5916\u90e8MQ\u89e6\u53d1\u5355\u636e\u64cd\u4f5c", "TraceType_23", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_mq_bill_data_task";
        }
    }
    ,
    IMQC{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5185\u90e8MQ\u8c03\u7528", "TraceType_24", "isc-iscb-platform-core").loadKDString();
        }

        @Override
        protected String entity() {
            return "isc_mq_starter_log";
        }
    }
    ,
    IERP_BOTP{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u672c\u5730BOTP", "TraceType_25", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    EAS_BOTP{

        @Override
        public String label() {
            return "EAS-BOTP";
        }
    }
    ,
    MQ{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u6d88\u606f\u89e6\u53d1", "TraceType_26", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    MSVC{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5fae\u670d\u52a1", "TraceType_27", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    OAPI{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5f00\u653e\u5e73\u53f0", "TraceType_28", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    FRONT{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u524d\u7aef\u64cd\u4f5c", "TraceType_29", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    TIMER{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5b9a\u65f6\u6267\u884c", "TraceType_30", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    EVENT{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u4e8b\u4ef6\u89e6\u53d1", "TraceType_31", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    UNIT{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u5355\u5143\u6d4b\u8bd5", "TraceType_32", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    CALLBACK{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u8fde\u63a5\u5668\u56de\u8c03", "TraceType_33", "isc-iscb-platform-core").loadKDString();
        }
    }
    ,
    UNDEFINED{

        @Override
        public String label() {
            return new MultiLangEnumBridge("\u672a\u5b9a\u4e49", "TraceType_34", "isc-iscb-platform-core").loadKDString();
        }
    };


    protected String entity() {
        return null;
    }

    protected String entity(String number) {
        return this.entity();
    }

    protected Map<String, Object> getExtInfo(String number, long defId, String tag) {
        return Collections.emptyMap();
    }

    public abstract String label();

    public static String getEntity(String type, String number) {
        try {
            return TraceType.valueOf(type).entity(number);
        }
        catch (Exception e) {
            return type;
        }
    }

    public static String getLabel(String type) {
        try {
            return TraceType.valueOf(type).label();
        }
        catch (Exception e) {
            return type;
        }
    }

    public static Map<String, Object> getExtInfo(String type, String number, long defId, String tag) {
        try {
            return TraceType.valueOf(type).getExtInfo(number, defId, tag);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static String getTime(int millis) {
        if (millis < 1000) {
            return String.format(ResManager.loadKDString((String)"%s \u6beb\u79d2", (String)"TraceType_39", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Math.max((double)millis, 0.1));
        }
        if (millis < 60000) {
            return String.format(ResManager.loadKDString((String)"%s\u79d2", (String)"TraceType_40", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new DecimalFormat("#,###.0").format((double)millis / 1000.0));
        }
        if (millis < 3600000) {
            return String.format(ResManager.loadKDString((String)"%s\u5206\u949f", (String)"TraceType_41", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new DecimalFormat("#,###.0").format((double)millis / 60000.0));
        }
        return String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6", (String)"TraceType_42", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new DecimalFormat("#,###.0").format((double)millis / 3600000.0));
    }
}

