/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class CommonUtil {
    private static final String COMPARE_NOT_LIKE = "not like";
    private static final String COMPARE_NOT_ENDS_WITH = "NOT_ENDS_WITH";
    private static final String COMPARE_NOT_CONTAINS = "NOT_CONTAINS";
    private static final String COMPARE_NOT_STARTS_WITH = "NOT_STARTS_WITH";
    private static final String COMPARE_ENDS_WITH = "ENDS_WITH";
    private static final String COMPARE_CONTAINS = "CONTAINS";
    private static final String COMPARE_STARTS_WITH = "STARTS_WITH";
    private static final String COMPARE_IS_NOT_NULL = "IS_NOT_NULL";
    private static final String COMPARE_IS_NULL = "IS_NULL";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_INTEGER = "integer";
    private static final String TYPE_STRING = "string";

    public static String formatDataType(String type) {
        String transType = null;
        switch (type.trim().toLowerCase(Locale.ENGLISH)) {
            case "string": {
                transType = TYPE_STRING;
                break;
            }
            case "ilocalestring": {
                transType = TYPE_STRING;
                break;
            }
            case "int": {
                transType = TYPE_INTEGER;
                break;
            }
            case "integer": {
                transType = TYPE_INTEGER;
                break;
            }
            case "long": {
                transType = TYPE_LONG;
                break;
            }
            case "boolean": {
                transType = TYPE_BOOLEAN;
                break;
            }
            case "date": {
                transType = "datetime";
                break;
            }
            case "bigdecimal": {
                transType = "decimal";
                break;
            }
            case "double": {
                transType = TYPE_DOUBLE;
                break;
            }
            case "dynamicobject": {
                transType = "REF";
                break;
            }
            case "entrytype": {
                transType = "ENTRY";
                break;
            }
            default: {
                transType = type;
            }
        }
        return transType;
    }

    public static String parseCompareType(String compare) {
        switch (compare) {
            case "STARTS_WITH": 
            case "CONTAINS": 
            case "ENDS_WITH": {
                return "like";
            }
            case "NOT_STARTS_WITH": 
            case "NOT_CONTAINS": 
            case "NOT_ENDS_WITH": {
                return COMPARE_NOT_LIKE;
            }
            case "<>": {
                return "!=";
            }
            case "IS_NULL": {
                return "is null";
            }
            case "IS_NOT_NULL": {
                return "is not null";
            }
        }
        return compare;
    }

    public static Object parseCompareValue(String compare, Object value) {
        switch (compare.toUpperCase(Locale.ENGLISH)) {
            case "STARTS_WITH": 
            case "NOT_STARTS_WITH": {
                return value + "%";
            }
            case "CONTAINS": 
            case "NOT_CONTAINS": {
                return "%" + value + "%";
            }
            case "ENDS_WITH": 
            case "NOT_ENDS_WITH": {
                return "%" + value;
            }
            case "IN": 
            case "NOT IN": {
                return CommonUtil.parseArray(value);
            }
            case "IS_NULL": 
            case "IS_NOT_NULL": {
                return null;
            }
        }
        return value;
    }

    public static void filterCompareHandle(StringBuilder filter, List<Object> values, Map<?, ?> obj, Column field, Object value, List<Integer> types) {
        value = ExprEvaluator.calc(value, null, null, null);
        String filter_compare = (String)obj.get("filter_compare");
        filter.append(' ');
        switch (filter_compare) {
            case "STARTS_WITH": {
                filter.append("like");
                values.add(value + "%");
                types.add(field.getSqlType());
                break;
            }
            case "CONTAINS": {
                filter.append("like");
                values.add("%" + value + "%");
                types.add(field.getSqlType());
                break;
            }
            case "ENDS_WITH": {
                filter.append("like");
                values.add("%" + value);
                types.add(field.getSqlType());
                break;
            }
            case "NOT_STARTS_WITH": {
                filter.append(COMPARE_NOT_LIKE);
                values.add(value + "%");
                types.add(field.getSqlType());
                break;
            }
            case "NOT_CONTAINS": {
                filter.append(COMPARE_NOT_LIKE);
                values.add("%" + value + "%");
                types.add(field.getSqlType());
                break;
            }
            case "NOT_ENDS_WITH": {
                filter.append(COMPARE_NOT_LIKE);
                values.add("%" + value);
                types.add(field.getSqlType());
                break;
            }
            case "IS_NULL": {
                filter.append("is null");
                return;
            }
            case "IS_NOT_NULL": {
                filter.append("is not null");
                return;
            }
            default: {
                filter.append(filter_compare);
                values.add(field.toSqlParam(value));
                types.add(field.getSqlType());
            }
        }
        filter.append(" ? ");
    }

    private static Object parseArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return value;
        }
        String s = value.toString();
        if (s == null) {
            return null;
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            return CommonUtil.arrayToList(s.substring(s.indexOf(91) + 1, s.lastIndexOf(93)).split(","), true);
        }
        return Collections.singletonList(value);
    }

    public static List<String> arrayToList(String[] array, boolean trim) {
        if (!trim) {
            return Arrays.asList(array);
        }
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (String s : array) {
            if (StringUtil.isEmpty((String)s)) continue;
            list.add(s.trim());
        }
        return list;
    }

    public static String join(int count, String str, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(str);
            if (i == count - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static void check(OperationResult rs) {
        if (!rs.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            List allErrorOrValidateInfo = rs.getAllErrorOrValidateInfo();
            if (!allErrorOrValidateInfo.isEmpty()) {
                for (IOperateInfo op : allErrorOrValidateInfo) {
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(op.getTitle()).append(' ').append(op.getMessage());
                }
            } else if (rs.getInteractionContext() != null) {
                sb.append(rs.getInteractionContext().getSimpleMessage());
            } else if (!StringUtil.isEmpty((String)rs.getMessage())) {
                sb.append(rs.getMessage());
            } else {
                sb.append(rs);
            }
            throw new IscBizException(sb.toString());
        }
    }

    public static String getEntityName(String entity) {
        return EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return D.s((Object)value) == null;
        }
        if (value instanceof Number) {
            return D.l((Object)value) == 0L;
        }
        return false;
    }

    public static boolean isIllegalString(String alias) {
        if (D.s((Object)alias) == null) {
            return true;
        }
        char charAt = alias.charAt(0);
        if (charAt > '0' && charAt < '9') {
            return true;
        }
        for (int j = 0; j < alias.length(); ++j) {
            char c = alias.charAt(j);
            if (CommonUtil.matches(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    public static OperateOption getSkipPermissionOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        return option;
    }
}

