/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class FileUtil {
    private static final Pattern ILLEGAL_CHAR_PATTERN = Pattern.compile("[\\s\\\\/:*?\"<>|@#$%^!&`']");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String SUFFIX = ".dts";
    private static Log logger = LogFactory.getLog(FileUtil.class);
    private static String[] speChar = new String[]{"+", "/", "?", "%", "#", "&", "="};

    public static String removeIllegalChar(String fileName) {
        Matcher matcher = ILLEGAL_CHAR_PATTERN.matcher(fileName);
        return matcher.replaceAll("");
    }

    public static String replaceSpeChar(String str) {
        for (String s : speChar) {
            if (!str.contains(s)) continue;
            str = str.replace(s, "");
        }
        return str;
    }

    public static String getLocalPath(String fileName) {
        return FileUtil.getLocalPath(fileName, SUFFIX);
    }

    public static String getLocalPath(String fileName, String suffix) {
        String filePath = USER_HOME + File.separator + "downloads" + File.separator + "temp" + File.separator + fileName + suffix;
        FileUtil.checkFilePath(filePath);
        File file = new File(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
            try {
                boolean isExisted = file.createNewFile();
                if (isExisted) {
                    logger.warn("[" + filePath + "]\u6587\u4ef6\u8def\u5f84\u4e0b\u5df2\u5b58\u5728\u6587\u4ef6[" + fileName + "]");
                }
            }
            catch (IOException e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728%s\u4e0b\u521b\u5efa\u6587\u4ef6\u6216\u76ee\u5f55\u5f02\u5e38\uff01", (String)"FileUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filePath), (Throwable)e);
            }
        }
        return filePath;
    }

    public static boolean delete(String filePath) {
        if (filePath == null) {
            return false;
        }
        FileUtil.checkFilePath(filePath);
        File file = new File(filePath);
        boolean result = false;
        if (file.listFiles() == null) {
            result = file.delete();
        }
        if (!result) {
            logger.warn("\u5220\u9664\u6587\u4ef6" + filePath + "\u5931\u8d25!");
        }
        return result;
    }

    public static void delete(List<String> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return;
        }
        for (String path : paths) {
            FileUtil.delete(path);
        }
    }

    public static void delete(File file) {
        if (file != null) {
            FileUtil.delete(file.getAbsolutePath());
        }
    }

    public static void deleteAll(File file) {
        boolean delete;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                if (!file.delete()) {
                    logger.warn("\u5220\u9664\u6587\u4ef6\u5939\uff1a" + file.getAbsolutePath() + "\u5931\u8d25.");
                }
            } else {
                for (File f : files) {
                    FileUtil.deleteAll(f);
                }
            }
        }
        if (!(delete = file.delete())) {
            logger.warn("\u5220\u9664\u6587\u4ef6" + file.getAbsolutePath() + "\u5931\u8d25.");
        }
    }

    public static String checkDirectory(boolean createDir, String dir) {
        dir = dir.replace('/', File.separatorChar);
        dir = dir.replace('\\', File.separatorChar);
        dir = dir.trim();
        if (!createDir) {
            return dir;
        }
        FileUtil.checkFilePath(dir);
        File file = new File(dir);
        if (file.exists()) {
            return dir;
        }
        int i = dir.indexOf(File.separatorChar, 1);
        while (i > 0) {
            file = new File(dir.substring(0, i));
            if (!file.exists() && !file.mkdir()) {
                throw new RuntimeException("Create file directory " + file + " failed!");
            }
            i = dir.indexOf(File.separatorChar, i + 1);
        }
        file = new File(dir);
        if (!file.exists() && !file.mkdir()) {
            throw new RuntimeException("Create file directory " + file + " failed!");
        }
        return dir;
    }

    public static File createNewFile(String path, String name, String suffix) {
        String filePath = path + File.separator + name + suffix;
        File file = new File(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    logger.warn("\u6587\u4ef6\uff1a" + filePath + "\u5df2\u5b58\u5728\u3002");
                }
            }
            catch (Exception e) {
                throw D.e((Throwable)e);
            }
        }
        return file;
    }

    public static void addDownloadPermission(String formId, String urls, String appId) {
        String tempFileId = UrlUtil.getParam((String)urls, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(3);
        refEntitiyMap.put("entityNum", formId);
        refEntitiyMap.put("appId", appId);
        refEntitiyMap.put("permissionItemId", "47150e89000000ac");
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(formId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 600);
    }

    public static void checkFilePath(String filePath) {
        kd.isc.iscb.util.misc.FileUtil.checkFilePath((String)filePath);
    }
}

