/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.sql.Timestamp;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class MappingDataUtil {
    private static final String FIELD_ID = "id";
    private static final String ISC_MAPPING_DATA = "isc_mapping_data";
    private static final String FIELD_TARGET_ID = "target_id";
    private static final String FIELD_SOURCE_ID = "source_id";
    private static final String FIELD_MAPPING_RULE = "mapping_rule";

    public static void recordMapppingValue(long ruleId, String source_id, String target_id) {
        QFilter qFilter = new QFilter(FIELD_MAPPING_RULE, "=", (Object)ruleId);
        qFilter.and(FIELD_SOURCE_ID, "=", (Object)source_id);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ISC_MAPPING_DATA, (String)FIELD_ID, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get(FIELD_ID), (String)ISC_MAPPING_DATA);
            dynamicObject.set(FIELD_TARGET_ID, (Object)target_id);
        } else {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ISC_MAPPING_DATA);
            dynamicObject.set(FIELD_MAPPING_RULE, (Object)ruleId);
            dynamicObject.set(FIELD_SOURCE_ID, (Object)source_id);
            dynamicObject.set(FIELD_TARGET_ID, (Object)target_id);
            dynamicObject.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        }
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static Object getMappingValue(String value, DynamicObject ruleConfig) {
        long ruleId = ruleConfig.getLong(FIELD_ID);
        return D.s((Object)MappingDataUtil.findMapping(ruleId, ruleConfig, value));
    }

    public static Object findMappingReverse(long ruleId, String value) {
        QFilter mapDataFilter = new QFilter(FIELD_MAPPING_RULE, "=", (Object)ruleId);
        mapDataFilter.and(FIELD_TARGET_ID, "=", (Object)value);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ISC_MAPPING_DATA, (String)FIELD_SOURCE_ID, (QFilter[])new QFilter[]{mapDataFilter});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.get(FIELD_SOURCE_ID);
    }

    private static Object findMapping(long ruleId, DynamicObject cfg, String value) {
        QFilter mapDataFilter = new QFilter(FIELD_MAPPING_RULE, "=", (Object)ruleId);
        mapDataFilter.and(FIELD_SOURCE_ID, "=", (Object)value);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ISC_MAPPING_DATA, (String)FIELD_TARGET_ID, (QFilter[])new QFilter[]{mapDataFilter});
        if (dynamicObject == null) {
            MappingDataUtil.showCustomMsg(cfg, value, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6e90\u5355ID\u4e3a\"%s\"\u7684\u6570\u636e\u884c\u3002", (String)"MappingDataUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value) + "\n");
            return null;
        }
        String tar_id = D.s((Object)dynamicObject.get(FIELD_TARGET_ID));
        if (tar_id == null) {
            MappingDataUtil.showCustomMsg(cfg, value, String.format(ResManager.loadKDString((String)"\u6e90\u5355ID\u4e3a\"%s\"\u7684\u6570\u636e\u884c\u5bf9\u5e94\u7684\u76ee\u6807\u5355ID\u4e3a\u7a7a\u3002", (String)"MappingDataUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value) + "\n");
        }
        return tar_id;
    }

    private static void showCustomMsg(DynamicObject cfg, String value, String tips) {
        if (D.s((Object)cfg.get("default_value")) == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6e90\u5b57\u6bb5\u7684\u503c\u4e3a\"%s\"\uff0c\u5230\u76ee\u6807\u5b57\u6bb5\u8f6c\u6362\u5931\u8d25\u3002", (String)"MappingDataUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value) + String.format(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u5728\u4eba\u5de5\u6620\u5c04\u5339\u914d\u7ed3\u679c\u4e2d\uff0c%s", (String)"MappingDataUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tips) + String.format(ResManager.loadKDString((String)"\u89e3\u51b3\u529e\u6cd5\uff1a\u8bf7\u901a\u8fc7\"\u6570\u636e\u96c6\u6210-\u503c\u8f6c\u6362\u89c4\u5219\"\u83dc\u5355\u8def\u5f84\uff0c\u6253\u5f00\u503c\u8f6c\u6362\u89c4\u5219\u5217\u8868\uff0c\u4f7f\u7528\u7f16\u7801\"%s\"\u8fc7\u6ee4\u51fa\u672c\u6b21\u8f6c\u6362\u5931\u8d25\u7684\u89c4\u5219\uff0c\u5728\u6570\u636e\u201c\u5339\u914d\u7ed3\u679c\u201d\u4e2d\u7ef4\u62a4\u6e90\u6570\u636e\u548c\u76ee\u6807\u6570\u636e\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"MappingDataUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s((Object)cfg.get("number"))) + ResManager.loadKDString((String)"\u4ea7\u54c1\u529f\u80fd\u6587\u6863\uff1ahttps://developer.kingdee.com/article/13838?productLineId=29&isKnowledge=2", (String)"MappingDataUtil_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(msg);
        }
    }

    public static void deleteMappingValue(long ruleId, String source_id, String target_id) {
        QFilter qFilter = new QFilter(FIELD_MAPPING_RULE, "=", (Object)ruleId);
        qFilter.and(FIELD_SOURCE_ID, "=", (Object)source_id);
        qFilter.and(FIELD_TARGET_ID, "=", (Object)target_id);
        DeleteServiceHelper.delete((String)ISC_MAPPING_DATA, (QFilter[])new QFilter[]{qFilter});
    }
}

